/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Sha2$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.GeneratedExpressionCode;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rf\u0001B\u0001\u0003\u0001>\u0011Aa\u00155be)\u00111\u0001B\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u0006\r\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001aE\u0003\u0001!QQR\u0004\u0005\u0002\u0012%5\t!!\u0003\u0002\u0014\u0005\t\u0001\")\u001b8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\t\u0003#mI!\u0001\b\u0002\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"!\u0006\u0010\n\u0005}1\"a\u0002)s_\u0012,8\r\u001e\u0005\tC\u0001\u0011)\u001a!C\u0001E\u0005!A.\u001a4u+\u0005\u0019\u0003CA\t%\u0013\t)#A\u0001\u0006FqB\u0014Xm]:j_:D\u0001b\n\u0001\u0003\u0012\u0003\u0006IaI\u0001\u0006Y\u00164G\u000f\t\u0005\tS\u0001\u0011)\u001a!C\u0001E\u0005)!/[4ii\"A1\u0006\u0001B\tB\u0003%1%\u0001\u0004sS\u001eDG\u000f\t\u0005\u0006[\u0001!\tAL\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007=\u0002\u0014\u0007\u0005\u0002\u0012\u0001!)\u0011\u0005\fa\u0001G!)\u0011\u0006\fa\u0001G!)1\u0007\u0001C!i\u0005AA-\u0019;b)f\u0004X-F\u00016!\t1\u0014(D\u00018\u0015\tAd!A\u0003usB,7/\u0003\u0002;o\tAA)\u0019;b)f\u0004X\rC\u0003=\u0001\u0011\u0005S(\u0001\u0006j]B,H\u000fV=qKN,\u0012A\u0010\t\u0004\u007f\u001d+dB\u0001!F\u001d\t\tE)D\u0001C\u0015\t\u0019e\"\u0001\u0004=e>|GOP\u0005\u0002/%\u0011aIF\u0001\ba\u0006\u001c7.Y4f\u0013\tA\u0015JA\u0002TKFT!A\u0012\f\t\u000b-\u0003A\u0011\u000b'\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\u00075\u0003&\u000b\u0005\u0002\u0016\u001d&\u0011qJ\u0006\u0002\u0004\u0003:L\b\"B)K\u0001\u0004i\u0015AB5oaV$\u0018\u0007C\u0003T\u0015\u0002\u0007Q*\u0001\u0004j]B,HO\r\u0005\u0006+\u0002!\tEV\u0001\bO\u0016t7i\u001c3f)\r9fL\u001a\t\u00031ns!!F-\n\u0005i3\u0012A\u0002)sK\u0012,g-\u0003\u0002];\n11\u000b\u001e:j]\u001eT!A\u0017\f\t\u000b}#\u0006\u0019\u00011\u0002\u0007\r$\b\u0010\u0005\u0002bI6\t!M\u0003\u0002d\u0005\u000591m\u001c3fO\u0016t\u0017BA3c\u00059\u0019u\u000eZ3HK:\u001cuN\u001c;fqRDQa\u001a+A\u0002!\f!!\u001a<\u0011\u0005\u0005L\u0017B\u00016c\u0005]9UM\\3sCR,G-\u0012=qe\u0016\u001c8/[8o\u0007>$W\rC\u0004m\u0001\u0005\u0005I\u0011A7\u0002\t\r|\u0007/\u001f\u000b\u0004_9|\u0007bB\u0011l!\u0003\u0005\ra\t\u0005\bS-\u0004\n\u00111\u0001$\u0011\u001d\t\b!%A\u0005\u0002I\fabY8qs\u0012\"WMZ1vYR$\u0013'F\u0001tU\t\u0019CoK\u0001v!\t180D\u0001x\u0015\tA\u00180A\u0005v]\u000eDWmY6fI*\u0011!PF\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001?x\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\b}\u0002\t\n\u0011\"\u0001s\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIIB\u0011\"!\u0001\u0001\u0003\u0003%\t%a\u0001\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t)\u0001\u0005\u0003\u0002\b\u0005EQBAA\u0005\u0015\u0011\tY!!\u0004\u0002\t1\fgn\u001a\u0006\u0003\u0003\u001f\tAA[1wC&\u0019A,!\u0003\t\u0013\u0005U\u0001!!A\u0005\u0002\u0005]\u0011\u0001\u00049s_\u0012,8\r^!sSRLXCAA\r!\r)\u00121D\u0005\u0004\u0003;1\"aA%oi\"I\u0011\u0011\u0005\u0001\u0002\u0002\u0013\u0005\u00111E\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\ri\u0015Q\u0005\u0005\u000b\u0003O\ty\"!AA\u0002\u0005e\u0011a\u0001=%c!I\u00111\u0006\u0001\u0002\u0002\u0013\u0005\u0013QF\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u0006\t\u0006\u0003c\t9$T\u0007\u0003\u0003gQ1!!\u000e\u0017\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003s\t\u0019D\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\ti\u0004AA\u0001\n\u0003\ty$\u0001\u0005dC:,\u0015/^1m)\u0011\t\t%a\u0012\u0011\u0007U\t\u0019%C\u0002\u0002FY\u0011qAQ8pY\u0016\fg\u000eC\u0005\u0002(\u0005m\u0012\u0011!a\u0001\u001b\"I\u00111\n\u0001\u0002\u0002\u0013\u0005\u0013QJ\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011\u0011\u0004\u0005\n\u0003#\u0002\u0011\u0011!C!\u0003'\na!Z9vC2\u001cH\u0003BA!\u0003+B\u0011\"a\n\u0002P\u0005\u0005\t\u0019A'\b\u0013\u0005e#!!A\t\u0002\u0005m\u0013\u0001B*iCJ\u00022!EA/\r!\t!!!A\t\u0002\u0005}3#BA/\u0003C\"\u0002cBA2\u0003S\u001a3eL\u0007\u0003\u0003KR1!a\u001a\u0017\u0003\u001d\u0011XO\u001c;j[\u0016LA!a\u001b\u0002f\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\t\u000f5\ni\u0006\"\u0001\u0002pQ\u0011\u00111\f\u0005\u000b\u0003g\ni&!A\u0005F\u0005U\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\u0015\u0001BCA=\u0003;\n\t\u0011\"!\u0002|\u0005)\u0011\r\u001d9msR)q&! \u0002\u0000!1\u0011%a\u001eA\u0002\rBa!KA<\u0001\u0004\u0019\u0003BCAB\u0003;\n\t\u0011\"!\u0002\u0006\u00069QO\\1qa2LH\u0003BAD\u0003'\u0003R!FAE\u0003\u001bK1!a#\u0017\u0005\u0019y\u0005\u000f^5p]B)Q#a$$G%\u0019\u0011\u0011\u0013\f\u0003\rQ+\b\u000f\\33\u0011%\t)*!!\u0002\u0002\u0003\u0007q&A\u0002yIAB!\"!'\u0002^\u0005\u0005I\u0011BAN\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005u\u0005\u0003BA\u0004\u0003?KA!!)\u0002\n\t1qJ\u00196fGR\u0004")
public class Sha2
extends BinaryExpression
implements Serializable,
ImplicitCastInputTypes {
    private final Expression left;
    private final Expression right;

    public static Function1<Tuple2<Expression, Expression>, Sha2> tupled() {
        return Sha2$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Sha2>> curried() {
        return Sha2$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{BinaryType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        UTF8String uTF8String;
        int bitLength = BoxesRunTime.unboxToInt((Object)input2);
        byte[] input = (byte[])input1;
        int n = bitLength;
        switch (n) {
            default: {
                uTF8String = null;
                break;
            }
            case 512: {
                uTF8String = UTF8String.fromString((String)DigestUtils.sha512Hex((byte[])input));
                break;
            }
            case 384: {
                uTF8String = UTF8String.fromString((String)DigestUtils.sha384Hex((byte[])input));
                break;
            }
            case 0: 
            case 256: {
                uTF8String = UTF8String.fromString((String)DigestUtils.sha256Hex((byte[])input));
                break;
            }
            case 224: {
                try {
                    MessageDigest md = MessageDigest.getInstance("SHA-224");
                    md.update(input);
                    uTF8String = UTF8String.fromBytes((byte[])md.digest());
                    break;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    uTF8String = null;
                }
            }
        }
        return uTF8String;
    }

    @Override
    public String genCode(CodeGenContext ctx, GeneratedExpressionCode ev) {
        String digestUtils = "org.apache.commons.codec.digest.DigestUtils";
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)new Serializable(this, ev, digestUtils){
            public static final long serialVersionUID = 0L;
            private final GeneratedExpressionCode ev$1;
            private final String digestUtils$1;

            public final String apply(String eval1, String eval2) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        if (", " == 224) {\n          try {\n            java.security.MessageDigest md = java.security.MessageDigest.getInstance(\"SHA-224\");\n            md.update(", ");\n            ", " = UTF8String.fromBytes(md.digest());\n          } catch (java.security.NoSuchAlgorithmException e) {\n            ", " = true;\n          }\n        } else if (", " == 256 || ", " == 0) {\n          ", " =\n            UTF8String.fromString(", ".sha256Hex(", "));\n        } else if (", " == 384) {\n          ", " =\n            UTF8String.fromString(", ".sha384Hex(", "));\n        } else if (", " == 512) {\n          ", " =\n            UTF8String.fromString(", ".sha512Hex(", "));\n        } else {\n          ", " = true;\n        }\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eval2, eval1, this.ev$1.primitive(), this.ev$1.isNull(), eval2, eval2, this.ev$1.primitive(), this.digestUtils$1, eval1, eval2, this.ev$1.primitive(), this.digestUtils$1, eval1, eval2, this.ev$1.primitive(), this.digestUtils$1, eval1, this.ev$1.isNull()}));
            }
            {
                this.ev$1 = ev$1;
                this.digestUtils$1 = digestUtils$1;
            }
        });
    }

    public Sha2 copy(Expression left, Expression right) {
        return new Sha2(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "Sha2";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                expression = this.right();
                break;
            }
            case 0: {
                expression = this.left();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Sha2;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Sha2)) return false;
        boolean bl = true;
        if (!bl) return false;
        Sha2 sha2 = (Sha2)x$1;
        Expression expression = this.left();
        Expression expression2 = sha2.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = sha2.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!sha2.canEqual(this)) return false;
        return true;
    }

    public Sha2(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes$class.$init$(this);
    }
}

