/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.codegen;

import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.BindReferences$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRowWriters;
import org.apache.spark.sql.catalyst.expressions.UnsafeWriters;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeFormatter$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator;
import org.apache.spark.sql.catalyst.expressions.codegen.GeneratedClass;
import org.apache.spark.sql.catalyst.expressions.codegen.GeneratedExpressionCode;
import org.apache.spark.sql.catalyst.expressions.codegen.package$ExpressionCanonicalizer$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.CalendarIntervalType;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class GenerateUnsafeProjection$
extends CodeGenerator<Seq<Expression>, UnsafeProjection> {
    public static final GenerateUnsafeProjection$ MODULE$;
    private final String StringWriter;
    private final String BinaryWriter;
    private final String IntervalWriter;
    private final String StructWriter;
    private final String CompactDecimalWriter;
    private final String org$apache$spark$sql$catalyst$expressions$codegen$GenerateUnsafeProjection$$DecimalWriter;
    private final String ArrayWriter;
    private final String MapWriter;

    static {
        new GenerateUnsafeProjection$();
    }

    private String StringWriter() {
        return this.StringWriter;
    }

    private String BinaryWriter() {
        return this.BinaryWriter;
    }

    private String IntervalWriter() {
        return this.IntervalWriter;
    }

    private String StructWriter() {
        return this.StructWriter;
    }

    private String CompactDecimalWriter() {
        return this.CompactDecimalWriter;
    }

    public String org$apache$spark$sql$catalyst$expressions$codegen$GenerateUnsafeProjection$$DecimalWriter() {
        return this.org$apache$spark$sql$catalyst$expressions$codegen$GenerateUnsafeProjection$$DecimalWriter;
    }

    private String ArrayWriter() {
        return this.ArrayWriter;
    }

    private String MapWriter() {
        return this.MapWriter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canSupport(DataType dataType2) {
        ArrayType arrayType2;
        DataType dataType3 = dataType2;
        NullType$ nullType$ = NullType$.MODULE$;
        DataType dataType4 = dataType3;
        if (nullType$ == null) {
            if (dataType4 == null) return true;
        } else if (nullType$.equals(dataType4)) {
            return true;
        }
        if (dataType3 instanceof AtomicType) {
            return true;
        }
        if (dataType3 instanceof CalendarIntervalType) {
            return true;
        }
        if (dataType3 instanceof StructType) {
            StructType structType2 = (StructType)dataType3;
            return structType2.toSeq().forall((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(StructField field) {
                    return GenerateUnsafeProjection$.MODULE$.canSupport(field.dataType());
                }
            });
        }
        if (dataType3 instanceof ArrayType && this.canSupport((arrayType2 = (ArrayType)dataType3).elementType())) {
            return true;
        }
        if (!(dataType3 instanceof MapType)) return false;
        MapType mapType2 = (MapType)dataType3;
        DataType kt = mapType2.keyType();
        DataType vt = mapType2.valueType();
        if (!this.canSupport(kt)) return false;
        if (!this.canSupport(vt)) return false;
        return true;
    }

    public String genAdditionalSize(DataType dt, GeneratedExpressionCode ev) {
        String string;
        DecimalType decimalType;
        DataType dataType2 = dt;
        if (dataType2 instanceof DecimalType && (decimalType = (DecimalType)dataType2).precision() > Decimal$.MODULE$.MAX_LONG_DIGITS()) {
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getSize(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$apache$spark$sql$catalyst$expressions$codegen$GenerateUnsafeProjection$$DecimalWriter(), ev.primitive()}));
        } else {
            StringType$ stringType$ = StringType$.MODULE$;
            DataType dataType3 = dataType2;
            if (!(stringType$ != null ? !stringType$.equals(dataType3) : dataType3 != null)) {
                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ? 0 : ", ".getSize(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), this.StringWriter(), ev.primitive()}));
            } else {
                BinaryType$ binaryType$ = BinaryType$.MODULE$;
                DataType dataType4 = dataType2;
                if (!(binaryType$ != null ? !binaryType$.equals(dataType4) : dataType4 != null)) {
                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ? 0 : ", ".getSize(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), this.BinaryWriter(), ev.primitive()}));
                } else {
                    CalendarIntervalType$ calendarIntervalType$ = CalendarIntervalType$.MODULE$;
                    DataType dataType5 = dataType2;
                    string = !(calendarIntervalType$ != null ? !calendarIntervalType$.equals(dataType5) : dataType5 != null) ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ? 0 : 16"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull()})) : (dataType2 instanceof StructType ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ? 0 : ", ".getSize(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), this.StructWriter(), ev.primitive()})) : (dataType2 instanceof ArrayType ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ? 0 : ", ".getSize(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), this.ArrayWriter(), ev.primitive()})) : (dataType2 instanceof MapType ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ? 0 : ", ".getSize(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), this.MapWriter(), ev.primitive()})) : "")));
                }
            }
        }
        return string;
    }

    public String genFieldWriter(CodeGenContext ctx, DataType fieldType, GeneratedExpressionCode ev, String target, int index, String cursor) {
        block12: {
            String string;
            block3: {
                DataType dataType2;
                block11: {
                    block10: {
                        block9: {
                            block8: {
                                block7: {
                                    block6: {
                                        block5: {
                                            DecimalType decimalType;
                                            boolean bl;
                                            block4: {
                                                block2: {
                                                    bl = false;
                                                    decimalType = null;
                                                    dataType2 = fieldType;
                                                    if (!ctx.isPrimitiveType(fieldType)) break block2;
                                                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ctx.setColumn(target, fieldType, index, ev.primitive())}));
                                                    break block3;
                                                }
                                                if (!(dataType2 instanceof DecimalType)) break block4;
                                                bl = true;
                                                decimalType = (DecimalType)dataType2;
                                                if (decimalType.precision() > Decimal$.MODULE$.MAX_LONG_DIGITS()) break block4;
                                                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       // make sure Decimal object has the same scale as DecimalType\n       if (", ".changePrecision(", ", ", ")) {\n         ", ".write(", ", ", ", ", ", ", ");\n       } else {\n         ", ".setNullAt(", ");\n       }\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.primitive(), BoxesRunTime.boxToInteger((int)decimalType.precision()), BoxesRunTime.boxToInteger((int)decimalType.scale()), this.CompactDecimalWriter(), target, BoxesRunTime.boxToInteger((int)index), cursor, ev.primitive(), target, BoxesRunTime.boxToInteger((int)index)}));
                                                break block3;
                                            }
                                            if (!bl || decimalType.precision() <= Decimal$.MODULE$.MAX_LONG_DIGITS()) break block5;
                                            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       // make sure Decimal object has the same scale as DecimalType\n       if (", ".changePrecision(", ", ", ")) {\n         ", " += ", ".write(", ", ", ", ", ", ", ");\n       } else {\n         ", " += ", ".write(", ", ", ", ", ", null);\n       }\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.primitive(), BoxesRunTime.boxToInteger((int)decimalType.precision()), BoxesRunTime.boxToInteger((int)decimalType.scale()), cursor, this.org$apache$spark$sql$catalyst$expressions$codegen$GenerateUnsafeProjection$$DecimalWriter(), target, BoxesRunTime.boxToInteger((int)index), cursor, ev.primitive(), cursor, this.org$apache$spark$sql$catalyst$expressions$codegen$GenerateUnsafeProjection$$DecimalWriter(), target, BoxesRunTime.boxToInteger((int)index), cursor}));
                                            break block3;
                                        }
                                        StringType$ stringType$ = StringType$.MODULE$;
                                        DataType dataType3 = dataType2;
                                        if (stringType$ != null ? !stringType$.equals(dataType3) : dataType3 != null) break block6;
                                        string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " += ", ".write(", ", ", ", ", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cursor, this.StringWriter(), target, BoxesRunTime.boxToInteger((int)index), cursor, ev.primitive()}));
                                        break block3;
                                    }
                                    BinaryType$ binaryType$ = BinaryType$.MODULE$;
                                    DataType dataType4 = dataType2;
                                    if (binaryType$ != null ? !binaryType$.equals(dataType4) : dataType4 != null) break block7;
                                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " += ", ".write(", ", ", ", ", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cursor, this.BinaryWriter(), target, BoxesRunTime.boxToInteger((int)index), cursor, ev.primitive()}));
                                    break block3;
                                }
                                CalendarIntervalType$ calendarIntervalType$ = CalendarIntervalType$.MODULE$;
                                DataType dataType5 = dataType2;
                                if (calendarIntervalType$ != null ? !calendarIntervalType$.equals(dataType5) : dataType5 != null) break block8;
                                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " += ", ".write(", ", ", ", ", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cursor, this.IntervalWriter(), target, BoxesRunTime.boxToInteger((int)index), cursor, ev.primitive()}));
                                break block3;
                            }
                            if (!(dataType2 instanceof StructType)) break block9;
                            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " += ", ".write(", ", ", ", ", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cursor, this.StructWriter(), target, BoxesRunTime.boxToInteger((int)index), cursor, ev.primitive()}));
                            break block3;
                        }
                        if (!(dataType2 instanceof ArrayType)) break block10;
                        string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " += ", ".write(", ", ", ", ", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cursor, this.ArrayWriter(), target, BoxesRunTime.boxToInteger((int)index), cursor, ev.primitive()}));
                        break block3;
                    }
                    if (!(dataType2 instanceof MapType)) break block11;
                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " += ", ".write(", ", ", ", ", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cursor, this.MapWriter(), target, BoxesRunTime.boxToInteger((int)index), cursor, ev.primitive()}));
                    break block3;
                }
                NullType$ nullType$ = NullType$.MODULE$;
                DataType dataType6 = dataType2;
                if (nullType$ != null ? !nullType$.equals(dataType6) : dataType6 != null) break block12;
                string = "";
            }
            return string;
        }
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Not supported DataType: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fieldType})));
    }

    private GeneratedExpressionCode createCodeForStruct(CodeGenContext ctx, String row, Seq<GeneratedExpressionCode> inputs, Seq<DataType> inputTypes2) {
        int fixedSize = 8 * inputTypes2.length() + UnsafeRow.calculateBitSetWidthInBytes(inputTypes2.length());
        String output2 = ctx.freshName("convertedStruct");
        ctx.addMutableState("UnsafeRow", output2, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"this.", " = new UnsafeRow();"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{output2})));
        String buffer = ctx.freshName("buffer");
        ctx.addMutableState("byte[]", buffer, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"this.", " = new byte[", "];"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{buffer, BoxesRunTime.boxToInteger((int)fixedSize)})));
        String cursor = ctx.freshName("cursor");
        ctx.addMutableState("int", cursor, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"this.", " = 0;"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cursor})));
        String tmp = ctx.freshName("tmpBuffer");
        Seq convertedFields = (Seq)((TraversableLike)((IterableLike)inputTypes2.zip(inputs, Seq$.MODULE$.canBuildFrom())).zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(ctx, inputTypes2, output2, buffer, cursor, tmp){
            public static final long serialVersionUID = 0L;
            private final CodeGenContext ctx$1;
            private final Seq inputTypes$1;
            private final String output$1;
            private final String buffer$1;
            private final String cursor$1;
            private final String tmp$1;

            public final String apply(Tuple2<Tuple2<DataType, GeneratedExpressionCode>, Object> x0$1) {
                Tuple2<Tuple2<DataType, GeneratedExpressionCode>, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    if (tuple22 != null) {
                        DecimalType decimalType;
                        String string;
                        DataType dt = (DataType)tuple22._1();
                        GeneratedExpressionCode input = (GeneratedExpressionCode)tuple22._2();
                        GeneratedExpressionCode ev = GenerateUnsafeProjection$.MODULE$.org$apache$spark$sql$catalyst$expressions$codegen$GenerateUnsafeProjection$$createConvertCode(this.ctx$1, input, dt);
                        if (UnsafeRow.isFixedLength(dt)) {
                            string = "";
                        } else {
                            String numBytes = this.ctx$1.freshName("numBytes");
                            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          int ", " = ", " + (", ");\n          if (", ".length < ", ") {\n            // This will not happen frequently, because the buffer is re-used.\n            byte[] ", " = new byte[", " * 2];\n            Platform.copyMemory(", ", Platform.BYTE_ARRAY_OFFSET,\n              ", ", Platform.BYTE_ARRAY_OFFSET, ", ".length);\n            ", " = ", ";\n          }\n          ", ".pointTo(", ", Platform.BYTE_ARRAY_OFFSET, ", ", ", ");\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{numBytes, this.cursor$1, GenerateUnsafeProjection$.MODULE$.genAdditionalSize(dt, ev), this.buffer$1, numBytes, this.tmp$1, numBytes, this.buffer$1, this.tmp$1, this.buffer$1, this.buffer$1, this.tmp$1, this.output$1, this.buffer$1, BoxesRunTime.boxToInteger((int)this.inputTypes$1.length()), numBytes}));
                        }
                        String growBuffer = string;
                        DataType dataType2 = dt;
                        String string2 = dataType2 instanceof DecimalType && (decimalType = (DecimalType)dataType2).precision() > Decimal$.MODULE$.MAX_LONG_DIGITS() ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          if (", ") {\n            ", " += ", ".write(", ", ", ", ", ", null);\n          } else {\n            ", ";\n          }\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), this.cursor$1, GenerateUnsafeProjection$.MODULE$.org$apache$spark$sql$catalyst$expressions$codegen$GenerateUnsafeProjection$$DecimalWriter(), this.output$1, BoxesRunTime.boxToInteger((int)i), this.cursor$1, GenerateUnsafeProjection$.MODULE$.genFieldWriter(this.ctx$1, decimalType, ev, this.output$1, i, this.cursor$1)})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          if (", ") {\n            ", ".setNullAt(", ");\n          } else {\n            ", ";\n          }\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), this.output$1, BoxesRunTime.boxToInteger((int)i), GenerateUnsafeProjection$.MODULE$.genFieldWriter(this.ctx$1, dt, ev, this.output$1, i, this.cursor$1)}));
                        String update = string2;
                        String string3 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        ", "\n        ", "\n        ", "\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.code(), growBuffer, update}));
                        return string3;
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                this.ctx$1 = ctx$1;
                this.inputTypes$1 = inputTypes$1;
                this.output$1 = output$1;
                this.buffer$1 = buffer$1;
                this.cursor$1 = cursor$1;
                this.tmp$1 = tmp$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        String code = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      ", " = ", ";\n      ", ".pointTo(", ", Platform.BYTE_ARRAY_OFFSET, ", ", ", ");\n      ", "\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cursor, BoxesRunTime.boxToInteger((int)fixedSize), output2, buffer, BoxesRunTime.boxToInteger((int)inputTypes2.length()), cursor, ctx.splitExpressions(row, (Seq<String>)convertedFields)}));
        return new GeneratedExpressionCode(code, "false", output2);
    }

    private String getWriter(DataType dt) {
        DataType dataType2;
        block9: {
            String string;
            block3: {
                block8: {
                    block7: {
                        block6: {
                            block5: {
                                block4: {
                                    block2: {
                                        dataType2 = dt;
                                        StringType$ stringType$ = StringType$.MODULE$;
                                        DataType dataType3 = dataType2;
                                        if (stringType$ != null ? !stringType$.equals(dataType3) : dataType3 != null) break block2;
                                        string = UnsafeWriters.UTF8StringWriter.class.getName();
                                        break block3;
                                    }
                                    BinaryType$ binaryType$ = BinaryType$.MODULE$;
                                    DataType dataType4 = dataType2;
                                    if (binaryType$ != null ? !binaryType$.equals(dataType4) : dataType4 != null) break block4;
                                    string = UnsafeWriters.BinaryWriter.class.getName();
                                    break block3;
                                }
                                CalendarIntervalType$ calendarIntervalType$ = CalendarIntervalType$.MODULE$;
                                DataType dataType5 = dataType2;
                                if (calendarIntervalType$ != null ? !calendarIntervalType$.equals(dataType5) : dataType5 != null) break block5;
                                string = UnsafeWriters.IntervalWriter.class.getName();
                                break block3;
                            }
                            if (!(dataType2 instanceof StructType)) break block6;
                            string = UnsafeWriters.StructWriter.class.getName();
                            break block3;
                        }
                        if (!(dataType2 instanceof ArrayType)) break block7;
                        string = UnsafeWriters.ArrayWriter.class.getName();
                        break block3;
                    }
                    if (!(dataType2 instanceof MapType)) break block8;
                    string = UnsafeWriters.MapWriter.class.getName();
                    break block3;
                }
                if (!(dataType2 instanceof DecimalType)) break block9;
                string = UnsafeWriters.DecimalWriter.class.getName();
            }
            return string;
        }
        throw new MatchError((Object)dataType2);
    }

    private GeneratedExpressionCode createCodeForArray(CodeGenContext ctx, GeneratedExpressionCode input, DataType elementType) {
        String string;
        DecimalType decimalType;
        String string2;
        DecimalType decimalType2;
        String string3;
        String output2 = ctx.freshName("convertedArray");
        ctx.addMutableState("UnsafeArrayData", output2, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = new UnsafeArrayData();"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{output2})));
        String buffer = ctx.freshName("buffer");
        ctx.addMutableState("byte[]", buffer, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = new byte[64];"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{buffer})));
        String outputIsNull = ctx.freshName("isNull");
        String tmp = ctx.freshName("tmp");
        String numElements = ctx.freshName("numElements");
        String fixedSize = ctx.freshName("fixedSize");
        String numBytes = ctx.freshName("numBytes");
        String elements = ctx.freshName("elements");
        String cursor = ctx.freshName("cursor");
        String index = ctx.freshName("index");
        GeneratedExpressionCode element = new GeneratedExpressionCode("", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".isNullAt(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tmp, index})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ctx.getValue(tmp, elementType, index)})));
        GeneratedExpressionCode convertedElement = this.org$apache$spark$sql$catalyst$expressions$codegen$GenerateUnsafeProjection$$createConvertCode(ctx, element, elementType);
        DataType dataType2 = elementType;
        if (ctx.isPrimitiveType(elementType)) {
            int elementSize = elementType.defaultSize();
            string3 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          ", " += ", " * ", ";\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{numBytes, BoxesRunTime.boxToInteger((int)elementSize), numElements}));
        } else if (dataType2 instanceof DecimalType && (decimalType2 = (DecimalType)dataType2).precision() <= Decimal$.MODULE$.MAX_LONG_DIGITS()) {
            string3 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          ", " += 8 * ", ";\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{numBytes, numElements}));
        } else {
            String writer = this.getWriter(elementType);
            String elementSize = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getSize(", "[", "])"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{writer, elements, index}));
            DataType dataType3 = elementType;
            String string4 = dataType3 instanceof StructType ? "UnsafeRow" : (dataType3 instanceof ArrayType ? "UnsafeArrayData" : (dataType3 instanceof MapType ? "UnsafeMapData" : ctx.javaType(elementType)));
            String unsafeType = string4;
            DataType dataType4 = elementType;
            boolean bl = dataType4 instanceof StructType ? true : (dataType4 instanceof ArrayType ? true : dataType4 instanceof MapType);
            String string5 = bl ? ".copy()" : "";
            String copy = string5;
            DataType dataType5 = elementType;
            BinaryType$ binaryType$ = BinaryType$.MODULE$;
            String newElements = !(dataType5 != null ? !dataType5.equals(binaryType$) : binaryType$ != null) ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"new byte[", "][]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{numElements})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"new ", "[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{unsafeType, numElements}));
            string3 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          final ", "[] ", " = ", ";\n          for (int ", " = 0; ", " < ", "; ", "++) {\n            ", "\n            if (!", ") {\n              ", "[", "] = ", "", ";\n              ", " += ", ";\n            }\n          }\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{unsafeType, elements, newElements, index, index, numElements, index, convertedElement.code(), convertedElement.isNull(), elements, index, convertedElement.primitive(), copy, numBytes, elementSize}));
        }
        String calculateNumBytes = string3;
        DataType dataType6 = elementType;
        if (ctx.isPrimitiveType(elementType)) {
            int elementSize = elementType.defaultSize();
            string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          Platform.put", "(\n            ", ",\n            Platform.BYTE_ARRAY_OFFSET + ", ",\n            ", ");\n          ", " += ", ";\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ctx.primitiveTypeName(elementType), buffer, cursor, convertedElement.primitive(), cursor, BoxesRunTime.boxToInteger((int)elementSize)}));
        } else if (dataType6 instanceof DecimalType && (decimalType = (DecimalType)dataType6).precision() <= Decimal$.MODULE$.MAX_LONG_DIGITS()) {
            string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          Platform.putLong(\n            ", ",\n            Platform.BYTE_ARRAY_OFFSET + ", ",\n            ", ".toUnscaledLong());\n          ", " += 8;\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{buffer, cursor, convertedElement.primitive(), cursor}));
        } else {
            String writer = this.getWriter(elementType);
            string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          ", " += ", ".write(\n            ", ",\n            Platform.BYTE_ARRAY_OFFSET + ", ",\n            ", "[", "]);\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cursor, writer, buffer, cursor, elements, index}));
        }
        String writeElement = string2;
        DataType dataType7 = elementType;
        if (ctx.isPrimitiveType(elementType)) {
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{convertedElement.isNull()}));
        } else if (dataType7 instanceof DecimalType) {
            DecimalType decimalType3 = (DecimalType)dataType7;
            string = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "[", "] == null"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{elements, index}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" || !", "[", "].changePrecision(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{elements, index, BoxesRunTime.boxToInteger((int)decimalType3.precision()), BoxesRunTime.boxToInteger((int)decimalType3.scale())}))).toString();
        } else {
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "[", "] == null"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{elements, index}));
        }
        String checkNull = string;
        String code = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      ", "\n      final boolean ", " = ", ";\n      if (!", ") {\n        final ArrayData ", " = ", ";\n        if (", " instanceof UnsafeArrayData) {\n          ", " = (UnsafeArrayData) ", ";\n        } else {\n          final int ", " = ", ".numElements();\n          final int ", " = 4 * ", ";\n          int ", " = ", ";\n\n          ", "\n\n          if (", " > ", ".length) {\n            ", " = new byte[", "];\n          }\n\n          int ", " = ", ";\n          for (int ", " = 0; ", " < ", "; ", "++) {\n            if (", ") {\n              // If element is null, write the negative value address into offset region.\n              Platform.putInt(", ", Platform.BYTE_ARRAY_OFFSET + 4 * ", ", -", ");\n            } else {\n              Platform.putInt(", ", Platform.BYTE_ARRAY_OFFSET + 4 * ", ", ", ");\n              ", "\n            }\n          }\n\n          ", ".pointTo(\n            ", ",\n            Platform.BYTE_ARRAY_OFFSET,\n            ", ",\n            ", ");\n        }\n      }\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{input.code(), outputIsNull, input.isNull(), outputIsNull, tmp, input.primitive(), tmp, output2, tmp, numElements, tmp, fixedSize, numElements, numBytes, fixedSize, calculateNumBytes, numBytes, buffer, buffer, numBytes, cursor, fixedSize, index, index, numElements, index, checkNull, buffer, index, cursor, buffer, index, cursor, writeElement, output2, buffer, numElements, numBytes}));
        return new GeneratedExpressionCode(code, outputIsNull, output2);
    }

    private GeneratedExpressionCode createCodeForMap(CodeGenContext ctx, GeneratedExpressionCode input, DataType keyType, DataType valueType) {
        String output2 = ctx.freshName("convertedMap");
        String outputIsNull = ctx.freshName("isNull");
        String tmp = ctx.freshName("tmp");
        GeneratedExpressionCode keyArray = new GeneratedExpressionCode("", "false", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".keyArray()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tmp})));
        GeneratedExpressionCode valueArray = new GeneratedExpressionCode("", "false", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".valueArray()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tmp})));
        GeneratedExpressionCode convertedKeys = this.createCodeForArray(ctx, keyArray, keyType);
        GeneratedExpressionCode convertedValues = this.createCodeForArray(ctx, valueArray, valueType);
        String code = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      ", "\n      final boolean ", " = ", ";\n      UnsafeMapData ", " = null;\n      if (!", ") {\n        final MapData ", " = ", ";\n        if (", " instanceof UnsafeMapData) {\n          ", " = (UnsafeMapData) ", ";\n        } else {\n          ", "\n          ", "\n          ", " = new UnsafeMapData(", ", ", ");\n        }\n      }\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{input.code(), outputIsNull, input.isNull(), output2, outputIsNull, tmp, input.primitive(), tmp, output2, tmp, convertedKeys.code(), convertedValues.code(), output2, convertedKeys.primitive(), convertedValues.primitive()}));
        return new GeneratedExpressionCode(code, outputIsNull, output2);
    }

    public GeneratedExpressionCode org$apache$spark$sql$catalyst$expressions$codegen$GenerateUnsafeProjection$$createConvertCode(CodeGenContext ctx, GeneratedExpressionCode input, DataType dataType2) {
        GeneratedExpressionCode generatedExpressionCode;
        DataType dataType3 = dataType2;
        if (dataType3 instanceof StructType) {
            StructType structType2 = (StructType)dataType3;
            String output2 = ctx.freshName("convertedStruct");
            String outputIsNull = ctx.freshName("isNull");
            String tmp = ctx.freshName("tmp");
            DataType[] fieldTypes = (DataType[])Predef$.MODULE$.refArrayOps((Object[])structType2.fields()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final DataType apply(StructField x$1) {
                    return x$1.dataType();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class)));
            GeneratedExpressionCode[] fieldEvals = (GeneratedExpressionCode[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])fieldTypes).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(ctx, tmp){
                public static final long serialVersionUID = 0L;
                private final CodeGenContext ctx$2;
                private final String tmp$2;

                public final GeneratedExpressionCode apply(Tuple2<DataType, Object> x0$2) {
                    Tuple2<DataType, Object> tuple2 = x0$2;
                    if (tuple2 != null) {
                        DataType dt = (DataType)tuple2._1();
                        int i = tuple2._2$mcI$sp();
                        String getFieldCode = this.ctx$2.getValue(this.tmp$2, dt, ((Object)BoxesRunTime.boxToInteger((int)i)).toString());
                        String fieldIsNull = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".isNullAt(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tmp$2, BoxesRunTime.boxToInteger((int)i)}));
                        GeneratedExpressionCode generatedExpressionCode = new GeneratedExpressionCode("", fieldIsNull, getFieldCode);
                        return generatedExpressionCode;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.ctx$2 = ctx$2;
                    this.tmp$2 = tmp$2;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(GeneratedExpressionCode.class)));
            GeneratedExpressionCode converter = this.createCodeForStruct(ctx, tmp, (Seq<GeneratedExpressionCode>)Predef$.MODULE$.wrapRefArray((Object[])fieldEvals), (Seq<DataType>)Predef$.MODULE$.wrapRefArray((Object[])fieldTypes));
            String code = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        ", "\n         UnsafeRow ", " = null;\n         final boolean ", " = ", ";\n         if (!", ") {\n           final InternalRow ", " = ", ";\n           if (", " instanceof UnsafeRow) {\n             ", " = (UnsafeRow) ", ";\n           } else {\n             ", "\n             ", " = ", ";\n           }\n         }\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{input.code(), output2, outputIsNull, input.isNull(), outputIsNull, tmp, input.primitive(), tmp, output2, tmp, converter.code(), output2, converter.primitive()}));
            generatedExpressionCode = new GeneratedExpressionCode(code, outputIsNull, output2);
        } else if (dataType3 instanceof ArrayType) {
            ArrayType arrayType2 = (ArrayType)dataType3;
            DataType elementType = arrayType2.elementType();
            generatedExpressionCode = this.createCodeForArray(ctx, input, elementType);
        } else if (dataType3 instanceof MapType) {
            MapType mapType2 = (MapType)dataType3;
            DataType kt = mapType2.keyType();
            DataType vt = mapType2.valueType();
            generatedExpressionCode = this.createCodeForMap(ctx, input, kt, vt);
        } else {
            generatedExpressionCode = input;
        }
        return generatedExpressionCode;
    }

    public GeneratedExpressionCode createCode(CodeGenContext ctx, Seq<Expression> expressions2) {
        Seq exprEvals = (Seq)expressions2.map((Function1)new Serializable(ctx){
            public static final long serialVersionUID = 0L;
            private final CodeGenContext ctx$3;

            public final GeneratedExpressionCode apply(Expression e) {
                return e.gen(this.ctx$3);
            }
            {
                this.ctx$3 = ctx$3;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq exprTypes = (Seq)expressions2.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DataType apply(Expression x$2) {
                return x$2.dataType();
            }
        }, Seq$.MODULE$.canBuildFrom());
        return this.createCodeForStruct(ctx, "i", (Seq<GeneratedExpressionCode>)exprEvals, (Seq<DataType>)exprTypes);
    }

    @Override
    public Seq<Expression> canonicalize(Seq<Expression> in) {
        return (Seq)in.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Expression apply(Expression plan2) {
                return package$ExpressionCanonicalizer$.MODULE$.execute(plan2);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Seq<Expression> bind(Seq<Expression> in, Seq<Attribute> inputSchema) {
        return (Seq)in.map((Function1)new Serializable(inputSchema){
            public static final long serialVersionUID = 0L;
            private final Seq inputSchema$1;

            public final Expression apply(Expression x$3) {
                return BindReferences$.MODULE$.bindReference(x$3, (Seq<Attribute>)this.inputSchema$1, BindReferences$.MODULE$.bindReference$default$3());
            }
            {
                this.inputSchema$1 = inputSchema$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public UnsafeProjection create(Seq<Expression> expressions2) {
        CodeGenContext ctx = this.newCodeGenContext();
        GeneratedExpressionCode eval2 = this.createCode(ctx, expressions2);
        String code = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      public Object generate(", "[] exprs) {\n        return new SpecificUnsafeProjection(exprs);\n      }\n\n      class SpecificUnsafeProjection extends ", " {\n\n        private ", "[] expressions;\n\n        ", "\n        ", "\n\n        public SpecificUnsafeProjection(", "[] expressions) {\n          this.expressions = expressions;\n          ", "\n        }\n\n        // Scala.Function1 need this\n        public Object apply(Object row) {\n          return apply((InternalRow) row);\n        }\n\n        public UnsafeRow apply(InternalRow i) {\n          ", "\n          return ", ";\n        }\n      }\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.exprType(), UnsafeProjection.class.getName(), this.exprType(), this.declareMutableStates(ctx), this.declareAddedFunctions(ctx), this.exprType(), this.initMutableStates(ctx), eval2.code(), eval2.primitive()}));
        this.logDebug((Function0<String>)new Serializable(expressions2, code){
            public static final long serialVersionUID = 0L;
            private final Seq expressions$1;
            private final String code$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"code for ", ":\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.expressions$1.mkString(","), CodeFormatter$.MODULE$.format(this.code$1)}));
            }
            {
                this.expressions$1 = expressions$1;
                this.code$1 = code$1;
            }
        });
        GeneratedClass c = this.compile(code);
        return (UnsafeProjection)c.generate((Expression[])ctx.references().toArray(ClassTag$.MODULE$.apply(Expression.class)));
    }

    private GenerateUnsafeProjection$() {
        MODULE$ = this;
        this.StringWriter = UnsafeRowWriters.UTF8StringWriter.class.getName();
        this.BinaryWriter = UnsafeRowWriters.BinaryWriter.class.getName();
        this.IntervalWriter = UnsafeRowWriters.IntervalWriter.class.getName();
        this.StructWriter = UnsafeRowWriters.StructWriter.class.getName();
        this.CompactDecimalWriter = UnsafeRowWriters.CompactDecimalWriter.class.getName();
        this.org$apache$spark$sql$catalyst$expressions$codegen$GenerateUnsafeProjection$$DecimalWriter = UnsafeRowWriters.DecimalWriter.class.getName();
        this.ArrayWriter = UnsafeRowWriters.ArrayWriter.class.getName();
        this.MapWriter = UnsafeRowWriters.MapWriter.class.getName();
    }
}

