/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.io.File;
import java.math.BigDecimal;
import java.sql.Timestamp;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLConf;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.util.Utils$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class HiveContext$
implements Serializable {
    public static final HiveContext$ MODULE$;
    private final String hiveExecutionVersion;
    private final SQLConf.SQLConfEntry<String> HIVE_METASTORE_VERSION;
    private final SQLConf.SQLConfEntry<String> HIVE_EXECUTION_VERSION;
    private final SQLConf.SQLConfEntry<String> HIVE_METASTORE_JARS;
    private final SQLConf.SQLConfEntry<Object> CONVERT_METASTORE_PARQUET;
    private final SQLConf.SQLConfEntry<Object> CONVERT_METASTORE_PARQUET_WITH_SCHEMA_MERGING;
    private final SQLConf.SQLConfEntry<Object> CONVERT_CTAS;
    private final SQLConf.SQLConfEntry<Seq<String>> HIVE_METASTORE_SHARED_PREFIXES;
    private final SQLConf.SQLConfEntry<Seq<String>> HIVE_METASTORE_BARRIER_PREFIXES;
    private final SQLConf.SQLConfEntry<Object> HIVE_THRIFT_SERVER_ASYNC;
    private final Seq<AtomicType> primitiveTypes;

    static {
        new HiveContext$();
    }

    public String hiveExecutionVersion() {
        return this.hiveExecutionVersion;
    }

    public SQLConf.SQLConfEntry<String> HIVE_METASTORE_VERSION() {
        return this.HIVE_METASTORE_VERSION;
    }

    public SQLConf.SQLConfEntry<String> HIVE_EXECUTION_VERSION() {
        return this.HIVE_EXECUTION_VERSION;
    }

    public SQLConf.SQLConfEntry<String> HIVE_METASTORE_JARS() {
        return this.HIVE_METASTORE_JARS;
    }

    public SQLConf.SQLConfEntry<Object> CONVERT_METASTORE_PARQUET() {
        return this.CONVERT_METASTORE_PARQUET;
    }

    public SQLConf.SQLConfEntry<Object> CONVERT_METASTORE_PARQUET_WITH_SCHEMA_MERGING() {
        return this.CONVERT_METASTORE_PARQUET_WITH_SCHEMA_MERGING;
    }

    public SQLConf.SQLConfEntry<Object> CONVERT_CTAS() {
        return this.CONVERT_CTAS;
    }

    public SQLConf.SQLConfEntry<Seq<String>> HIVE_METASTORE_SHARED_PREFIXES() {
        return this.HIVE_METASTORE_SHARED_PREFIXES;
    }

    private Seq<String> jdbcPrefixes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"com.mysql.jdbc", "org.postgresql", "com.microsoft.sqlserver", "oracle.jdbc"}));
    }

    public SQLConf.SQLConfEntry<Seq<String>> HIVE_METASTORE_BARRIER_PREFIXES() {
        return this.HIVE_METASTORE_BARRIER_PREFIXES;
    }

    public SQLConf.SQLConfEntry<Object> HIVE_THRIFT_SERVER_ASYNC() {
        return this.HIVE_THRIFT_SERVER_ASYNC;
    }

    public Map<String, String> newTemporaryConfiguration() {
        File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
        File localMetastore = new File(tempDir, "metastore");
        HashMap propMap = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        Predef$.MODULE$.refArrayOps((Object[])HiveConf.ConfVars.values()).foreach((Function1)new Serializable(propMap){
            public static final long serialVersionUID = 0L;
            private final HashMap propMap$1;

            public final Object apply(HiveConf.ConfVars confvar) {
                return confvar.varname.contains("datanucleus") || confvar.varname.contains("jdo") ? this.propMap$1.put((Object)confvar.varname, (Object)confvar.getDefaultExpr()) : BoxedUnit.UNIT;
            }
            {
                this.propMap$1 = propMap$1;
            }
        });
        propMap.put((Object)HiveConf.ConfVars.METASTOREWAREHOUSE.varname, (Object)localMetastore.toURI().toString());
        propMap.put((Object)HiveConf.ConfVars.METASTORECONNECTURLKEY.varname, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"jdbc:derby:;databaseName=", ";create=true"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{localMetastore.getAbsolutePath()})));
        propMap.put((Object)"datanucleus.rdbms.datastoreAdapterClassName", (Object)"org.datanucleus.store.rdbms.adapter.DerbyAdapter");
        return propMap.toMap(Predef$.MODULE$.conforms());
    }

    public Seq<AtomicType> primitiveTypes() {
        return this.primitiveTypes;
    }

    public String toHiveString(Tuple2<Object, DataType> a) {
        Tuple2<Object, DataType> tuple2;
        block11: {
            String string;
            block3: {
                block10: {
                    block9: {
                        block8: {
                            block7: {
                                block6: {
                                    Object object;
                                    block5: {
                                        block4: {
                                            block2: {
                                                tuple2 = a;
                                                if (tuple2 == null) break block2;
                                                Object struct = tuple2._1();
                                                DataType dataType = (DataType)tuple2._2();
                                                if (!(struct instanceof Row)) break block2;
                                                Row row = (Row)struct;
                                                if (!(dataType instanceof StructType)) break block2;
                                                StructType structType = (StructType)dataType;
                                                StructField[] fields = structType.fields();
                                                string = ((TraversableOnce)((TraversableLike)row.toSeq().zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])fields), Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply(Tuple2<Object, StructField> x0$4) {
                                                        Tuple2<Object, StructField> tuple2 = x0$4;
                                                        if (tuple2 != null) {
                                                            Object v = tuple2._1();
                                                            StructField t = (StructField)tuple2._2();
                                                            String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\"", "\":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t.name(), HiveContext$.MODULE$.toHiveStructString((Tuple2<Object, DataType>)new Tuple2(v, (Object)t.dataType()))}));
                                                            return string;
                                                        }
                                                        throw new MatchError(tuple2);
                                                    }
                                                }, Seq$.MODULE$.canBuildFrom())).mkString("{", ",", "}");
                                                break block3;
                                            }
                                            if (tuple2 == null) break block4;
                                            Object seq = tuple2._1();
                                            DataType dataType = (DataType)tuple2._2();
                                            if (!(seq instanceof Seq)) break block4;
                                            Seq seq2 = (Seq)seq;
                                            if (!(dataType instanceof ArrayType)) break block4;
                                            ArrayType arrayType = (ArrayType)dataType;
                                            DataType typ = arrayType.elementType();
                                            string = ((TraversableOnce)((TraversableLike)seq2.map((Function1)new Serializable(typ){
                                                public static final long serialVersionUID = 0L;
                                                private final DataType typ$1;

                                                public final Tuple2<Object, DataType> apply(Object v) {
                                                    return new Tuple2(v, (Object)this.typ$1);
                                                }
                                                {
                                                    this.typ$1 = typ$1;
                                                }
                                            }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
                                                public static final long serialVersionUID = 0L;

                                                public final String apply(Tuple2<Object, DataType> a) {
                                                    return HiveContext$.MODULE$.toHiveStructString(a);
                                                }
                                            }, Seq$.MODULE$.canBuildFrom())).mkString("[", ",", "]");
                                            break block3;
                                        }
                                        if (tuple2 == null) break block5;
                                        Object map = tuple2._1();
                                        DataType dataType = (DataType)tuple2._2();
                                        if (!(map instanceof Map)) break block5;
                                        Map map2 = (Map)map;
                                        if (!(dataType instanceof MapType)) break block5;
                                        MapType mapType = (MapType)dataType;
                                        DataType kType = mapType.keyType();
                                        DataType vType = mapType.valueType();
                                        string = ((TraversableOnce)((TraversableOnce)map2.map((Function1)new Serializable(kType, vType){
                                            public static final long serialVersionUID = 0L;
                                            private final DataType kType$1;
                                            private final DataType vType$1;

                                            public final String apply(Tuple2<Object, Object> x0$5) {
                                                Tuple2<Object, Object> tuple2 = x0$5;
                                                if (tuple2 != null) {
                                                    Object key = tuple2._1();
                                                    Object value = tuple2._2();
                                                    String string = new StringBuilder().append((Object)HiveContext$.MODULE$.toHiveStructString((Tuple2<Object, DataType>)new Tuple2(key, (Object)this.kType$1))).append((Object)":").append((Object)HiveContext$.MODULE$.toHiveStructString((Tuple2<Object, DataType>)new Tuple2(value, (Object)this.vType$1))).toString();
                                                    return string;
                                                }
                                                throw new MatchError(tuple2);
                                            }
                                            {
                                                this.kType$1 = kType$1;
                                                this.vType$1 = vType$1;
                                            }
                                        }, Iterable$.MODULE$.canBuildFrom())).toSeq().sorted((Ordering)Ordering.String$.MODULE$)).mkString("{", ",", "}");
                                        break block3;
                                    }
                                    if (tuple2 == null || (object = tuple2._1()) != null) break block6;
                                    string = "NULL";
                                    break block3;
                                }
                                if (tuple2 == null) break block7;
                                Object d = tuple2._1();
                                DataType dataType = (DataType)tuple2._2();
                                if (!(d instanceof Integer)) break block7;
                                int n = BoxesRunTime.unboxToInt((Object)d);
                                DateType$ dateType$ = DateType$.MODULE$;
                                DataType dataType2 = dataType;
                                if (dateType$ != null ? !dateType$.equals(dataType2) : dataType2 != null) break block7;
                                string = new DateWritable(n).toString();
                                break block3;
                            }
                            if (tuple2 == null) break block8;
                            Object t = tuple2._1();
                            DataType dataType = (DataType)tuple2._2();
                            if (!(t instanceof Timestamp)) break block8;
                            Timestamp timestamp = (Timestamp)t;
                            TimestampType$ timestampType$ = TimestampType$.MODULE$;
                            DataType dataType3 = dataType;
                            if (timestampType$ != null ? !timestampType$.equals(dataType3) : dataType3 != null) break block8;
                            string = new TimestampWritable(timestamp).toString();
                            break block3;
                        }
                        if (tuple2 == null) break block9;
                        Object bin = tuple2._1();
                        DataType dataType = (DataType)tuple2._2();
                        if (!(bin instanceof byte[])) break block9;
                        byte[] byArray = (byte[])bin;
                        BinaryType$ binaryType$ = BinaryType$.MODULE$;
                        DataType dataType4 = dataType;
                        if (binaryType$ != null ? !binaryType$.equals(dataType4) : dataType4 != null) break block9;
                        string = new String(byArray, "UTF-8");
                        break block3;
                    }
                    if (tuple2 == null) break block10;
                    Object decimal = tuple2._1();
                    DataType dataType = (DataType)tuple2._2();
                    if (!(decimal instanceof BigDecimal)) break block10;
                    BigDecimal bigDecimal = (BigDecimal)decimal;
                    if (!DecimalType$.MODULE$.unapply(dataType)) break block10;
                    string = HiveDecimal.create((BigDecimal)bigDecimal).toString();
                    break block3;
                }
                if (tuple2 == null) break block11;
                Object other = tuple2._1();
                DataType tpe = (DataType)tuple2._2();
                if (!this.primitiveTypes().contains((Object)tpe)) break block11;
                string = other.toString();
            }
            return string;
        }
        throw new MatchError(tuple2);
    }

    public String toHiveStructString(Tuple2<Object, DataType> a) {
        Tuple2<Object, DataType> tuple2;
        block9: {
            String string;
            block3: {
                block8: {
                    block7: {
                        block6: {
                            Object object;
                            block5: {
                                block4: {
                                    block2: {
                                        tuple2 = a;
                                        if (tuple2 == null) break block2;
                                        Object struct = tuple2._1();
                                        DataType dataType = (DataType)tuple2._2();
                                        if (!(struct instanceof Row)) break block2;
                                        Row row = (Row)struct;
                                        if (!(dataType instanceof StructType)) break block2;
                                        StructType structType = (StructType)dataType;
                                        StructField[] fields = structType.fields();
                                        string = ((TraversableOnce)((TraversableLike)row.toSeq().zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])fields), Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
                                            public static final long serialVersionUID = 0L;

                                            public final String apply(Tuple2<Object, StructField> x0$6) {
                                                Tuple2<Object, StructField> tuple2 = x0$6;
                                                if (tuple2 != null) {
                                                    Object v = tuple2._1();
                                                    StructField t = (StructField)tuple2._2();
                                                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\"", "\":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t.name(), HiveContext$.MODULE$.toHiveStructString((Tuple2<Object, DataType>)new Tuple2(v, (Object)t.dataType()))}));
                                                    return string;
                                                }
                                                throw new MatchError(tuple2);
                                            }
                                        }, Seq$.MODULE$.canBuildFrom())).mkString("{", ",", "}");
                                        break block3;
                                    }
                                    if (tuple2 == null) break block4;
                                    Object seq = tuple2._1();
                                    DataType dataType = (DataType)tuple2._2();
                                    if (!(seq instanceof Seq)) break block4;
                                    Seq seq2 = (Seq)seq;
                                    if (!(dataType instanceof ArrayType)) break block4;
                                    ArrayType arrayType = (ArrayType)dataType;
                                    DataType typ = arrayType.elementType();
                                    string = ((TraversableOnce)((TraversableLike)seq2.map((Function1)new Serializable(typ){
                                        public static final long serialVersionUID = 0L;
                                        private final DataType typ$2;

                                        public final Tuple2<Object, DataType> apply(Object v) {
                                            return new Tuple2(v, (Object)this.typ$2);
                                        }
                                        {
                                            this.typ$2 = typ$2;
                                        }
                                    }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply(Tuple2<Object, DataType> a) {
                                            return HiveContext$.MODULE$.toHiveStructString(a);
                                        }
                                    }, Seq$.MODULE$.canBuildFrom())).mkString("[", ",", "]");
                                    break block3;
                                }
                                if (tuple2 == null) break block5;
                                Object map = tuple2._1();
                                DataType dataType = (DataType)tuple2._2();
                                if (!(map instanceof Map)) break block5;
                                Map map2 = (Map)map;
                                if (!(dataType instanceof MapType)) break block5;
                                MapType mapType = (MapType)dataType;
                                DataType kType = mapType.keyType();
                                DataType vType = mapType.valueType();
                                string = ((TraversableOnce)((TraversableOnce)map2.map((Function1)new Serializable(kType, vType){
                                    public static final long serialVersionUID = 0L;
                                    private final DataType kType$2;
                                    private final DataType vType$2;

                                    public final String apply(Tuple2<Object, Object> x0$7) {
                                        Tuple2<Object, Object> tuple2 = x0$7;
                                        if (tuple2 != null) {
                                            Object key = tuple2._1();
                                            Object value = tuple2._2();
                                            String string = new StringBuilder().append((Object)HiveContext$.MODULE$.toHiveStructString((Tuple2<Object, DataType>)new Tuple2(key, (Object)this.kType$2))).append((Object)":").append((Object)HiveContext$.MODULE$.toHiveStructString((Tuple2<Object, DataType>)new Tuple2(value, (Object)this.vType$2))).toString();
                                            return string;
                                        }
                                        throw new MatchError(tuple2);
                                    }
                                    {
                                        this.kType$2 = kType$2;
                                        this.vType$2 = vType$2;
                                    }
                                }, Iterable$.MODULE$.canBuildFrom())).toSeq().sorted((Ordering)Ordering.String$.MODULE$)).mkString("{", ",", "}");
                                break block3;
                            }
                            if (tuple2 == null || (object = tuple2._1()) != null) break block6;
                            string = "null";
                            break block3;
                        }
                        if (tuple2 == null) break block7;
                        Object s = tuple2._1();
                        DataType dataType = (DataType)tuple2._2();
                        if (!(s instanceof String)) break block7;
                        String string2 = (String)s;
                        StringType$ stringType$ = StringType$.MODULE$;
                        DataType dataType2 = dataType;
                        if (stringType$ != null ? !stringType$.equals(dataType2) : dataType2 != null) break block7;
                        string = new StringBuilder().append((Object)"\"").append((Object)string2).append((Object)"\"").toString();
                        break block3;
                    }
                    if (tuple2 == null) break block8;
                    Object decimal = tuple2._1();
                    DataType dataType = (DataType)tuple2._2();
                    if (!DecimalType$.MODULE$.unapply(dataType)) break block8;
                    string = decimal.toString();
                    break block3;
                }
                if (tuple2 == null) break block9;
                Object other = tuple2._1();
                DataType tpe = (DataType)tuple2._2();
                if (!this.primitiveTypes().contains((Object)tpe)) break block9;
                string = other.toString();
            }
            return string;
        }
        throw new MatchError(tuple2);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private HiveContext$() {
        MODULE$ = this;
        this.hiveExecutionVersion = "1.2.1";
        this.HIVE_METASTORE_VERSION = SQLConf.SQLConfEntry$.MODULE$.stringConf("spark.sql.hive.metastore.version", (Option)new Some((Object)this.hiveExecutionVersion()), new StringBuilder().append((Object)"Version of the Hive metastore. Available options are ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<code>0.12.0</code> through <code>", "</code>."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hiveExecutionVersion()}))).toString(), SQLConf.SQLConfEntry$.MODULE$.stringConf$default$4());
        this.HIVE_EXECUTION_VERSION = SQLConf.SQLConfEntry$.MODULE$.stringConf("spark.sql.hive.version", (Option)new Some((Object)this.hiveExecutionVersion()), "Version of Hive used internally by Spark SQL.", SQLConf.SQLConfEntry$.MODULE$.stringConf$default$4());
        this.HIVE_METASTORE_JARS = SQLConf.SQLConfEntry$.MODULE$.stringConf("spark.sql.hive.metastore.jars", (Option)new Some((Object)"builtin"), new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      | Location of the jars that should be used to instantiate the HiveMetastoreClient.\n      | This property can be one of three options: \"\n      | 1. \"builtin\"\n      |   Use Hive ", ", which is bundled with the Spark assembly jar when\n      |   <code>-Phive</code> is enabled. When this option is chosen,\n      |   <code>spark.sql.hive.metastore.version</code> must be either\n      |   <code>", "</code> or not defined.\n      | 2. \"maven\"\n      |   Use Hive jars of specified version downloaded from Maven repositories.\n      | 3. A classpath in the standard format for both Hive and Hadoop.\n    "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hiveExecutionVersion(), this.hiveExecutionVersion()})))).stripMargin(), SQLConf.SQLConfEntry$.MODULE$.stringConf$default$4());
        this.CONVERT_METASTORE_PARQUET = SQLConf.SQLConfEntry$.MODULE$.booleanConf("spark.sql.hive.convertMetastoreParquet", (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)), "When set to false, Spark SQL will use the Hive SerDe for parquet tables instead of the built in support.", SQLConf.SQLConfEntry$.MODULE$.booleanConf$default$4());
        this.CONVERT_METASTORE_PARQUET_WITH_SCHEMA_MERGING = SQLConf.SQLConfEntry$.MODULE$.booleanConf("spark.sql.hive.convertMetastoreParquet.mergeSchema", (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)), "TODO", SQLConf.SQLConfEntry$.MODULE$.booleanConf$default$4());
        this.CONVERT_CTAS = SQLConf.SQLConfEntry$.MODULE$.booleanConf("spark.sql.hive.convertCTAS", (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)), "TODO", SQLConf.SQLConfEntry$.MODULE$.booleanConf$default$4());
        this.HIVE_METASTORE_SHARED_PREFIXES = SQLConf.SQLConfEntry$.MODULE$.stringSeqConf("spark.sql.hive.metastore.sharedPrefixes", (Option)new Some(this.jdbcPrefixes()), "A comma separated list of class prefixes that should be loaded using the classloader that is shared between Spark SQL and a specific version of Hive. An example of classes that should be shared is JDBC drivers that are needed to talk to the metastore. Other classes that need to be shared are those that interact with classes that are already shared. For example, custom appenders that are used by log4j.", SQLConf.SQLConfEntry$.MODULE$.stringSeqConf$default$4());
        this.HIVE_METASTORE_BARRIER_PREFIXES = SQLConf.SQLConfEntry$.MODULE$.stringSeqConf("spark.sql.hive.metastore.barrierPrefixes", (Option)new Some((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), "A comma separated list of class prefixes that should explicitly be reloaded for each version of Hive that Spark SQL is communicating with. For example, Hive UDFs that are declared in a prefix that typically would be shared (i.e. <code>org.apache.spark.*</code>).", SQLConf.SQLConfEntry$.MODULE$.stringSeqConf$default$4());
        this.HIVE_THRIFT_SERVER_ASYNC = SQLConf.SQLConfEntry$.MODULE$.booleanConf("spark.sql.hive.thriftServer.async", (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)), "TODO", SQLConf.SQLConfEntry$.MODULE$.booleanConf$default$4());
        this.primitiveTypes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, IntegerType$.MODULE$, LongType$.MODULE$, DoubleType$.MODULE$, FloatType$.MODULE$, BooleanType$.MODULE$, ByteType$.MODULE$, ShortType$.MODULE$, DateType$.MODULE$, TimestampType$.MODULE$, BinaryType$.MODULE$}));
    }
}

