/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.execution.ui.SparkPlanGraph$;
import org.apache.spark.util.CallSite;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;

public final class SQLExecution$ {
    public static final SQLExecution$ MODULE$;
    private final String EXECUTION_ID_KEY;
    private final AtomicLong _nextExecutionId;

    static {
        new SQLExecution$();
    }

    public String EXECUTION_ID_KEY() {
        return this.EXECUTION_ID_KEY;
    }

    private AtomicLong _nextExecutionId() {
        return this._nextExecutionId;
    }

    private long nextExecutionId() {
        return this._nextExecutionId().getAndIncrement();
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public <T> T withNewExecutionId(SQLContext sqlContext, SQLContext.QueryExecution queryExecution, Function0<T> body) {
        SparkContext sc = sqlContext.sparkContext();
        String oldExecutionId = sc.getLocalProperty(this.EXECUTION_ID_KEY());
        if (oldExecutionId == null) {
            long executionId = this.nextExecutionId();
            sc.setLocalProperty(this.EXECUTION_ID_KEY(), ((Object)BoxesRunTime.boxToLong((long)executionId)).toString());
            CallSite callSite = Utils$.MODULE$.getCallSite(Utils$.MODULE$.getCallSite$default$1());
            sqlContext.listener().onExecutionStart(executionId, callSite.shortForm(), callSite.longForm(), queryExecution.toString(), SparkPlanGraph$.MODULE$.apply(queryExecution.executedPlan()), System.currentTimeMillis());
            Object object = body.apply();
            sqlContext.listener().onExecutionEnd(executionId, System.currentTimeMillis());
            Object r = object;
            return (T)r;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is already set"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.EXECUTION_ID_KEY()})));
        {
            catch (Throwable throwable) {
                void var6_6;
                sqlContext.listener().onExecutionEnd((long)var6_6, System.currentTimeMillis());
                throw throwable;
            }
        }
        finally {
            sc.setLocalProperty(this.EXECUTION_ID_KEY(), null);
        }
    }

    public <T> T withExecutionId(SparkContext sc, String executionId, Function0<T> body) {
        String oldExecutionId = sc.getLocalProperty(this.EXECUTION_ID_KEY());
        try {
            sc.setLocalProperty(this.EXECUTION_ID_KEY(), executionId);
            return (T)body.apply();
        }
        finally {
            sc.setLocalProperty(this.EXECUTION_ID_KEY(), oldExecutionId);
        }
    }

    private SQLExecution$() {
        MODULE$ = this;
        this.EXECUTION_ID_KEY = "spark.sql.execution.id";
        this._nextExecutionId = new AtomicLong(0L);
    }
}

