/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.spark.SparkException;
import org.apache.spark.TaskContext;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.BaseWriterContainer;
import org.apache.spark.sql.sources.HadoopFsRelation;
import org.apache.spark.sql.sources.OutputWriter;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;

@ScalaSignature(bytes="\u0006\u0001m3Q!\u0001\u0002\u0001\r9\u0011a\u0003R3gCVdGo\u0016:ji\u0016\u00148i\u001c8uC&tWM\u001d\u0006\u0003\u0007\u0011\t1\u0002Z1uCN|WO]2fg*\u0011QAB\u0001\nKb,7-\u001e;j_:T!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h'\t\u0001q\u0002\u0005\u0002\u0011#5\t!!\u0003\u0002\u0013\u0005\t\u0019\")Y:f/JLG/\u001a:D_:$\u0018-\u001b8fe\"IA\u0003\u0001B\u0001B\u0003%a\u0003H\u0001\te\u0016d\u0017\r^5p]\u000e\u0001\u0001CA\f\u001b\u001b\u0005A\"BA\r\u0007\u0003\u001d\u0019x.\u001e:dKNL!a\u0007\r\u0003!!\u000bGm\\8q\rN\u0014V\r\\1uS>t\u0017B\u0001\u000b\u0012Q\t\u0019b\u0004\u0005\u0002 E5\t\u0001EC\u0001\"\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0003EA\u0005ue\u0006t7/[3oi\"AQ\u0005\u0001B\u0001B\u0003%a%A\u0002k_\n\u0004\"a\n\u0017\u000e\u0003!R!!\u000b\u0016\u0002\u00135\f\u0007O]3ek\u000e,'BA\u0016\u000b\u0003\u0019A\u0017\rZ8pa&\u0011Q\u0006\u000b\u0002\u0004\u0015>\u0014\u0007F\u0001\u0013\u001f\u0011!\u0001\u0004A!A!\u0002\u0013\t\u0014\u0001C5t\u0003B\u0004XM\u001c3\u0011\u0005}\u0011\u0014BA\u001a!\u0005\u001d\u0011un\u001c7fC:DQ!\u000e\u0001\u0005\u0002Y\na\u0001P5oSRtD\u0003B\u001c9si\u0002\"\u0001\u0005\u0001\t\u000bQ!\u0004\u0019\u0001\f\t\u000b\u0015\"\u0004\u0019\u0001\u0014\t\u000bA\"\u0004\u0019A\u0019\t\u000bq\u0002A\u0011A\u001f\u0002\u0013]\u0014\u0018\u000e^3S_^\u001cHc\u0001 B\u000fB\u0011qdP\u0005\u0003\u0001\u0002\u0012A!\u00168ji\")!i\u000fa\u0001\u0007\u0006YA/Y:l\u0007>tG/\u001a=u!\t!U)D\u0001\t\u0013\t1\u0005BA\u0006UCN\\7i\u001c8uKb$\b\"\u0002%<\u0001\u0004I\u0015\u0001C5uKJ\fGo\u001c:\u0011\u0007)\u0013VK\u0004\u0002L!:\u0011AjT\u0007\u0002\u001b*\u0011a*F\u0001\u0007yI|w\u000e\u001e \n\u0003\u0005J!!\u0015\u0011\u0002\u000fA\f7m[1hK&\u00111\u000b\u0016\u0002\t\u0013R,'/\u0019;pe*\u0011\u0011\u000b\t\t\u0003-fk\u0011a\u0016\u0006\u00031\u001a\t\u0001bY1uC2L8\u000f^\u0005\u00035^\u00131\"\u00138uKJt\u0017\r\u001c*po\u0002")
public class DefaultWriterContainer
extends BaseWriterContainer {
    @Override
    public void writeRows(TaskContext taskContext, Iterator<InternalRow> iterator) {
        this.executorSideSetup(taskContext);
        Configuration configuration = SparkHadoopUtil$.MODULE$.get().getConfigurationFromJobContext((JobContext)this.taskAttemptContext());
        configuration.set("spark.sql.sources.output.path", this.outputPath());
        OutputWriter writer = this.outputWriterFactory().newInstance(this.getWorkPath(), this.dataSchema(), this.taskAttemptContext());
        writer.initConverter(this.dataSchema());
        BooleanRef writerClosed = new BooleanRef(false);
        try {
            while (iterator.hasNext()) {
                InternalRow internalRow = (InternalRow)iterator.next();
                writer.writeInternal(internalRow);
            }
            this.commitTask$1(writer, writerClosed);
            return;
        }
        catch (Throwable throwable) {
            this.logError((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Aborting task.";
                }
            }, throwable);
            this.abortTask$1(writer, writerClosed);
            throw new SparkException("Task failed while writing rows.", throwable);
        }
    }

    private final void commitTask$1(OutputWriter writer$1, BooleanRef writerClosed$1) {
        try {
            Predef$.MODULE$.assert(writer$1 != null, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "OutputWriter instance should have been initialized";
                }
            });
            if (!writerClosed$1.elem) {
                writer$1.close();
                writerClosed$1.elem = true;
            }
            super.commitTask();
            return;
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Failed to commit task", throwable);
        }
    }

    private final void abortTask$1(OutputWriter writer$1, BooleanRef writerClosed$1) {
        try {
            if (!writerClosed$1.elem) {
                writer$1.close();
                writerClosed$1.elem = true;
            }
            return;
        }
        finally {
            super.abortTask();
        }
    }

    public DefaultWriterContainer(HadoopFsRelation relation, Job job, boolean isAppend) {
        super(relation, job, isAppend);
    }
}

