/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.json;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.WildcardUtil;
import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.PrepareOperations;
import org.apache.struts2.json.JSONCleaner;
import org.apache.struts2.json.JSONException;
import org.apache.struts2.json.JSONPopulator;
import org.apache.struts2.json.JSONUtil;
import org.apache.struts2.json.SerializationParams;
import org.apache.struts2.json.annotations.SMDMethod;
import org.apache.struts2.json.rpc.RPCError;
import org.apache.struts2.json.rpc.RPCErrorCode;
import org.apache.struts2.json.rpc.RPCResponse;

public class JSONInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 4950170304212158803L;
    private static final Logger LOG = LogManager.getLogger(JSONInterceptor.class);
    private boolean enableSMD = false;
    private boolean enableGZIP = false;
    private boolean wrapWithComments;
    private boolean prefix;
    private String defaultEncoding = "UTF-8";
    private boolean ignoreHierarchy = true;
    private String root;
    private List<Pattern> excludeProperties;
    private List<Pattern> includeProperties;
    private boolean ignoreSMDMethodInterfaces = true;
    private JSONPopulator populator = new JSONPopulator();
    private JSONCleaner dataCleaner = null;
    private boolean debug = false;
    private boolean noCache = false;
    private boolean excludeNullProperties;
    private String callbackParameter;
    private String jsonContentType = "application/json";
    private String jsonRpcContentType = "application/json-rpc";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String intercept(ActionInvocation invocation) throws Exception {
        RPCResponse result;
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        String requestContentType = this.readContentType(request);
        String requestContentTypeEncoding = this.readContentTypeEncoding(request);
        Object rootObject = null;
        ValueStack stack = invocation.getStack();
        if (this.root != null && (rootObject = stack.findValue(this.root)) == null) {
            throw new RuntimeException("Invalid root expression: '" + this.root + "'.");
        }
        if (this.jsonContentType.equalsIgnoreCase(requestContentType)) {
            HashMap obj = JSONUtil.deserialize(request.getReader());
            if (obj instanceof List && this.root != null) {
                String mapKey = this.root;
                rootObject = null;
                if (this.root.indexOf(46) != -1) {
                    mapKey = this.root.substring(this.root.lastIndexOf(46) + 1);
                    rootObject = stack.findValue(this.root.substring(0, this.root.lastIndexOf(46)));
                    if (rootObject == null) {
                        throw new RuntimeException("JSON array: Invalid root expression: '" + this.root + "'.");
                    }
                }
                HashMap m = new HashMap();
                m.put(mapKey, new ArrayList((List)((Object)obj)));
                obj = m;
            }
            if (!(obj instanceof Map)) {
                LOG.error("Unable to deserialize JSON object from request");
                throw new JSONException("Unable to deserialize JSON object from request");
            }
            Map json = obj;
            if (this.dataCleaner != null) {
                this.dataCleaner.clean("", json);
            }
            if (rootObject == null) {
                rootObject = invocation.getStack().peek();
            }
            this.populator.populateObject(rootObject, json);
            return invocation.invoke();
        }
        if (!this.jsonRpcContentType.equalsIgnoreCase(requestContentType)) {
            LOG.debug("Accept header parameter must be '{}' or '{}'. Ignoring request with Content Type '{}'", (Object)this.jsonContentType, (Object)this.jsonRpcContentType, (Object)requestContentType);
            return invocation.invoke();
        }
        if (this.enableSMD) {
            Object obj = JSONUtil.deserialize(request.getReader());
            if (obj instanceof Map) {
                Map smd = (Map)obj;
                if (rootObject == null) {
                    rootObject = invocation.getAction();
                }
                try {
                    result = this.invoke(rootObject, smd);
                }
                catch (Exception e) {
                    RPCResponse rpcResponse = new RPCResponse();
                    rpcResponse.setId(smd.get("id").toString());
                    rpcResponse.setError(new RPCError((Throwable)e, RPCErrorCode.EXCEPTION, this.getDebug()));
                    result = rpcResponse;
                }
            } else {
                String message = "SMD request was not in the right format. See http://json-rpc.org";
                RPCResponse rpcResponse = new RPCResponse();
                rpcResponse.setError(new RPCError(message, RPCErrorCode.INVALID_PROCEDURE_CALL));
                result = rpcResponse;
            }
        } else {
            String message = "Request with content type of 'application/json-rpc' was received but SMD is not enabled for this interceptor. Set 'enableSMD' to true to enable it";
            RPCResponse rpcResponse = new RPCResponse();
            rpcResponse.setError(new RPCError(message, RPCErrorCode.SMD_DISABLED));
            result = rpcResponse;
        }
        String json = JSONUtil.serialize(result, this.excludeProperties, (Collection<Pattern>)this.getIncludeProperties(), this.ignoreHierarchy, this.excludeNullProperties);
        json = this.addCallbackIfApplicable(request, json);
        boolean writeGzip = this.enableGZIP && JSONUtil.isGzipInRequest(request);
        JSONUtil.writeJSONToResponse(new SerializationParams(response, requestContentTypeEncoding, this.wrapWithComments, json, true, writeGzip, this.noCache, -1, -1, this.prefix, "application/json"));
        return "none";
    }

    protected String readContentType(HttpServletRequest request) {
        String contentType = request.getHeader("Content-Type");
        LOG.debug("Content Type from request: {}", (Object)contentType);
        if (contentType != null && contentType.contains(";")) {
            contentType = contentType.substring(0, contentType.indexOf(";")).trim();
        }
        return contentType;
    }

    protected String readContentTypeEncoding(HttpServletRequest request) {
        String contentTypeEncoding = request.getHeader("Content-Type");
        LOG.debug("Content Type encoding from request: {}", (Object)contentTypeEncoding);
        contentTypeEncoding = contentTypeEncoding != null && contentTypeEncoding.contains(";charset=") ? contentTypeEncoding.substring(contentTypeEncoding.indexOf(";charset=") + ";charset=".length()).trim() : this.defaultEncoding;
        LOG.debug("Content Type encoding to be used in de-serialisation: {}", (Object)contentTypeEncoding);
        return contentTypeEncoding;
    }

    public RPCResponse invoke(Object object, Map data) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, JSONException, InstantiationException, NoSuchMethodException, IntrospectionException {
        RPCResponse response = new RPCResponse();
        Object id = data.get("id");
        if (id == null) {
            String message = "'id' is required for JSON RPC";
            response.setError(new RPCError(message, RPCErrorCode.METHOD_NOT_FOUND));
            return response;
        }
        response.setId(id.toString());
        Class<?> clazz = object.getClass();
        List parameters = (List)data.get("params");
        int parameterCount = parameters != null ? parameters.size() : 0;
        String methodName = (String)data.get("method");
        if (methodName == null) {
            String message = "'method' is required for JSON RPC";
            response.setError(new RPCError(message, RPCErrorCode.MISSING_METHOD));
            return response;
        }
        Method method = this.getMethod(clazz, methodName, parameterCount);
        if (method == null) {
            String message = "Method " + methodName + " could not be found in action class.";
            response.setError(new RPCError(message, RPCErrorCode.METHOD_NOT_FOUND));
            return response;
        }
        if (parameterCount > 0) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            Type[] genericTypes = method.getGenericParameterTypes();
            ArrayList<Object> invocationParameters = new ArrayList<Object>();
            if (parameterTypes.length != parameterCount) {
                String message = "Parameter count in request, " + parameterCount + " do not match expected parameter count for " + methodName + ", " + parameterTypes.length;
                response.setError(new RPCError(message, RPCErrorCode.PARAMETERS_MISMATCH));
                return response;
            }
            for (int i = 0; i < parameters.size(); ++i) {
                Object parameter = parameters.get(i);
                Class<?> paramType = parameterTypes[i];
                Type genericType = genericTypes[i];
                if (this.dataCleaner != null) {
                    parameter = this.dataCleaner.clean("[" + i + "]", parameter);
                }
                Object converted = this.populator.convert(paramType, genericType, parameter, method);
                invocationParameters.add(converted);
            }
            response.setResult(method.invoke(object, invocationParameters.toArray()));
        } else {
            response.setResult(method.invoke(object, new Object[0]));
        }
        return response;
    }

    private Method getMethod(Class clazz, String name, int parameterCount) {
        Method[] smdMethods;
        for (Method method : smdMethods = JSONUtil.listSMDMethods(clazz, this.ignoreSMDMethodInterfaces)) {
            if (!this.checkSMDMethodSignature(method, name, parameterCount)) continue;
            return method;
        }
        return null;
    }

    private boolean checkSMDMethodSignature(Method method, String name, int parameterCount) {
        SMDMethod smdMethodAnntotation = method.getAnnotation(SMDMethod.class);
        if (smdMethodAnntotation != null) {
            boolean paramsMatch;
            String alias = smdMethodAnntotation.name();
            boolean bl = paramsMatch = method.getParameterTypes().length == parameterCount;
            if (alias.length() == 0 && method.getName().equals(name) && paramsMatch || alias.equals(name) && paramsMatch) {
                return true;
            }
        }
        return false;
    }

    protected String addCallbackIfApplicable(HttpServletRequest request, String json) {
        String callbackName;
        if (this.callbackParameter != null && this.callbackParameter.length() > 0 && (callbackName = request.getParameter(this.callbackParameter)) != null && callbackName.length() > 0) {
            json = callbackName + "(" + json + ")";
        }
        return json;
    }

    public boolean isEnableSMD() {
        return this.enableSMD;
    }

    public void setEnableSMD(boolean enableSMD) {
        this.enableSMD = enableSMD;
    }

    public void setIgnoreSMDMethodInterfaces(boolean ignoreSMDMethodInterfaces) {
        this.ignoreSMDMethodInterfaces = ignoreSMDMethodInterfaces;
    }

    public void setWrapWithComments(boolean wrapWithComments) {
        this.wrapWithComments = wrapWithComments;
    }

    @Inject(value="struts.i18n.encoding")
    public void setDefaultEncoding(String val) {
        this.defaultEncoding = val;
    }

    public void setIgnoreHierarchy(boolean ignoreHierarchy) {
        this.ignoreHierarchy = ignoreHierarchy;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public void setJSONPopulator(JSONPopulator populator) {
        this.populator = populator;
    }

    public void setJSONCleaner(JSONCleaner dataCleaner) {
        this.dataCleaner = dataCleaner;
    }

    public boolean getDebug() {
        Boolean devModeOverride = PrepareOperations.getDevModeOverride();
        return devModeOverride != null ? devModeOverride : this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Inject(value="struts.devMode")
    public void setDevMode(String mode) {
        this.setDebug(BooleanUtils.toBoolean((String)mode));
    }

    public void setExcludeProperties(String commaDelim) {
        Set<String> excludePatterns = JSONUtil.asSet(commaDelim);
        if (excludePatterns != null) {
            this.excludeProperties = new ArrayList<Pattern>(excludePatterns.size());
            for (String pattern : excludePatterns) {
                this.excludeProperties.add(Pattern.compile(pattern));
            }
        }
    }

    public void setExcludeWildcards(String commaDelim) {
        Set<String> excludePatterns = JSONUtil.asSet(commaDelim);
        if (excludePatterns != null) {
            this.excludeProperties = new ArrayList<Pattern>(excludePatterns.size());
            for (String pattern : excludePatterns) {
                this.excludeProperties.add(WildcardUtil.compileWildcardPattern((String)pattern));
            }
        }
    }

    public void setIncludeProperties(String commaDelim) {
        this.includeProperties = JSONUtil.processIncludePatterns(JSONUtil.asSet(commaDelim), "regexp");
    }

    public void setIncludeWildcards(String commaDelim) {
        this.includeProperties = JSONUtil.processIncludePatterns(JSONUtil.asSet(commaDelim), "wildcard");
        if (this.includeProperties != null) {
            this.includeProperties.add(Pattern.compile("id"));
            this.includeProperties.add(Pattern.compile("result"));
            this.includeProperties.add(Pattern.compile("error"));
            this.includeProperties.add(WildcardUtil.compileWildcardPattern((String)"error.code"));
        }
    }

    protected List getIncludeProperties() {
        if (this.includeProperties != null && this.getDebug()) {
            ArrayList<Pattern> list = new ArrayList<Pattern>(this.includeProperties);
            list.add(Pattern.compile("debug"));
            list.add(WildcardUtil.compileWildcardPattern((String)"error.*"));
            return list;
        }
        return this.includeProperties;
    }

    public boolean isEnableGZIP() {
        return this.enableGZIP;
    }

    public void setEnableGZIP(boolean enableGZIP) {
        this.enableGZIP = enableGZIP;
    }

    public boolean isNoCache() {
        return this.noCache;
    }

    public void setNoCache(boolean noCache) {
        this.noCache = noCache;
    }

    public boolean isExcludeNullProperties() {
        return this.excludeNullProperties;
    }

    public void setExcludeNullProperties(boolean excludeNullProperties) {
        this.excludeNullProperties = excludeNullProperties;
    }

    public void setCallbackParameter(String callbackParameter) {
        this.callbackParameter = callbackParameter;
    }

    public String getCallbackParameter() {
        return this.callbackParameter;
    }

    public void setPrefix(boolean prefix) {
        this.prefix = prefix;
    }

    public void setJsonContentType(String jsonContentType) {
        this.jsonContentType = jsonContentType;
    }

    public void setJsonRpcContentType(String jsonRpcContentType) {
        this.jsonRpcContentType = jsonRpcContentType;
    }
}

