/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om;

import java.util.HashMap;
import org.apache.axiom.util.UIDGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OMOutputFormat {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$axiom$om$OMOutputFormat == null ? (class$org$apache$axiom$om$OMOutputFormat = OMOutputFormat.class$("org.apache.axiom.om.OMOutputFormat")) : class$org$apache$axiom$om$OMOutputFormat));
    private String mimeBoundary = null;
    private String rootContentId = null;
    private int nextid = 0;
    private boolean doOptimize = false;
    private boolean doingSWA = false;
    private boolean isSoap11 = true;
    private int optimizedThreshold = 0;
    public static final String DEFAULT_CHAR_SET_ENCODING = "utf-8";
    private String charSetEncoding;
    private String xmlVersion;
    private String contentType;
    private boolean ignoreXMLDeclaration = false;
    private boolean autoCloseWriter = false;
    public static final String ACTION_PROPERTY = "action";
    public static final String USE_CTE_BASE64_FOR_NON_TEXTUAL_ATTACHMENTS = "org.apache.axiom.om.OMFormat.use.cteBase64.forNonTextualAttachments";
    public static final String RESPECT_SWA_ATTACHMENT_ORDER = "org.apache.axiom.om.OMFormat.respectSWAAttachmentOrder";
    public static final Boolean RESPECT_SWA_ATTACHMENT_ORDER_DEFAULT = Boolean.TRUE;
    HashMap map = null;
    static /* synthetic */ Class class$org$apache$axiom$om$OMOutputFormat;

    public Object getProperty(String key) {
        if (this.map == null) {
            return null;
        }
        return this.map.get(key);
    }

    public Object setProperty(String key, Object value) {
        if (this.map == null) {
            this.map = new HashMap();
        }
        return this.map.put(key, value);
    }

    public boolean containsKey(String key) {
        if (this.map == null) {
            return false;
        }
        return this.map.containsKey(key);
    }

    public boolean isOptimized() {
        return this.doOptimize && !this.doingSWA;
    }

    public String getContentType() {
        String ct = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start getContentType: " + this.toString()));
        }
        if (this.contentType == null) {
            this.contentType = this.isSoap11 ? "text/xml" : "application/soap+xml";
        }
        ct = this.isOptimized() ? (this.isDoingSWA() ? this.getContentTypeForSwA(this.contentType) : this.getContentTypeForMTOM(this.contentType)) : (this.isDoingSWA() ? this.getContentTypeForSwA(this.contentType) : this.contentType);
        if (log.isDebugEnabled()) {
            log.debug((Object)("getContentType= {" + ct + "}   " + this.toString()));
        }
        return ct;
    }

    public void setContentType(String c) {
        this.contentType = c;
    }

    public String getMimeBoundary() {
        if (this.mimeBoundary == null) {
            this.mimeBoundary = UIDGenerator.generateMimeBoundary();
        }
        return this.mimeBoundary;
    }

    public String getRootContentId() {
        if (this.rootContentId == null) {
            this.rootContentId = "0." + UIDGenerator.generateContentId();
        }
        return this.rootContentId;
    }

    public String getNextContentId() {
        ++this.nextid;
        return this.nextid + "." + UIDGenerator.generateContentId();
    }

    public String getCharSetEncoding() {
        return this.charSetEncoding;
    }

    public void setCharSetEncoding(String charSetEncoding) {
        this.charSetEncoding = charSetEncoding;
    }

    public String getXmlVersion() {
        return this.xmlVersion;
    }

    public void setXmlVersion(String xmlVersion) {
        this.xmlVersion = xmlVersion;
    }

    public void setSOAP11(boolean b) {
        this.isSoap11 = b;
    }

    public boolean isSOAP11() {
        return this.isSoap11;
    }

    public boolean isIgnoreXMLDeclaration() {
        return this.ignoreXMLDeclaration;
    }

    public void setIgnoreXMLDeclaration(boolean ignoreXMLDeclaration) {
        this.ignoreXMLDeclaration = ignoreXMLDeclaration;
    }

    public void setDoOptimize(boolean b) {
        this.doOptimize = b;
    }

    public boolean isDoingSWA() {
        return this.doingSWA;
    }

    public void setDoingSWA(boolean doingSWA) {
        this.doingSWA = doingSWA;
    }

    public String getContentTypeForMTOM(String SOAPContentType) {
        String action;
        if (this.containsKey(ACTION_PROPERTY) && (action = (String)this.getProperty(ACTION_PROPERTY)) != null && action.length() > 0) {
            SOAPContentType = SOAPContentType + "; action=\\\"" + action + "\\\"";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("multipart/related");
        sb.append("; ");
        sb.append("boundary=");
        sb.append("\"");
        sb.append(this.getMimeBoundary());
        sb.append("\"");
        sb.append("; ");
        sb.append("type=\"application/xop+xml\"");
        sb.append("; ");
        sb.append("start=\"<").append(this.getRootContentId()).append(">\"");
        sb.append("; ");
        sb.append("start-info=\"").append(SOAPContentType).append("\"");
        return sb.toString();
    }

    public String getContentTypeForSwA(String SOAPContentType) {
        StringBuffer sb = new StringBuffer();
        sb.append("multipart/related");
        sb.append("; ");
        sb.append("boundary=");
        sb.append("\"");
        sb.append(this.getMimeBoundary());
        sb.append("\"");
        sb.append("; ");
        sb.append("type=\"").append(SOAPContentType).append("\"");
        sb.append("; ");
        sb.append("start=\"<").append(this.getRootContentId()).append(">\"");
        return sb.toString();
    }

    public boolean isAutoCloseWriter() {
        return this.autoCloseWriter;
    }

    public void setAutoCloseWriter(boolean autoCloseWriter) {
        this.autoCloseWriter = autoCloseWriter;
    }

    public void setMimeBoundary(String mimeBoundary) {
        this.mimeBoundary = mimeBoundary;
    }

    public void setRootContentId(String rootContentId) {
        this.rootContentId = rootContentId;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("OMOutputFormat [");
        sb.append(" mimeBoundary =");
        sb.append(this.mimeBoundary);
        sb.append(" rootContentId=");
        sb.append(this.rootContentId);
        sb.append(" doOptimize=");
        sb.append(this.doOptimize);
        sb.append(" doingSWA=");
        sb.append(this.doingSWA);
        sb.append(" isSOAP11=");
        sb.append(this.isSoap11);
        sb.append(" charSetEncoding=");
        sb.append(this.charSetEncoding);
        sb.append(" xmlVersion=");
        sb.append(this.xmlVersion);
        sb.append(" contentType=");
        sb.append(this.contentType);
        sb.append(" ignoreXmlDeclaration=");
        sb.append(this.ignoreXMLDeclaration);
        sb.append(" autoCloseWriter=");
        sb.append(this.autoCloseWriter);
        sb.append(" actionProperty=");
        sb.append(this.getProperty(ACTION_PROPERTY));
        sb.append(" optimizedThreshold=");
        sb.append(this.optimizedThreshold);
        sb.append("]");
        return sb.toString();
    }

    public void setOptimizedThreshold(int optimizedThreshold) {
        this.optimizedThreshold = optimizedThreshold;
    }

    public int getOptimizedThreshold() {
        return this.optimizedThreshold;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

