/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.handler;

import java.util.HashMap;
import java.util.Map;

public final class WSHandlerConstants {
    public static final String ACTION = "action";
    public static final String NO_SECURITY = "NoSecurity";
    public static final String USERNAME_TOKEN = "UsernameToken";
    public static final String USERNAME_TOKEN_NO_PASSWORD = "UsernameTokenNoPassword";
    public static final String SAML_TOKEN_UNSIGNED = "SAMLTokenUnsigned";
    public static final String SAML_TOKEN_SIGNED = "SAMLTokenSigned";
    public static final String SIGNATURE = "Signature";
    public static final String ENCRYPT = "Encrypt";
    public static final String TIMESTAMP = "Timestamp";
    public static final String SIGN_WITH_UT_KEY = "UsernameTokenSignature";
    public static final String ACTOR = "actor";
    public static final String USER = "user";
    public static final String ENCRYPTION_USER = "encryptionUser";
    public static final String SIGNATURE_USER = "signatureUser";
    public static final String USE_REQ_SIG_CERT = "useReqSigCert";
    public static final String PW_CALLBACK_CLASS = "passwordCallbackClass";
    public static final String PW_CALLBACK_REF = "passwordCallbackRef";
    public static final String SAML_CALLBACK_CLASS = "samlCallbackClass";
    public static final String SAML_CALLBACK_REF = "samlCallbackRef";
    public static final String ENC_CALLBACK_CLASS = "embeddedKeyCallbackClass";
    public static final String ENC_CALLBACK_REF = "embeddedKeyCallbackRef";
    public static final String SIG_PROP_FILE = "signaturePropFile";
    public static final String SIG_PROP_REF_ID = "signaturePropRefId";
    public static final String DEC_PROP_FILE = "decryptionPropFile";
    public static final String DEC_PROP_REF_ID = "decryptionPropRefId";
    public static final String ENC_PROP_FILE = "encryptionPropFile";
    public static final String ENC_PROP_REF_ID = "encryptionPropRefId";
    public static final String SAML_PROP_FILE = "samlPropFile";
    public static final String ENABLE_SIGNATURE_CONFIRMATION = "enableSignatureConfirmation";
    public static final String MUST_UNDERSTAND = "mustUnderstand";
    public static final String IS_BSP_COMPLIANT = "isBSPCompliant";
    public static final String HANDLE_CUSTOM_PASSWORD_TYPES = "handleCustomPasswordTypes";
    public static final String PASSWORD_TYPE_STRICT = "passwordTypeStrict";
    public static final String ALLOW_NAMESPACE_QUALIFIED_PASSWORD_TYPES = "allowNamespaceQualifiedPasswordTypes";
    public static final String ENABLE_REVOCATION = "enableRevocation";
    public static final String USE_ENCODED_PASSWORDS = "useEncodedPasswords";
    public static final String USE_SINGLE_CERTIFICATE = "useSingleCertificate";
    public static final String USE_DERIVED_KEY = "useDerivedKey";
    public static final String USE_DERIVED_KEY_FOR_MAC = "useDerivedKeyForMAC";
    public static final String TIMESTAMP_PRECISION = "precisionInMilliseconds";
    public static final String TIMESTAMP_STRICT = "timestampStrict";
    public static final String ENC_SYM_ENC_KEY = "encryptSymmetricEncryptionKey";
    public static final String REQUIRE_SIGNED_ENCRYPTED_DATA_ELEMENTS = "requireSignedEncryptedDataElements";
    public static final String ENC_KEY_NAME = "embeddedKeyName";
    public static final String PASSWORD_TYPE = "passwordType";
    public static final String ADD_UT_ELEMENTS = "addUTElements";
    public static final String SIG_KEY_ID = "signatureKeyIdentifier";
    public static final String SIG_ALGO = "signatureAlgorithm";
    public static final String SIG_DIGEST_ALGO = "signatureDigestAlgorithm";
    public static final String SIGNATURE_PARTS = "signatureParts";
    public static final String WSE_SECRET_KEY_LENGTH = "wseSecretKeyLength";
    public static final String DERIVED_KEY_ITERATIONS = "derivedKeyIterations";
    public static final String ENC_KEY_ID = "encryptionKeyIdentifier";
    public static final String ENC_SYM_ALGO = "encryptionSymAlgorithm";
    public static final String ENC_KEY_TRANSPORT = "encryptionKeyTransportAlgorithm";
    public static final String ENCRYPTION_PARTS = "encryptionParts";
    public static final String TTL_TIMESTAMP = "timeToLive";
    public static final String TTL_FUTURE_TIMESTAMP = "futureTimeToLive";
    public static final String SIG_SUBJECT_CERT_CONSTRAINTS = "sigSubjectCertConstraints";
    public static final String RECV_RESULTS = "RECV_RESULTS";
    public static final String SEND_SIGV = "_sendSignatureValues_";
    public static final String SIG_CONF_DONE = "_sigConfDone_";
    private static Map<String, Integer> keyIdentifier = new HashMap<String, Integer>();

    private WSHandlerConstants() {
    }

    public static Integer getKeyIdentifier(String parameter) {
        return keyIdentifier.get(parameter);
    }

    static {
        keyIdentifier.put("DirectReference", 1);
        keyIdentifier.put("IssuerSerial", 2);
        keyIdentifier.put("X509KeyIdentifier", 3);
        keyIdentifier.put("SKIKeyIdentifier", 4);
        keyIdentifier.put("EmbeddedKeyName", 5);
        keyIdentifier.put("Thumbprint", 8);
        keyIdentifier.put("EncryptedKeySHA1", 10);
    }
}

