/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.configuration.model.core.logout.LogoutProperties;
import org.apereo.cas.util.Pac4jUtils;
import org.apereo.cas.web.support.CookieRetrievingCookieGenerator;
import org.apereo.cas.web.support.WebUtils;
import org.pac4j.core.profile.ProfileManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class TerminateSessionAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(TerminateSessionAction.class);
    private final EventFactorySupport eventFactorySupport = new EventFactorySupport();
    private final CentralAuthenticationService centralAuthenticationService;
    private final CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator;
    private final CookieRetrievingCookieGenerator warnCookieGenerator;
    private final LogoutProperties logoutProperties;

    public TerminateSessionAction(CentralAuthenticationService centralAuthenticationService, CookieRetrievingCookieGenerator tgtCookieGenerator, CookieRetrievingCookieGenerator warnCookieGenerator, LogoutProperties logoutProperties) {
        this.centralAuthenticationService = centralAuthenticationService;
        this.ticketGrantingTicketCookieGenerator = tgtCookieGenerator;
        this.warnCookieGenerator = warnCookieGenerator;
        this.logoutProperties = logoutProperties;
    }

    public Event doExecute(RequestContext requestContext) {
        boolean terminateSession = true;
        if (this.logoutProperties.isConfirmLogout()) {
            terminateSession = TerminateSessionAction.isLogoutRequestConfirmed(requestContext);
        }
        if (terminateSession) {
            return this.terminate(requestContext);
        }
        return this.eventFactorySupport.event((Object)this, "warn");
    }

    public Event terminate(RequestContext context) {
        try {
            HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
            HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)context);
            String tgtId = WebUtils.getTicketGrantingTicketId((RequestContext)context);
            if (tgtId == null) {
                tgtId = this.ticketGrantingTicketCookieGenerator.retrieveCookieValue(request);
            }
            if (tgtId != null) {
                LOGGER.debug("Destroying SSO session linked to ticket-granting ticket [{}]", (Object)tgtId);
                List logoutRequests = this.centralAuthenticationService.destroyTicketGrantingTicket(tgtId);
                WebUtils.putLogoutRequests((RequestContext)context, (List)logoutRequests);
            }
            LOGGER.debug("Removing CAS cookies");
            this.ticketGrantingTicketCookieGenerator.removeCookie(response);
            this.warnCookieGenerator.removeCookie(response);
            this.destroyApplicationSession(request, response);
            LOGGER.debug("Terminated all CAS sessions successfully.");
            return this.eventFactorySupport.success((Object)this);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected void destroyApplicationSession(HttpServletRequest request, HttpServletResponse response) {
        LOGGER.debug("Destroying application session");
        ProfileManager manager = Pac4jUtils.getPac4jProfileManager((HttpServletRequest)request, (HttpServletResponse)response);
        manager.logout();
        HttpSession session = request.getSession();
        if (session != null) {
            session.invalidate();
        }
    }

    private static boolean isLogoutRequestConfirmed(RequestContext requestContext) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        return request.getParameterMap().containsKey("LogoutRequestConfirmed");
    }
}

