/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.login;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlan;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.principal.NullPrincipal;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategy;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.repository.NoSuchFlowExecutionException;

public class InitialFlowSetupAction
extends AbstractAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(InitialFlowSetupAction.class);
    private final List<ArgumentExtractor> argumentExtractors;
    private final ServicesManager servicesManager;
    private final AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies;
    private final CasCookieBuilder ticketGrantingTicketCookieGenerator;
    private final CasCookieBuilder warnCookieGenerator;
    private final CasConfigurationProperties casProperties;
    private final AuthenticationEventExecutionPlan authenticationEventExecutionPlan;
    private final SingleSignOnParticipationStrategy renewalStrategy;
    private final TicketRegistrySupport ticketRegistrySupport;

    public Event doExecute(RequestContext context) {
        this.configureCookieGenerators(context);
        this.configureWebflowContext(context);
        InitialFlowSetupAction.configureWebflowForPostParameters(context);
        this.configureWebflowForCustomFields(context);
        this.configureWebflowForServices(context);
        String ticketGrantingTicketId = this.configureWebflowForTicketGrantingTicket(context);
        this.configureWebflowForSsoParticipation(context, ticketGrantingTicketId);
        return this.success();
    }

    private String configureWebflowForTicketGrantingTicket(RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)context);
        String ticketGrantingTicketId = this.ticketGrantingTicketCookieGenerator.retrieveCookieValue(request);
        TicketGrantingTicket ticket = this.ticketRegistrySupport.getTicketGrantingTicket(ticketGrantingTicketId);
        if (ticket != null) {
            WebUtils.putTicketGrantingTicketInScopes((RequestContext)context, (String)ticket.getId());
            return ticket.getId();
        }
        this.ticketGrantingTicketCookieGenerator.removeCookie(response);
        WebUtils.putTicketGrantingTicketInScopes((RequestContext)context, (String)"");
        return null;
    }

    private void configureWebflowForCustomFields(RequestContext context) {
        WebUtils.putCustomLoginFormFields((RequestContext)context, (Map)this.casProperties.getView().getCustomLoginFormFields());
    }

    private static void configureWebflowForPostParameters(RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
        if (request.getMethod().equalsIgnoreCase(HttpMethod.POST.name())) {
            WebUtils.putInitialHttpRequestPostParameters((RequestContext)context);
        }
    }

    private void configureWebflowForServices(RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
        WebApplicationService service = WebUtils.getService(this.argumentExtractors, (RequestContext)context);
        if (service != null) {
            LOGGER.debug("Placing service in context scope: [{}]", (Object)service.getId());
            Service selectedService = this.authenticationRequestServiceSelectionStrategies.resolveService((Service)service);
            RegisteredService registeredService = this.servicesManager.findServiceBy(selectedService);
            RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((RegisteredService)registeredService);
            if (registeredService != null && registeredService.getAccessStrategy().isServiceAccessAllowed()) {
                LOGGER.debug("Placing registered service [{}] with id [{}] in context scope", (Object)registeredService.getServiceId(), (Object)registeredService.getId());
                WebUtils.putRegisteredService((RequestContext)context, (RegisteredService)registeredService);
                RegisteredServiceAccessStrategy accessStrategy = registeredService.getAccessStrategy();
                if (accessStrategy.getUnauthorizedRedirectUrl() != null) {
                    LOGGER.debug("Placing registered service's unauthorized redirect url [{}] with id [{}] in context scope", (Object)accessStrategy.getUnauthorizedRedirectUrl(), (Object)registeredService.getServiceId());
                    WebUtils.putUnauthorizedRedirectUrlIntoFlowScope((RequestContext)context, (URI)accessStrategy.getUnauthorizedRedirectUrl());
                }
            }
        } else if (!this.casProperties.getSso().isAllowMissingServiceParameter()) {
            LOGGER.warn("No service authentication request is available at [{}]. CAS is configured to disable the flow.", (Object)request.getRequestURL());
            throw new NoSuchFlowExecutionException(context.getFlowExecutionContext().getKey(), (Exception)new UnauthorizedServiceException("screen.service.required.message", "Service is required"));
        }
        WebUtils.putServiceIntoFlowScope((RequestContext)context, (Service)service);
    }

    private void configureWebflowForSsoParticipation(RequestContext context, String ticketGrantingTicketId) {
        boolean ssoParticipation;
        boolean bl = ssoParticipation = this.renewalStrategy.supports(context) && this.renewalStrategy.isParticipating(context);
        if (!ssoParticipation && StringUtils.isNotBlank((CharSequence)ticketGrantingTicketId)) {
            Authentication auth = this.ticketRegistrySupport.getAuthenticationFrom(ticketGrantingTicketId);
            if (auth != null) {
                WebUtils.putExistingSingleSignOnSessionAvailable((RequestContext)context, (boolean)true);
                WebUtils.putExistingSingleSignOnSessionPrincipal((RequestContext)context, (Principal)auth.getPrincipal());
            } else {
                WebUtils.putExistingSingleSignOnSessionAvailable((RequestContext)context, (boolean)false);
                WebUtils.putExistingSingleSignOnSessionPrincipal((RequestContext)context, (Principal)NullPrincipal.getInstance());
            }
        }
    }

    private void configureWebflowContext(RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
        WebUtils.putWarningCookie((RequestContext)context, (Boolean)Boolean.valueOf(this.warnCookieGenerator.retrieveCookieValue(request)));
        WebUtils.putGeoLocationTrackingIntoFlowScope((RequestContext)context, (Object)this.casProperties.getEvents().isTrackGeolocation());
        WebUtils.putPasswordManagementEnabled((RequestContext)context, (Boolean)this.casProperties.getAuthn().getPm().isEnabled());
        WebUtils.putRememberMeAuthenticationEnabled((RequestContext)context, (Boolean)this.casProperties.getTicket().getTgt().getRememberMe().isEnabled());
        WebUtils.putStaticAuthenticationIntoFlowScope((RequestContext)context, (Object)(StringUtils.isNotBlank((CharSequence)this.casProperties.getAuthn().getAccept().getUsers()) || StringUtils.isNotBlank((CharSequence)this.casProperties.getAuthn().getReject().getUsers()) ? 1 : 0));
        if (this.casProperties.getAuthn().getPolicy().isSourceSelectionEnabled()) {
            List availableHandlers = this.authenticationEventExecutionPlan.getAuthenticationHandlers().stream().filter(h -> h.supports(UsernamePasswordCredential.class)).map(h -> StringUtils.capitalize((String)h.getName().trim())).distinct().sorted().collect(Collectors.toList());
            WebUtils.putAvailableAuthenticationHandleNames((RequestContext)context, availableHandlers);
        }
    }

    private void configureCookieGenerators(RequestContext context) {
        String path;
        Object cookiePath;
        String contextPath = context.getExternalContext().getContextPath();
        Object object = cookiePath = StringUtils.isNotBlank((CharSequence)contextPath) ? contextPath + "/" : "/";
        if (this.casProperties.getWarningCookie().isAutoConfigureCookiePath()) {
            path = this.warnCookieGenerator.getCookiePath();
            if (StringUtils.isBlank((CharSequence)path)) {
                LOGGER.debug("Setting path for cookies for warn cookie generator to: [{}]", cookiePath);
                this.warnCookieGenerator.setCookiePath((String)cookiePath);
            } else {
                LOGGER.trace("Warning cookie is set to [{}] with path [{}]", (Object)this.warnCookieGenerator.getCookieDomain(), (Object)path);
            }
        }
        if (this.casProperties.getTgc().isAutoConfigureCookiePath()) {
            path = this.ticketGrantingTicketCookieGenerator.getCookiePath();
            if (StringUtils.isBlank((CharSequence)path)) {
                LOGGER.debug("Setting path for cookies for TGC cookie generator to: [{}]", cookiePath);
                this.ticketGrantingTicketCookieGenerator.setCookiePath((String)cookiePath);
            } else {
                LOGGER.trace("Ticket-granting cookie domain is [{}] with path [{}]", (Object)this.ticketGrantingTicketCookieGenerator.getCookieDomain(), (Object)path);
            }
        }
    }

    @Generated
    public InitialFlowSetupAction(List<ArgumentExtractor> argumentExtractors, ServicesManager servicesManager, AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies, CasCookieBuilder ticketGrantingTicketCookieGenerator, CasCookieBuilder warnCookieGenerator, CasConfigurationProperties casProperties, AuthenticationEventExecutionPlan authenticationEventExecutionPlan, SingleSignOnParticipationStrategy renewalStrategy, TicketRegistrySupport ticketRegistrySupport) {
        this.argumentExtractors = argumentExtractors;
        this.servicesManager = servicesManager;
        this.authenticationRequestServiceSelectionStrategies = authenticationRequestServiceSelectionStrategies;
        this.ticketGrantingTicketCookieGenerator = ticketGrantingTicketCookieGenerator;
        this.warnCookieGenerator = warnCookieGenerator;
        this.casProperties = casProperties;
        this.authenticationEventExecutionPlan = authenticationEventExecutionPlan;
        this.renewalStrategy = renewalStrategy;
        this.ticketRegistrySupport = ticketRegistrySupport;
    }

    @Generated
    public List<ArgumentExtractor> getArgumentExtractors() {
        return this.argumentExtractors;
    }

    @Generated
    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }

    @Generated
    public AuthenticationServiceSelectionPlan getAuthenticationRequestServiceSelectionStrategies() {
        return this.authenticationRequestServiceSelectionStrategies;
    }

    @Generated
    public CasCookieBuilder getTicketGrantingTicketCookieGenerator() {
        return this.ticketGrantingTicketCookieGenerator;
    }

    @Generated
    public CasCookieBuilder getWarnCookieGenerator() {
        return this.warnCookieGenerator;
    }

    @Generated
    public CasConfigurationProperties getCasProperties() {
        return this.casProperties;
    }

    @Generated
    public AuthenticationEventExecutionPlan getAuthenticationEventExecutionPlan() {
        return this.authenticationEventExecutionPlan;
    }

    @Generated
    public SingleSignOnParticipationStrategy getRenewalStrategy() {
        return this.renewalStrategy;
    }

    @Generated
    public TicketRegistrySupport getTicketRegistrySupport() {
        return this.ticketRegistrySupport;
    }
}

