/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.login;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceProperty;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.RegexUtils;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.repository.NoSuchFlowExecutionException;

public class VerifyRequiredServiceAction
extends AbstractAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(VerifyRequiredServiceAction.class);
    private final ServicesManager servicesManager;
    private final CasCookieBuilder ticketGrantingTicketCookieGenerator;
    private final CasConfigurationProperties casProperties;
    private final TicketRegistrySupport ticketRegistrySupport;

    public Event doExecute(RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
        String ticketGrantingTicketId = this.ticketGrantingTicketCookieGenerator.retrieveCookieValue(request);
        String initialService = this.casProperties.getSso().getRequiredServicePattern();
        if (StringUtils.isNotBlank((CharSequence)initialService)) {
            Pattern initialServicePattern = RegexUtils.createPattern((String)initialService);
            this.enforceInitialMandatoryService(context, ticketGrantingTicketId, initialServicePattern);
        }
        return this.success();
    }

    protected void enforceInitialMandatoryService(RequestContext context, String ticketGrantingTicketId, Pattern initialServicePattern) {
        boolean matches;
        if (this.shouldSkipRequiredServiceCheck(context, initialServicePattern)) {
            return;
        }
        List<Service> servicesToMatch = this.collectServicesToMatch(context, ticketGrantingTicketId);
        if (!servicesToMatch.isEmpty() && !(matches = servicesToMatch.stream().anyMatch(service -> RegexUtils.find((Pattern)initialServicePattern, (String)service.getId())))) {
            throw new NoSuchFlowExecutionException(context.getFlowExecutionContext().getKey(), (Exception)new UnauthorizedServiceException("screen.service.initial.message", "Service is required"));
        }
    }

    protected boolean shouldSkipRequiredServiceCheck(RequestContext context, Pattern initialServicePattern) {
        WebApplicationService service = WebUtils.getService((RequestContext)context);
        if (service == null) {
            return false;
        }
        boolean matches = RegexUtils.find((Pattern)initialServicePattern, (String)service.getId());
        if (matches) {
            return true;
        }
        RegisteredService registeredService = this.servicesManager.findServiceBy((Service)service);
        if (registeredService == null) {
            return false;
        }
        return RegisteredServiceProperty.RegisteredServiceProperties.SKIP_REQUIRED_SERVICE_CHECK.isAssignedTo(registeredService);
    }

    protected List<Service> collectServicesToMatch(RequestContext context, String ticketGrantingTicketId) {
        TicketGrantingTicket ticket;
        ArrayList<Service> servicesToMatch = new ArrayList<Service>();
        TicketGrantingTicket ticketGrantingTicket = ticket = StringUtils.isNotBlank((CharSequence)ticketGrantingTicketId) ? this.ticketRegistrySupport.getTicketGrantingTicket(ticketGrantingTicketId) : null;
        if (ticket != null) {
            servicesToMatch.addAll(ticket.getServices().values());
        }
        return servicesToMatch;
    }

    @Generated
    public VerifyRequiredServiceAction(ServicesManager servicesManager, CasCookieBuilder ticketGrantingTicketCookieGenerator, CasConfigurationProperties casProperties, TicketRegistrySupport ticketRegistrySupport) {
        this.servicesManager = servicesManager;
        this.ticketGrantingTicketCookieGenerator = ticketGrantingTicketCookieGenerator;
        this.casProperties = casProperties;
        this.ticketRegistrySupport = ticketRegistrySupport;
    }

    @Generated
    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }

    @Generated
    public CasCookieBuilder getTicketGrantingTicketCookieGenerator() {
        return this.ticketGrantingTicketCookieGenerator;
    }

    @Generated
    public CasConfigurationProperties getCasProperties() {
        return this.casProperties;
    }

    @Generated
    public TicketRegistrySupport getTicketRegistrySupport() {
        return this.ticketRegistrySupport;
    }
}

