/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.services.ServiceRegistryProperties;
import org.apereo.cas.services.JsonServiceRegistryDao;
import org.apereo.cas.services.ServiceRegistryDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="jsonServiceRegistryConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@AutoConfigureOrder(value=-2147483647)
public class JsonServiceRegistryConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonServiceRegistryConfiguration.class);
    @Autowired
    private ApplicationEventPublisher eventPublisher;
    @Autowired
    private CasConfigurationProperties casProperties;

    @Bean
    public ServiceRegistryDao serviceRegistryDao() {
        try {
            ServiceRegistryProperties registry = this.casProperties.getServiceRegistry();
            return new JsonServiceRegistryDao(registry.getJson().getLocation(), registry.isWatcherEnabled(), this.eventPublisher);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

