/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.time.Period;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlan;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.LdapAuthenticationHandler;
import org.apereo.cas.authentication.principal.DefaultPrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.principal.resolvers.ChainingPrincipalResolver;
import org.apereo.cas.authentication.principal.resolvers.EchoingPrincipalResolver;
import org.apereo.cas.authentication.support.AccountStateHandler;
import org.apereo.cas.authentication.support.DefaultAccountStateHandler;
import org.apereo.cas.authentication.support.LdapPasswordPolicyConfiguration;
import org.apereo.cas.authentication.support.OptionalWarningAccountStateHandler;
import org.apereo.cas.authentication.support.password.PasswordPolicyConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.PasswordEncoderProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalTransformationProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapAuthenticationProperties;
import org.apereo.cas.configuration.model.support.ldap.LdapAuthenticationProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.services.ServicesManager;
import org.apereo.services.persondir.IPersonAttributeDao;
import org.ldaptive.auth.AuthenticationResponseHandler;
import org.ldaptive.auth.Authenticator;
import org.ldaptive.auth.ext.ActiveDirectoryAuthenticationResponseHandler;
import org.ldaptive.auth.ext.EDirectoryAuthenticationResponseHandler;
import org.ldaptive.auth.ext.FreeIPAAuthenticationResponseHandler;
import org.ldaptive.auth.ext.PasswordExpirationAuthenticationResponseHandler;
import org.ldaptive.auth.ext.PasswordPolicyAuthenticationResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="ldapAuthenticationConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class LdapAuthenticationConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapAuthenticationConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="personDirectoryPrincipalResolver")
    private PrincipalResolver personDirectoryPrincipalResolver;
    @Autowired
    @Qualifier(value="attributeRepositories")
    private List<IPersonAttributeDao> attributeRepositories;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;

    @ConditionalOnMissingBean(name={"ldapPrincipalFactory"})
    @Bean
    public PrincipalFactory ldapPrincipalFactory() {
        return new DefaultPrincipalFactory();
    }

    @Bean
    public Collection<AuthenticationHandler> ldapAuthenticationHandlers() {
        HashSet<AuthenticationHandler> handlers = new HashSet<AuthenticationHandler>();
        this.casProperties.getAuthn().getLdap().stream().filter(LdapAuthenticationConfiguration.ldapInstanceConfigurationPredicate()).forEach(l -> {
            Map attributes = Beans.transformPrincipalAttributesListIntoMap((List)l.getPrincipalAttributeList());
            LOGGER.debug("Created and mapped principal attributes [{}] for [{}]...", (Object)attributes, (Object)l.getLdapUrl());
            LOGGER.debug("Creating ldap authenticator for [{}] and baseDn [{}]", (Object)l.getLdapUrl(), (Object)l.getBaseDn());
            Authenticator authenticator = Beans.newLdaptiveAuthenticator((AbstractLdapAuthenticationProperties)l);
            LOGGER.debug("Ldap authenticator configured with return attributes [{}] for [{}] and baseDn [{}]", new Object[]{attributes.keySet(), l.getLdapUrl(), l.getBaseDn()});
            LOGGER.debug("Creating ldap authentication handler for [{}]", (Object)l.getLdapUrl());
            LdapAuthenticationHandler handler = new LdapAuthenticationHandler(l.getName(), this.servicesManager, this.ldapPrincipalFactory(), l.getOrder(), authenticator);
            List additionalAttributes = l.getAdditionalAttributes();
            if (StringUtils.isNotBlank((CharSequence)l.getPrincipalAttributeId())) {
                additionalAttributes.add(l.getPrincipalAttributeId());
            }
            handler.setAllowMultiplePrincipalAttributeValues(l.isAllowMultiplePrincipalAttributeValues());
            handler.setAllowMissingPrincipalAttributeValue(l.isAllowMissingPrincipalAttributeValue());
            handler.setPasswordEncoder(Beans.newPasswordEncoder((PasswordEncoderProperties)l.getPasswordEncoder()));
            handler.setPrincipalNameTransformer(Beans.newPrincipalNameTransformer((PrincipalTransformationProperties)l.getPrincipalTransformation()));
            if (StringUtils.isNotBlank((CharSequence)l.getCredentialCriteria())) {
                LOGGER.debug("Ldap authentication for [{}] is filtering credentials by [{}]", (Object)l.getLdapUrl(), (Object)l.getCredentialCriteria());
                handler.setCredentialSelectionPredicate(Beans.newCredentialSelectionPredicate((String)l.getCredentialCriteria()));
            }
            if (StringUtils.isBlank((CharSequence)l.getPrincipalAttributeId())) {
                LOGGER.debug("No principal id attribute is found for ldap authentication via [{}]", (Object)l.getLdapUrl());
            } else {
                handler.setPrincipalIdAttribute(l.getPrincipalAttributeId());
                LOGGER.debug("Using principal id attribute [{}] for ldap authentication via [{}]", (Object)l.getPrincipalAttributeId(), (Object)l.getLdapUrl());
            }
            if (l.getPasswordPolicy().isEnabled()) {
                LOGGER.debug("Password policy is enabled for [{}]. Constructing password policy configuration", (Object)l.getLdapUrl());
                handler.setPasswordPolicyConfiguration((PasswordPolicyConfiguration)LdapAuthenticationConfiguration.createLdapPasswordPolicyConfiguration(l, authenticator, attributes));
            }
            handler.setPrincipalAttributeMap(attributes);
            LOGGER.debug("Initializing ldap authentication handler for [{}]", (Object)l.getLdapUrl());
            handler.initialize();
            handlers.add((AuthenticationHandler)handler);
        });
        return handlers;
    }

    private static Predicate<LdapAuthenticationProperties> ldapInstanceConfigurationPredicate() {
        return l -> {
            if (l.getType() == null) {
                LOGGER.warn("Skipping LDAP authentication entry since no type is defined");
                return false;
            }
            if (StringUtils.isBlank((CharSequence)l.getLdapUrl())) {
                LOGGER.warn("Skipping LDAP authentication entry since no ldap url is defined");
                return false;
            }
            return true;
        };
    }

    private static LdapPasswordPolicyConfiguration createLdapPasswordPolicyConfiguration(LdapAuthenticationProperties l, Authenticator authenticator, Map<String, String> attributes) {
        LdapPasswordPolicyConfiguration cfg = new LdapPasswordPolicyConfiguration(l.getPasswordPolicy());
        HashSet<Object> handlers = new HashSet<Object>();
        LOGGER.debug("Password policy authentication response handler is set to accommodate directory type: [{}]", (Object)l.getPasswordPolicy().getType());
        switch (l.getPasswordPolicy().getType()) {
            case AD: {
                handlers.add(new ActiveDirectoryAuthenticationResponseHandler(Period.ofDays(cfg.getPasswordWarningNumberOfDays())));
                Arrays.stream(ActiveDirectoryAuthenticationResponseHandler.ATTRIBUTES).forEach(a -> {
                    LOGGER.debug("Configuring authentication to retrieve password policy attribute [{}]", a);
                    attributes.put((String)a, (String)a);
                });
                break;
            }
            case FreeIPA: {
                Arrays.stream(FreeIPAAuthenticationResponseHandler.ATTRIBUTES).forEach(a -> {
                    LOGGER.debug("Configuring authentication to retrieve password policy attribute [{}]", a);
                    attributes.put((String)a, (String)a);
                });
                handlers.add(new FreeIPAAuthenticationResponseHandler(Period.ofDays(cfg.getPasswordWarningNumberOfDays()), cfg.getLoginFailures()));
                break;
            }
            case EDirectory: {
                Arrays.stream(EDirectoryAuthenticationResponseHandler.ATTRIBUTES).forEach(a -> {
                    LOGGER.debug("Configuring authentication to retrieve password policy attribute [{}]", a);
                    attributes.put((String)a, (String)a);
                });
                handlers.add(new EDirectoryAuthenticationResponseHandler(Period.ofDays(cfg.getPasswordWarningNumberOfDays())));
                break;
            }
            default: {
                handlers.add(new PasswordPolicyAuthenticationResponseHandler());
                handlers.add(new PasswordExpirationAuthenticationResponseHandler());
            }
        }
        authenticator.setAuthenticationResponseHandlers(handlers.toArray(new AuthenticationResponseHandler[handlers.size()]));
        LOGGER.debug("LDAP authentication response handlers configured are: [{}]", handlers);
        if (StringUtils.isNotBlank((CharSequence)l.getPasswordPolicy().getWarningAttributeName()) && StringUtils.isNotBlank((CharSequence)l.getPasswordPolicy().getWarningAttributeValue())) {
            OptionalWarningAccountStateHandler accountHandler = new OptionalWarningAccountStateHandler();
            accountHandler.setDisplayWarningOnMatch(l.getPasswordPolicy().isDisplayWarningOnMatch());
            accountHandler.setWarnAttributeName(l.getPasswordPolicy().getWarningAttributeName());
            accountHandler.setWarningAttributeValue(l.getPasswordPolicy().getWarningAttributeValue());
            accountHandler.setAttributesToErrorMap(l.getPasswordPolicy().getPolicyAttributes());
            cfg.setAccountStateHandler((AccountStateHandler)accountHandler);
            LOGGER.debug("Configuring an warning account state handler for LDAP authentication for warning attribute [{}] and value [{}]", (Object)l.getPasswordPolicy().getWarningAttributeName(), (Object)l.getPasswordPolicy().getWarningAttributeValue());
        } else {
            DefaultAccountStateHandler accountHandler = new DefaultAccountStateHandler();
            accountHandler.setAttributesToErrorMap(l.getPasswordPolicy().getPolicyAttributes());
            cfg.setAccountStateHandler((AccountStateHandler)accountHandler);
            LOGGER.debug("Configuring the default account state handler for LDAP authentication");
        }
        return cfg;
    }

    @Configuration(value="ldapAuthenticationEventExecutionPlanConfiguration")
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public class LdapAuthenticationEventExecutionPlanConfiguration
    implements AuthenticationEventExecutionPlanConfigurer {
        private boolean isAttributeRepositorySourceDefined() {
            return !LdapAuthenticationConfiguration.this.attributeRepositories.isEmpty();
        }

        public void configureAuthenticationExecutionPlan(AuthenticationEventExecutionPlan plan) {
            LdapAuthenticationConfiguration.this.ldapAuthenticationHandlers().forEach(handler -> {
                ChainingPrincipalResolver resolver = new ChainingPrincipalResolver();
                if (this.isAttributeRepositorySourceDefined()) {
                    LOGGER.debug("Attribute repository sources are defined and available for the principal resolution chain");
                    resolver.setChain(Arrays.asList(LdapAuthenticationConfiguration.this.personDirectoryPrincipalResolver, new EchoingPrincipalResolver()));
                } else {
                    LOGGER.debug("Attribute repository sources are not available for principal resolution so principal resolver will echo back the principal resolved during LDAP authentication directly.");
                    resolver.setChain(new PrincipalResolver[]{new EchoingPrincipalResolver()});
                }
                LOGGER.info("Ldap authentication for [{}] is to chain principal resolvers via [{}] for attribute resolution", (Object)handler.getName(), (Object)resolver);
                plan.registerAuthenticationHandlerWithPrincipalResolver(handler, (PrincipalResolver)resolver);
            });
        }
    }
}

