/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.flow;

import java.io.Serializable;
import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategy;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.web.flow.services.DefaultRegisteredServiceUserInterfaceInfo;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class OAuth20RegisteredServiceUIAction
extends AbstractAction
implements Serializable {
    private static final long serialVersionUID = 5588216693657081923L;
    private final ServicesManager servicesManager;
    private final AuthenticationServiceSelectionStrategy serviceSelectionStrategy;

    public OAuth20RegisteredServiceUIAction(ServicesManager servicesManager, AuthenticationServiceSelectionStrategy serviceSelectionStrategy) {
        this.servicesManager = servicesManager;
        this.serviceSelectionStrategy = serviceSelectionStrategy;
    }

    protected Event doExecute(RequestContext requestContext) {
        WebApplicationService service = WebUtils.getService((RequestContext)requestContext);
        if (service != null) {
            service = this.serviceSelectionStrategy.resolveServiceFrom((Service)service);
            RegisteredService registeredService = this.servicesManager.findServiceBy((Service)service);
            RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((Service)service, (RegisteredService)registeredService);
            if (registeredService instanceof OAuthRegisteredService) {
                OAuthRegisteredService oauthService = (OAuthRegisteredService)OAuthRegisteredService.class.cast(registeredService);
                WebUtils.putServiceUserInterfaceMetadata((RequestContext)requestContext, (Serializable)new DefaultRegisteredServiceUserInterfaceInfo((RegisteredService)oauthService));
            }
        }
        return this.success();
    }
}

