/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.security.SecureRandom;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.principal.DefaultPrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.oauth.OAuthProperties;
import org.apereo.cas.services.DenyAllAttributeReleasePolicy;
import org.apereo.cas.services.RegexRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.authenticator.OAuth20CasAuthenticationBuilder;
import org.apereo.cas.support.oauth.authenticator.OAuthClientAuthenticator;
import org.apereo.cas.support.oauth.authenticator.OAuthUserAuthenticator;
import org.apereo.cas.support.oauth.profile.DefaultOAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.profile.OAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.validator.OAuth20Validator;
import org.apereo.cas.support.oauth.web.OAuth20CasCallbackUrlResolver;
import org.apereo.cas.support.oauth.web.OAuth20HandlerInterceptorAdapter;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20AccessTokenEndpointController;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20AuthorizeEndpointController;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20CallbackAuthorizeEndpointController;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20UserProfileControllerController;
import org.apereo.cas.support.oauth.web.response.OAuth20CasClientRedirectActionBuilder;
import org.apereo.cas.support.oauth.web.response.OAuth20DefaultCasClientRedirectActionBuilder;
import org.apereo.cas.support.oauth.web.response.accesstoken.AccessTokenResponseGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20AccessTokenResponseGenerator;
import org.apereo.cas.support.oauth.web.views.ConsentApprovalViewResolver;
import org.apereo.cas.support.oauth.web.views.OAuth20CallbackAuthorizeViewResolver;
import org.apereo.cas.support.oauth.web.views.OAuth20ConsentApprovalViewResolver;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.ticket.accesstoken.AccessTokenFactory;
import org.apereo.cas.ticket.accesstoken.DefaultAccessTokenFactory;
import org.apereo.cas.ticket.accesstoken.OAuthAccessTokenExpirationPolicy;
import org.apereo.cas.ticket.code.DefaultOAuthCodeFactory;
import org.apereo.cas.ticket.code.OAuthCodeExpirationPolicy;
import org.apereo.cas.ticket.code.OAuthCodeFactory;
import org.apereo.cas.ticket.refreshtoken.DefaultRefreshTokenFactory;
import org.apereo.cas.ticket.refreshtoken.OAuthRefreshTokenExpirationPolicy;
import org.apereo.cas.ticket.refreshtoken.RefreshTokenFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.DefaultUniqueTicketIdGenerator;
import org.apereo.cas.web.support.CookieRetrievingCookieGenerator;
import org.pac4j.cas.client.CasClient;
import org.pac4j.cas.config.CasConfiguration;
import org.pac4j.core.client.Client;
import org.pac4j.core.config.Config;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.http.UrlResolver;
import org.pac4j.http.client.direct.DirectBasicAuthClient;
import org.pac4j.http.client.direct.DirectFormClient;
import org.pac4j.springframework.web.CallbackController;
import org.pac4j.springframework.web.SecurityInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Configuration(value="oauthConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasOAuthConfiguration
extends WebMvcConfigurerAdapter {
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private CentralAuthenticationService centralAuthenticationService;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="webApplicationServiceFactory")
    private ServiceFactory webApplicationServiceFactory;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private AuthenticationSystemSupport authenticationSystemSupport;
    @Autowired
    @Qualifier(value="ticketRegistry")
    private TicketRegistry ticketRegistry;
    @Autowired
    @Qualifier(value="ticketGrantingTicketCookieGenerator")
    private CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator;

    @ConditionalOnMissingBean(name={"accessTokenResponseGenerator"})
    @Bean
    public AccessTokenResponseGenerator accessTokenResponseGenerator() {
        return new OAuth20AccessTokenResponseGenerator();
    }

    @ConditionalOnMissingBean(name={"oauthCasClientRedirectActionBuilder"})
    @Bean
    public OAuth20CasClientRedirectActionBuilder oauthCasClientRedirectActionBuilder() {
        return new OAuth20DefaultCasClientRedirectActionBuilder();
    }

    @RefreshScope
    @Bean
    public UrlResolver casCallbackUrlResolver() {
        return new OAuth20CasCallbackUrlResolver(OAuth20Utils.casOAuthCallbackUrl(this.casProperties.getServer().getPrefix()));
    }

    @RefreshScope
    @Bean
    public Config oauthSecConfig() {
        CasConfiguration cfg = new CasConfiguration(this.casProperties.getServer().getLoginUrl());
        CasClient oauthCasClient = new CasClient(cfg);
        oauthCasClient.setRedirectActionBuilder(webContext -> this.oauthCasClientRedirectActionBuilder().build(oauthCasClient, webContext));
        oauthCasClient.setName("CasOAuthClient");
        oauthCasClient.setUrlResolver(this.casCallbackUrlResolver());
        Authenticator<UsernamePasswordCredentials> authenticator = this.oAuthClientAuthenticator();
        DirectBasicAuthClient basicAuthClient = new DirectBasicAuthClient(authenticator);
        basicAuthClient.setName("clientBasicAuth");
        DirectFormClient directFormClient = new DirectFormClient(authenticator);
        directFormClient.setName("clientForm");
        directFormClient.setUsernameParameter("client_id");
        directFormClient.setPasswordParameter("client_secret");
        DirectFormClient userFormClient = new DirectFormClient(this.oAuthUserAuthenticator());
        userFormClient.setName("userForm");
        return new Config(OAuth20Utils.casOAuthCallbackUrl(this.casProperties.getServer().getPrefix()), new Client[]{oauthCasClient, basicAuthClient, directFormClient, userFormClient});
    }

    @ConditionalOnMissingBean(name={"requiresAuthenticationAuthorizeInterceptor"})
    @Bean
    @RefreshScope
    public SecurityInterceptor requiresAuthenticationAuthorizeInterceptor() {
        return new SecurityInterceptor(this.oauthSecConfig(), "CasOAuthClient");
    }

    @ConditionalOnMissingBean(name={"consentApprovalViewResolver"})
    @Bean
    @RefreshScope
    public ConsentApprovalViewResolver consentApprovalViewResolver() {
        return new OAuth20ConsentApprovalViewResolver(this.casProperties);
    }

    @ConditionalOnMissingBean(name={"callbackAuthorizeViewResolver"})
    @Bean
    @RefreshScope
    public OAuth20CallbackAuthorizeViewResolver callbackAuthorizeViewResolver() {
        return new OAuth20CallbackAuthorizeViewResolver(){};
    }

    @ConditionalOnMissingBean(name={"requiresAuthenticationAccessTokenInterceptor"})
    @Bean
    @RefreshScope
    public SecurityInterceptor requiresAuthenticationAccessTokenInterceptor() {
        String clients = Stream.of("clientBasicAuth", "clientForm", "userForm").collect(Collectors.joining(","));
        return new SecurityInterceptor(this.oauthSecConfig(), clients);
    }

    @ConditionalOnMissingBean(name={"oauthInterceptor"})
    @Bean
    @RefreshScope
    public HandlerInterceptorAdapter oauthInterceptor() {
        return new OAuth20HandlerInterceptorAdapter((HandlerInterceptorAdapter)this.requiresAuthenticationAccessTokenInterceptor(), (HandlerInterceptorAdapter)this.requiresAuthenticationAuthorizeInterceptor());
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.oauthInterceptor()).addPathPatterns(new String[]{"/oauth2.0".concat("/").concat("*")});
    }

    @Bean
    @RefreshScope
    public OAuth20CasClientRedirectActionBuilder defaultOAuthCasClientRedirectActionBuilder() {
        return new OAuth20DefaultCasClientRedirectActionBuilder();
    }

    @ConditionalOnMissingBean(name={"oAuthClientAuthenticator"})
    @Bean
    @RefreshScope
    public Authenticator<UsernamePasswordCredentials> oAuthClientAuthenticator() {
        return new OAuthClientAuthenticator(this.oAuthValidator(), this.servicesManager);
    }

    @ConditionalOnMissingBean(name={"oAuthUserAuthenticator"})
    @Bean
    @RefreshScope
    public Authenticator<UsernamePasswordCredentials> oAuthUserAuthenticator() {
        return new OAuthUserAuthenticator(this.authenticationSystemSupport, this.servicesManager, this.webApplicationServiceFactory);
    }

    @ConditionalOnMissingBean(name={"oAuthValidator"})
    @Bean
    @RefreshScope
    public OAuth20Validator oAuthValidator() {
        return new OAuth20Validator((ServiceFactory<WebApplicationService>)this.webApplicationServiceFactory);
    }

    @ConditionalOnMissingBean(name={"oauthAccessTokenResponseGenerator"})
    @Bean
    @RefreshScope
    public AccessTokenResponseGenerator oauthAccessTokenResponseGenerator() {
        return new OAuth20AccessTokenResponseGenerator();
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"defaultAccessTokenFactory"})
    public AccessTokenFactory defaultAccessTokenFactory() {
        return new DefaultAccessTokenFactory(this.accessTokenIdGenerator(), this.accessTokenExpirationPolicy());
    }

    private ExpirationPolicy accessTokenExpirationPolicy() {
        OAuthProperties oauth = this.casProperties.getAuthn().getOauth();
        return new OAuthAccessTokenExpirationPolicy(oauth.getAccessToken().getMaxTimeToLiveInSeconds(), oauth.getAccessToken().getTimeToKillInSeconds());
    }

    private ExpirationPolicy oAuthCodeExpirationPolicy() {
        OAuthProperties oauth = this.casProperties.getAuthn().getOauth();
        return new OAuthCodeExpirationPolicy(oauth.getCode().getNumberOfUses(), oauth.getCode().getTimeToKillInSeconds());
    }

    @Bean
    @RefreshScope
    public UniqueTicketIdGenerator oAuthCodeIdGenerator() {
        return new DefaultUniqueTicketIdGenerator();
    }

    @Bean
    @RefreshScope
    public UniqueTicketIdGenerator refreshTokenIdGenerator() {
        return new DefaultUniqueTicketIdGenerator();
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"defaultOAuthCodeFactory"})
    public OAuthCodeFactory defaultOAuthCodeFactory() {
        return new DefaultOAuthCodeFactory(this.oAuthCodeIdGenerator(), this.oAuthCodeExpirationPolicy());
    }

    @ConditionalOnMissingBean(name={"profileScopeToAttributesFilter"})
    @Bean
    public OAuth20ProfileScopeToAttributesFilter profileScopeToAttributesFilter() {
        return new DefaultOAuth20ProfileScopeToAttributesFilter();
    }

    @Bean
    @ConditionalOnMissingBean(name={"callbackAuthorizeController"})
    @RefreshScope
    public OAuth20CallbackAuthorizeEndpointController callbackAuthorizeController() {
        return new OAuth20CallbackAuthorizeEndpointController(this.servicesManager, this.ticketRegistry, this.oAuthValidator(), this.defaultAccessTokenFactory(), this.oauthPrincipalFactory(), (ServiceFactory<WebApplicationService>)this.webApplicationServiceFactory, this.oauthSecConfig(), this.callbackController(), this.callbackAuthorizeViewResolver(), this.profileScopeToAttributesFilter(), this.casProperties, this.ticketGrantingTicketCookieGenerator);
    }

    @ConditionalOnMissingBean(name={"accessTokenController"})
    @Bean
    @RefreshScope
    public OAuth20AccessTokenEndpointController accessTokenController() {
        return new OAuth20AccessTokenEndpointController(this.servicesManager, this.ticketRegistry, this.oAuthValidator(), this.defaultAccessTokenFactory(), this.oauthPrincipalFactory(), (ServiceFactory<WebApplicationService>)this.webApplicationServiceFactory, this.defaultRefreshTokenFactory(), this.accessTokenResponseGenerator(), this.profileScopeToAttributesFilter(), this.casProperties, this.ticketGrantingTicketCookieGenerator, this.oauthCasAuthenticationBuilder(), this.centralAuthenticationService);
    }

    @ConditionalOnMissingBean(name={"profileController"})
    @Bean
    @RefreshScope
    public OAuth20UserProfileControllerController profileController() {
        return new OAuth20UserProfileControllerController(this.servicesManager, this.ticketRegistry, this.oAuthValidator(), this.defaultAccessTokenFactory(), this.oauthPrincipalFactory(), (ServiceFactory<WebApplicationService>)this.webApplicationServiceFactory, this.profileScopeToAttributesFilter(), this.casProperties, this.ticketGrantingTicketCookieGenerator);
    }

    @ConditionalOnMissingBean(name={"authorizeController"})
    @Bean
    @RefreshScope
    public OAuth20AuthorizeEndpointController authorizeController() {
        return new OAuth20AuthorizeEndpointController(this.servicesManager, this.ticketRegistry, this.oAuthValidator(), this.defaultAccessTokenFactory(), this.oauthPrincipalFactory(), (ServiceFactory<WebApplicationService>)this.webApplicationServiceFactory, this.defaultOAuthCodeFactory(), this.consentApprovalViewResolver(), this.profileScopeToAttributesFilter(), this.casProperties, this.ticketGrantingTicketCookieGenerator, this.oauthCasAuthenticationBuilder());
    }

    @ConditionalOnMissingBean(name={"oauthPrincipalFactory"})
    @Bean
    @RefreshScope
    public PrincipalFactory oauthPrincipalFactory() {
        return new DefaultPrincipalFactory();
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"defaultRefreshTokenFactory"})
    public RefreshTokenFactory defaultRefreshTokenFactory() {
        return new DefaultRefreshTokenFactory(this.refreshTokenIdGenerator(), this.refreshTokenExpirationPolicy());
    }

    private ExpirationPolicy refreshTokenExpirationPolicy() {
        return new OAuthRefreshTokenExpirationPolicy(this.casProperties.getAuthn().getOauth().getRefreshToken().getTimeToKillInSeconds());
    }

    @ConditionalOnMissingBean(name={"oauthCasAuthenticationBuilder"})
    @Bean
    @RefreshScope
    public OAuth20CasAuthenticationBuilder oauthCasAuthenticationBuilder() {
        return new OAuth20CasAuthenticationBuilder(this.oauthPrincipalFactory(), (ServiceFactory<WebApplicationService>)this.webApplicationServiceFactory, this.profileScopeToAttributesFilter(), this.casProperties);
    }

    @Bean
    @RefreshScope
    public CallbackController callbackController() {
        CallbackController c = new CallbackController();
        c.setConfig(this.oauthSecConfig());
        return c;
    }

    @ConditionalOnMissingBean(name={"accessTokenIdGenerator"})
    @Bean
    @RefreshScope
    public UniqueTicketIdGenerator accessTokenIdGenerator() {
        return new DefaultUniqueTicketIdGenerator();
    }

    @PostConstruct
    public void initializeServletApplicationContext() {
        String oAuthCallbackUrl = this.casProperties.getServer().getPrefix() + "/oauth2.0" + '/' + "callbackAuthorize.*";
        Service callbackService = this.webApplicationServiceFactory.createService(oAuthCallbackUrl);
        RegisteredService svc = this.servicesManager.findServiceBy(callbackService);
        if (svc == null || !svc.getServiceId().equals(oAuthCallbackUrl)) {
            RegexRegisteredService service = new RegexRegisteredService();
            service.setId(Math.abs(new SecureRandom().nextLong()));
            service.setEvaluationOrder(0);
            service.setName(service.getClass().getSimpleName());
            service.setDescription("OAuth Authentication Callback Request URL");
            service.setServiceId(oAuthCallbackUrl);
            service.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)new DenyAllAttributeReleasePolicy());
            this.servicesManager.save((RegisteredService)service);
            this.servicesManager.load();
        }
    }
}

