/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.authenticator;

import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.profile.OAuthClientProfile;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.validator.OAuth20Validator;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.profile.CommonProfile;

public class OAuthClientAuthenticator
implements Authenticator<UsernamePasswordCredentials> {
    private final OAuth20Validator validator;
    private final ServicesManager servicesManager;

    public OAuthClientAuthenticator(OAuth20Validator validator, ServicesManager servicesManager) {
        this.validator = validator;
        this.servicesManager = servicesManager;
    }

    public void validate(UsernamePasswordCredentials credentials, WebContext context) throws CredentialsException {
        String id = credentials.getUsername();
        String secret = credentials.getPassword();
        OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthService(this.servicesManager, id);
        if (!this.validator.checkServiceValid((RegisteredService)registeredService)) {
            throw new CredentialsException("Service invalid for client identifier: " + id);
        }
        if (!this.validator.checkClientSecret(registeredService, secret)) {
            throw new CredentialsException("Bad secret for client identifier: " + id);
        }
        OAuthClientProfile profile = new OAuthClientProfile();
        profile.setId(id);
        credentials.setUserProfile((CommonProfile)profile);
    }
}

