/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web;

import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class OAuth20HandlerInterceptorAdapter
extends HandlerInterceptorAdapter {
    protected final HandlerInterceptorAdapter requiresAuthenticationAccessTokenInterceptor;
    protected final HandlerInterceptorAdapter requiresAuthenticationAuthorizeInterceptor;

    public OAuth20HandlerInterceptorAdapter(HandlerInterceptorAdapter requiresAuthenticationAccessTokenInterceptor, HandlerInterceptorAdapter requiresAuthenticationAuthorizeInterceptor) {
        this.requiresAuthenticationAccessTokenInterceptor = requiresAuthenticationAccessTokenInterceptor;
        this.requiresAuthenticationAuthorizeInterceptor = requiresAuthenticationAuthorizeInterceptor;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (this.isAccessTokenRequestRequest(request.getRequestURI())) {
            return this.requiresAuthenticationAccessTokenInterceptor.preHandle(request, response, handler);
        }
        if (this.isAuthorizationRequest(request.getRequestURI())) {
            return this.requiresAuthenticationAuthorizeInterceptor.preHandle(request, response, handler);
        }
        return true;
    }

    protected boolean isAccessTokenRequestRequest(String requestPath) {
        return this.doesUriMatchPattern(requestPath, "accessToken") || this.doesUriMatchPattern(requestPath, "token");
    }

    protected boolean isAuthorizationRequest(String requestPath) {
        return this.doesUriMatchPattern(requestPath, "authorize");
    }

    protected boolean doesUriMatchPattern(String requestPath, String patternUrl) {
        Pattern pattern = Pattern.compile('/' + patternUrl + "(/)*$");
        return pattern.matcher(requestPath).find();
    }
}

