/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.endpoints;

import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.profile.OAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.validator.OAuth20Validator;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestDataHolder;
import org.apereo.cas.ticket.OAuthToken;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.TicketState;
import org.apereo.cas.ticket.accesstoken.AccessToken;
import org.apereo.cas.ticket.accesstoken.AccessTokenFactory;
import org.apereo.cas.ticket.code.OAuthCode;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.web.support.CookieRetrievingCookieGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;

@Controller
public abstract class BaseOAuth20Controller {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseOAuth20Controller.class);
    protected final CasConfigurationProperties casProperties;
    protected final OAuth20ProfileScopeToAttributesFilter scopeToAttributesFilter;
    protected final ServicesManager servicesManager;
    protected final CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator;
    protected final TicketRegistry ticketRegistry;
    protected final OAuth20Validator validator;
    protected final AccessTokenFactory accessTokenFactory;
    protected final PrincipalFactory principalFactory;
    protected final ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory;

    public BaseOAuth20Controller(ServicesManager servicesManager, TicketRegistry ticketRegistry, OAuth20Validator validator, AccessTokenFactory accessTokenFactory, PrincipalFactory principalFactory, ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory, OAuth20ProfileScopeToAttributesFilter scopeToAttributesFilter, CasConfigurationProperties casProperties, CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator) {
        this.servicesManager = servicesManager;
        this.ticketRegistry = ticketRegistry;
        this.validator = validator;
        this.accessTokenFactory = accessTokenFactory;
        this.principalFactory = principalFactory;
        this.webApplicationServiceServiceFactory = webApplicationServiceServiceFactory;
        this.casProperties = casProperties;
        this.scopeToAttributesFilter = scopeToAttributesFilter;
        this.ticketGrantingTicketCookieGenerator = ticketGrantingTicketCookieGenerator;
    }

    protected AccessToken generateAccessToken(AccessTokenRequestDataHolder responseHolder) {
        LOGGER.debug("Creating refresh token for [{}]", (Object)responseHolder.getService());
        AccessToken accessToken = this.accessTokenFactory.create(responseHolder.getService(), responseHolder.getAuthentication(), responseHolder.getTicketGrantingTicket());
        LOGGER.debug("Creating access token [{}]", (Object)accessToken);
        this.addTicketToRegistry((OAuthToken)accessToken, responseHolder.getTicketGrantingTicket());
        LOGGER.debug("Added access token [{}] to registry", (Object)accessToken);
        if (responseHolder.getToken() instanceof OAuthCode) {
            TicketState codeState = (TicketState)TicketState.class.cast(responseHolder.getToken());
            codeState.update();
            if (responseHolder.getToken().isExpired()) {
                this.ticketRegistry.deleteTicket(responseHolder.getToken().getId());
            } else {
                this.ticketRegistry.updateTicket((Ticket)responseHolder.getToken());
            }
            this.ticketRegistry.updateTicket((Ticket)responseHolder.getTicketGrantingTicket());
        }
        return accessToken;
    }

    protected void addTicketToRegistry(OAuthToken ticket, TicketGrantingTicket ticketGrantingTicket) {
        LOGGER.debug("Adding OAuth ticket [{}] to registry", (Object)ticket);
        this.ticketRegistry.addTicket((Ticket)ticket);
        if (ticketGrantingTicket != null) {
            LOGGER.debug("Updating ticket-granting ticket [{}]", (Object)ticketGrantingTicket);
            this.ticketRegistry.updateTicket((Ticket)ticketGrantingTicket);
        }
    }
}

