/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.code;

import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.ticket.code.OAuthCode;
import org.apereo.cas.ticket.code.OAuthCodeFactory;
import org.apereo.cas.ticket.code.OAuthCodeImpl;
import org.apereo.cas.util.DefaultUniqueTicketIdGenerator;

public class DefaultOAuthCodeFactory
implements OAuthCodeFactory {
    protected final UniqueTicketIdGenerator oAuthCodeIdGenerator;
    protected final ExpirationPolicy expirationPolicy;

    public DefaultOAuthCodeFactory(ExpirationPolicy expirationPolicy) {
        this((UniqueTicketIdGenerator)new DefaultUniqueTicketIdGenerator(), expirationPolicy);
    }

    public DefaultOAuthCodeFactory(UniqueTicketIdGenerator refreshTokenIdGenerator, ExpirationPolicy expirationPolicy) {
        this.oAuthCodeIdGenerator = refreshTokenIdGenerator;
        this.expirationPolicy = expirationPolicy;
    }

    @Override
    public OAuthCode create(Service service, Authentication authentication, TicketGrantingTicket ticketGrantingTicket) {
        String codeId = this.oAuthCodeIdGenerator.getNewTicketId("OC");
        return new OAuthCodeImpl(codeId, service, authentication, this.expirationPolicy, ticketGrantingTicket);
    }

    public <T extends TicketFactory> T get(Class<? extends Ticket> clazz) {
        return (T)this;
    }
}

