/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.accesstoken.ext;

import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.configuration.model.support.oauth.OAuthProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestDataHolder;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.BaseAccessTokenGrantRequestExtractor;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.ticket.OAuthToken;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.web.support.WebUtils;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessTokenAuthorizationCodeGrantRequestExtractor
extends BaseAccessTokenGrantRequestExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessTokenAuthorizationCodeGrantRequestExtractor.class);

    public AccessTokenAuthorizationCodeGrantRequestExtractor(ServicesManager servicesManager, TicketRegistry ticketRegistry, HttpServletRequest request, HttpServletResponse response, CentralAuthenticationService centralAuthenticationService, OAuthProperties oAuthProperties) {
        super(servicesManager, ticketRegistry, request, response, centralAuthenticationService, oAuthProperties);
    }

    @Override
    public AccessTokenRequestDataHolder extract() {
        ProfileManager manager = WebUtils.getPac4jProfileManager((HttpServletRequest)this.request, (HttpServletResponse)this.response);
        String grantType = this.request.getParameter("grant_type");
        LOGGER.debug("OAuth grant type is [{}]", (Object)grantType);
        Optional profile = manager.get(true);
        String clientId = ((UserProfile)profile.get()).getId();
        OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthService(this.servicesManager, clientId);
        LOGGER.debug("Located OAuth registered service [{}]", (Object)registeredService);
        boolean generateRefreshToken = this.isAllowedToGenerateRefreshToken(registeredService);
        OAuthToken token = this.getOAuthTokenFromRequest();
        if (token == null) {
            throw new InvalidTicketException(this.getOAuthParameter());
        }
        return new AccessTokenRequestDataHolder(token, generateRefreshToken, registeredService);
    }

    protected boolean isAllowedToGenerateRefreshToken(OAuthRegisteredService registeredService) {
        return registeredService != null && registeredService.isGenerateRefreshToken() != false;
    }

    protected String getOAuthParameterName() {
        return "code";
    }

    protected String getOAuthParameter() {
        return this.request.getParameter(this.getOAuthParameterName());
    }

    protected OAuthToken getOAuthTokenFromRequest() {
        OAuthToken token = (OAuthToken)this.ticketRegistry.getTicket(this.getOAuthParameter(), OAuthToken.class);
        if (token == null || token.isExpired()) {
            LOGGER.error("OAuth token indicated by parameter [{}] has expired or not found: [{}]", (Object)this.getOAuthParameter(), (Object)token);
            if (token != null) {
                this.ticketRegistry.deleteTicket(token.getId());
            }
            return null;
        }
        return token;
    }

    @Override
    public boolean supports(HttpServletRequest context) {
        String grantType = context.getParameter("grant_type");
        return OAuth20Utils.isGrantType(grantType, OAuth20GrantTypes.AUTHORIZATION_CODE);
    }
}

