/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.authenticator;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationBuilder;
import org.apereo.cas.authentication.BasicCredentialMetaData;
import org.apereo.cas.authentication.BasicIdentifiableCredential;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.CredentialMetaData;
import org.apereo.cas.authentication.DefaultAuthenticationBuilder;
import org.apereo.cas.authentication.DefaultHandlerResult;
import org.apereo.cas.authentication.HandlerResult;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.support.oauth.profile.OAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.util.CollectionUtils;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20CasAuthenticationBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20CasAuthenticationBuilder.class);
    protected final CasConfigurationProperties casProperties;
    protected final PrincipalFactory principalFactory;
    protected final ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory;
    protected final OAuth20ProfileScopeToAttributesFilter scopeToAttributesFilter;

    public OAuth20CasAuthenticationBuilder(PrincipalFactory principalFactory, ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory, OAuth20ProfileScopeToAttributesFilter scopeToAttributesFilter, CasConfigurationProperties casProperties) {
        this.principalFactory = principalFactory;
        this.webApplicationServiceServiceFactory = webApplicationServiceServiceFactory;
        this.scopeToAttributesFilter = scopeToAttributesFilter;
        this.casProperties = casProperties;
    }

    public Service buildService(OAuthRegisteredService registeredService, J2EContext context, boolean useServiceHeader) {
        String id = null;
        if (useServiceHeader) {
            id = OAuth20Utils.getServiceRequestHeaderIfAny(context.getRequest());
            LOGGER.debug("Located service based on request header is [{}]", (Object)id);
        }
        if (StringUtils.isBlank(id)) {
            id = registeredService.getClientId();
        }
        return this.webApplicationServiceServiceFactory.createService(id);
    }

    public Authentication build(UserProfile profile, OAuthRegisteredService registeredService, J2EContext context, Service service) {
        Map<String, Object> profileAttributes = OAuth20CasAuthenticationBuilder.getPrincipalAttributesFromProfile(profile);
        Principal newPrincipal = this.principalFactory.createPrincipal(profile.getId(), profileAttributes);
        LOGGER.debug("Created final principal [{}] after filtering attributes based on [{}]", (Object)newPrincipal, (Object)registeredService);
        String authenticator = profile.getClass().getCanonicalName();
        BasicCredentialMetaData metadata = new BasicCredentialMetaData((Credential)new BasicIdentifiableCredential(profile.getId()));
        DefaultHandlerResult handlerResult = new DefaultHandlerResult(authenticator, (CredentialMetaData)metadata, newPrincipal, new ArrayList());
        Set scopes = CollectionUtils.toCollection((Object)context.getRequest().getParameterValues("scope"));
        String state = (String)StringUtils.defaultIfBlank((CharSequence)context.getRequestParameter("state"), (CharSequence)"");
        String nonce = (String)StringUtils.defaultIfBlank((CharSequence)context.getRequestParameter("nonce"), (CharSequence)"");
        LOGGER.debug("OAuth [{}] is [{}], and [{}] is [{}]", new Object[]{"state", state, "nonce", nonce});
        AuthenticationBuilder bldr = DefaultAuthenticationBuilder.newInstance().addAttribute("permissions", new HashSet(profile.getPermissions())).addAttribute("roles", new HashSet(profile.getRoles())).addAttribute("scopes", (Object)scopes).addAttribute("state", (Object)state).addAttribute("nonce", (Object)nonce).addCredential((CredentialMetaData)metadata).setPrincipal(newPrincipal).setAuthenticationDate(ZonedDateTime.now()).addSuccess(profile.getClass().getCanonicalName(), (HandlerResult)handlerResult);
        this.collectionAuthenticationAttributesIfNecessary(profile, bldr);
        return bldr.build();
    }

    private static Map<String, Object> getPrincipalAttributesFromProfile(UserProfile profile) {
        HashMap<String, Object> profileAttributes = new HashMap<String, Object>(profile.getAttributes());
        profileAttributes.remove("isFromNewLogin");
        profileAttributes.remove("longTermAuthenticationRequestTokenUsed");
        profileAttributes.remove("authenticationMethod");
        profileAttributes.remove("successfulAuthenticationHandlers");
        profileAttributes.remove("authenticationDate");
        return profileAttributes;
    }

    private void collectionAuthenticationAttributesIfNecessary(UserProfile profile, AuthenticationBuilder bldr) {
        if (this.casProperties.getAuthn().getOauth().getAccessToken().isReleaseProtocolAttributes()) {
            OAuth20CasAuthenticationBuilder.addAuthenticationAttribute("authenticationMethod", bldr, profile);
            OAuth20CasAuthenticationBuilder.addAuthenticationAttribute("isFromNewLogin", bldr, profile);
            OAuth20CasAuthenticationBuilder.addAuthenticationAttribute("longTermAuthenticationRequestTokenUsed", bldr, profile);
            OAuth20CasAuthenticationBuilder.addAuthenticationAttribute("authenticationDate", bldr, profile);
            OAuth20CasAuthenticationBuilder.addAuthenticationAttribute("successfulAuthenticationHandlers", bldr, profile);
        }
    }

    private static void addAuthenticationAttribute(String name, AuthenticationBuilder bldr, UserProfile profile) {
        bldr.addAttribute(name, profile.getAttribute(name));
        LOGGER.debug("Added attribute [{}] to the authentication", (Object)name);
    }
}

