/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.authenticator;

import java.util.Map;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.UsernamePasswordCredential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.profile.OAuthUserProfile;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.profile.CommonProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthUserAuthenticator
implements Authenticator<UsernamePasswordCredentials> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuthUserAuthenticator.class);
    private final AuthenticationSystemSupport authenticationSystemSupport;
    private final ServicesManager servicesManager;
    private final ServiceFactory webApplicationServiceFactory;

    public OAuthUserAuthenticator(AuthenticationSystemSupport authenticationSystemSupport, ServicesManager servicesManager, ServiceFactory webApplicationServiceFactory) {
        this.authenticationSystemSupport = authenticationSystemSupport;
        this.servicesManager = servicesManager;
        this.webApplicationServiceFactory = webApplicationServiceFactory;
    }

    public void validate(UsernamePasswordCredentials credentials, WebContext context) throws CredentialsException {
        UsernamePasswordCredential casCredential = new UsernamePasswordCredential(credentials.getUsername(), credentials.getPassword());
        try {
            String clientId = context.getRequestParameter("client_id");
            Service service = this.webApplicationServiceFactory.createService(clientId);
            OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthService(this.servicesManager, clientId);
            RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((RegisteredService)registeredService);
            AuthenticationResult authenticationResult = this.authenticationSystemSupport.handleAndFinalizeSingleAuthenticationTransaction(null, new Credential[]{casCredential});
            Authentication authentication = authenticationResult.getAuthentication();
            Principal principal = authentication.getPrincipal();
            OAuthUserProfile profile = new OAuthUserProfile();
            String id = registeredService.getUsernameAttributeProvider().resolveUsername(principal, service, (RegisteredService)registeredService);
            LOGGER.debug("Created profile id [{}]", (Object)id);
            profile.setId(id);
            Map attributes = registeredService.getAttributeReleasePolicy().getAttributes(principal, service, (RegisteredService)registeredService);
            profile.addAttributes(attributes);
            LOGGER.debug("Authenticated user profile [{}]", (Object)profile);
            credentials.setUserProfile((CommonProfile)profile);
        }
        catch (Exception e) {
            throw new CredentialsException("Cannot login user using CAS internal authentication", (Throwable)e);
        }
    }
}

