/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.validator;

import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20Validator {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20Validator.class);
    private final ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory;

    public OAuth20Validator(ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory) {
        this.webApplicationServiceServiceFactory = webApplicationServiceServiceFactory;
    }

    public boolean checkParameterExist(HttpServletRequest request, String name) {
        String parameter = request.getParameter(name);
        if (StringUtils.isBlank((CharSequence)parameter)) {
            LOGGER.error("Missing request parameter: [{}]", (Object)name);
            return false;
        }
        LOGGER.debug("Found provided request parameter [{}]", (Object)name);
        return true;
    }

    public boolean checkServiceValid(RegisteredService registeredService) {
        if (registeredService == null) {
            LOGGER.warn("Provided registered service cannot be null and must be defined");
            return false;
        }
        WebApplicationService service = (WebApplicationService)this.webApplicationServiceServiceFactory.createService(registeredService.getServiceId());
        LOGGER.debug("Check registered service: [{}]", (Object)registeredService);
        try {
            RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((Service)service, (RegisteredService)registeredService);
            return true;
        }
        catch (UnauthorizedServiceException e) {
            LOGGER.warn("Registered service access is not allowed for [{}]", (Object)registeredService.getServiceId());
            return false;
        }
    }

    public boolean checkCallbackValid(RegisteredService registeredService, String redirectUri) {
        String registeredServiceId = registeredService.getServiceId();
        LOGGER.debug("Found: [{}] vs redirectUri: [{}]", (Object)registeredService, (Object)redirectUri);
        if (!redirectUri.matches(registeredServiceId)) {
            LOGGER.error("Unsupported [{}]: [{}] does not match what is defined for registered service: [{}]. Service is considered unauthorized. Verify the service definition in the registry is correct and does in fact match the client [{}]", new Object[]{"redirect_uri", redirectUri, registeredServiceId, redirectUri});
            return false;
        }
        return true;
    }

    public boolean checkClientSecret(OAuthRegisteredService registeredService, String clientSecret) {
        LOGGER.debug("Found: [{}] in secret check", (Object)registeredService);
        if (!StringUtils.equals((CharSequence)registeredService.getClientSecret(), (CharSequence)clientSecret)) {
            LOGGER.error("Wrong client secret for service: [{}]", (Object)registeredService);
            return false;
        }
        return true;
    }

    public static boolean checkResponseTypes(String type, OAuth20ResponseTypes ... expectedTypes) {
        LOGGER.debug("Response type: [{}]", (Object)type);
        boolean checked = Stream.of(expectedTypes).anyMatch(t -> OAuth20Utils.isResponseType(type, t));
        if (!checked) {
            LOGGER.error("Unsupported response type: [{}]", (Object)type);
        }
        return checked;
    }
}

