/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.accesstoken;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apereo.cas.ticket.TicketState;
import org.apereo.cas.ticket.support.AbstractCasExpirationPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY)
public class OAuthAccessTokenExpirationPolicy
extends AbstractCasExpirationPolicy {
    private static final long serialVersionUID = -8383186650682727360L;
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuthAccessTokenExpirationPolicy.class);
    private long maxTimeToLiveInSeconds;
    private long timeToKillInSeconds;

    public OAuthAccessTokenExpirationPolicy() {
    }

    @JsonCreator
    public OAuthAccessTokenExpirationPolicy(@JsonProperty(value="timeToLive") long maxTimeToLive, @JsonProperty(value="timeToIdle") long timeToKill) {
        this.maxTimeToLiveInSeconds = maxTimeToLive;
        this.timeToKillInSeconds = timeToKill;
    }

    public boolean isExpired(TicketState ticketState) {
        ZonedDateTime creationTime;
        ZonedDateTime expirationTime;
        ZonedDateTime currentSystemTime = ZonedDateTime.now(ZoneOffset.UTC);
        if (currentSystemTime.isAfter(expirationTime = (creationTime = ticketState.getCreationTime()).plus(this.maxTimeToLiveInSeconds, ChronoUnit.SECONDS))) {
            LOGGER.debug("Access token is expired because the time since creation is greater than maxTimeToLiveInSeconds");
            return true;
        }
        expirationTime = ticketState.getLastTimeUsed().plus(this.timeToKillInSeconds, ChronoUnit.SECONDS);
        if (currentSystemTime.isAfter(expirationTime)) {
            LOGGER.debug("Access token is expired because the time since last use is greater than timeToKillInSeconds");
            return true;
        }
        return false;
    }

    public Long getTimeToLive() {
        return this.maxTimeToLiveInSeconds;
    }

    public Long getTimeToIdle() {
        return this.timeToKillInSeconds;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        OAuthAccessTokenExpirationPolicy rhs = (OAuthAccessTokenExpirationPolicy)((Object)obj);
        return new EqualsBuilder().append(this.maxTimeToLiveInSeconds, rhs.maxTimeToLiveInSeconds).append(this.timeToKillInSeconds, rhs.timeToKillInSeconds).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.maxTimeToLiveInSeconds).append(this.timeToKillInSeconds).toHashCode();
    }
}

