/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.support.pac4j.web.flow.DelegatedClientAuthenticationAction;
import org.apereo.cas.web.flow.AbstractCasWebflowConfigurer;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.DecisionState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.ViewState;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class Pac4jWebflowConfigurer
extends AbstractCasWebflowConfigurer {
    private final Action saml2ClientLogoutAction;

    public Pac4jWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry loginFlowDefinitionRegistry, FlowDefinitionRegistry logoutFlowDefinitionRegistry, Action saml2ClientLogoutAction) {
        super(flowBuilderServices, loginFlowDefinitionRegistry);
        this.setLogoutFlowDefinitionRegistry(logoutFlowDefinitionRegistry);
        this.saml2ClientLogoutAction = saml2ClientLogoutAction;
    }

    protected void doInitialize() throws Exception {
        Flow flow = this.getLoginFlow();
        if (flow != null) {
            this.createClientActionActionState(flow);
            this.createStopWebflowViewState(flow);
            this.createSaml2ClientLogoutAction();
        }
    }

    private void createSaml2ClientLogoutAction() {
        Flow logoutFlow = this.getLogoutFlow();
        DecisionState state = (DecisionState)logoutFlow.getState("finishLogout");
        state.getEntryActionList().add(this.saml2ClientLogoutAction);
    }

    private void createClientActionActionState(Flow flow) {
        ActionState actionState = this.createActionState(flow, "clientAction", new Action[]{this.createEvaluateAction("clientAction")});
        actionState.getTransitionSet().add(this.createTransition("success", "sendTicketGrantingTicket"));
        actionState.getTransitionSet().add(this.createTransition("error", this.getStartState(flow).getId()));
        actionState.getTransitionSet().add(this.createTransition("stop", "stopWebflow"));
        this.setStartState(flow, (TransitionableState)actionState);
    }

    private void createStopWebflowViewState(Flow flow) {
        ViewState state = this.createViewState(flow, "stopWebflow", "casPac4jStopWebflow");
        state.getEntryActionList().add((Action)new AbstractAction(){

            protected Event doExecute(RequestContext requestContext) throws Exception {
                HttpServletRequest request = WebUtils.getHttpServletRequest((RequestContext)requestContext);
                HttpServletResponse response = WebUtils.getHttpServletResponse((RequestContext)requestContext);
                Optional mv = DelegatedClientAuthenticationAction.hasDelegationRequestFailed((HttpServletRequest)request, (int)response.getStatus());
                mv.ifPresent(modelAndView -> modelAndView.getModel().forEach((k, v) -> requestContext.getFlowScope().put(k, v)));
                return null;
            }
        });
    }
}

