/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow;

import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.UsernamePasswordCredential;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class InitPasswordResetAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(InitPasswordResetAction.class);
    private PasswordManagementService passwordManagementService;

    public InitPasswordResetAction(PasswordManagementService passwordManagementService) {
        this.passwordManagementService = passwordManagementService;
    }

    protected Event doExecute(RequestContext requestContext) throws Exception {
        String token = requestContext.getFlowScope().getString("token");
        if (StringUtils.isBlank((CharSequence)token)) {
            LOGGER.error("Password reset token is missing");
            return this.error();
        }
        String username = this.passwordManagementService.parseToken(token);
        if (StringUtils.isBlank((CharSequence)username)) {
            LOGGER.error("Password reset token could not be verified");
            return this.error();
        }
        UsernamePasswordCredential c = new UsernamePasswordCredential();
        c.setUsername(username);
        WebUtils.putCredential((RequestContext)requestContext, (Credential)c);
        return this.success();
    }
}

