/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.pm.PasswordManagementProperties;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class VerifySecurityQuestionsAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(VerifySecurityQuestionsAction.class);
    private final PasswordManagementService passwordManagementService;
    @Autowired
    private CasConfigurationProperties casProperties;

    public VerifySecurityQuestionsAction(PasswordManagementService passwordManagementService) {
        this.passwordManagementService = passwordManagementService;
    }

    protected Event doExecute(RequestContext requestContext) throws Exception {
        HttpServletRequest request = WebUtils.getHttpServletRequest((RequestContext)requestContext);
        String username = requestContext.getFlowScope().getString("username");
        PasswordManagementProperties pm = this.casProperties.getAuthn().getPm();
        if (!pm.getReset().isSecurityQuestionsEnabled()) {
            LOGGER.debug("Security questions are not enabled");
            return this.success();
        }
        Map<String, String> questions = this.passwordManagementService.getSecurityQuestions(username);
        AtomicInteger i = new AtomicInteger(0);
        long c = questions.values().stream().filter(v -> {
            String answer = request.getParameter("q" + i.getAndIncrement());
            return answer.equals(v);
        }).count();
        if (c == (long)questions.size()) {
            return this.success();
        }
        return this.error();
    }
}

