/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm;

import lombok.Generated;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.pm.PasswordChangeBean;
import org.apereo.cas.pm.PasswordValidationService;
import org.apereo.cas.util.RegexUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class DefaultPasswordValidationService
implements PasswordValidationService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPasswordValidationService.class);
    private final String policyPattern;

    @Override
    public boolean isValid(UsernamePasswordCredential c, PasswordChangeBean bean) {
        if (StringUtils.isEmpty((Object)bean.getPassword())) {
            LOGGER.error("Provided password is blank");
            return false;
        }
        if (!bean.getPassword().equals(bean.getConfirmedPassword())) {
            LOGGER.error("Provided password does not match the confirmed password");
            return false;
        }
        if (!RegexUtils.find((String)this.policyPattern, (String)bean.getPassword())) {
            LOGGER.error("Provided password does not match the pattern required for password policy [{}}", (Object)this.policyPattern);
            return false;
        }
        return true;
    }

    @Generated
    public DefaultPasswordValidationService(String policyPattern) {
        this.policyPattern = policyPattern;
    }
}

