/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.impl;

import java.io.Serializable;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.apereo.cas.CipherExecutor;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.configuration.model.support.pm.PasswordManagementProperties;
import org.apereo.cas.pm.BasePasswordManagementService;
import org.apereo.cas.pm.PasswordChangeBean;
import org.apereo.cas.util.scripting.ScriptingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class GroovyResourcePasswordManagementService
extends BasePasswordManagementService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GroovyResourcePasswordManagementService.class);
    private final Resource groovyResource;

    public GroovyResourcePasswordManagementService(CipherExecutor<Serializable, String> cipherExecutor, String issuer, PasswordManagementProperties passwordManagementProperties, Resource jsonResource) {
        super(passwordManagementProperties, cipherExecutor, issuer);
        this.groovyResource = jsonResource;
    }

    @Override
    public boolean changeInternal(@NonNull Credential credential, @NonNull PasswordChangeBean bean) {
        if (credential == null) {
            throw new NullPointerException("credential is marked @NonNull but is null");
        }
        if (bean == null) {
            throw new NullPointerException("bean is marked @NonNull but is null");
        }
        return (Boolean)ScriptingUtils.executeGroovyScript((Resource)this.groovyResource, (String)"change", (Object[])new Object[]{credential, bean, LOGGER}, Boolean.class, (boolean)true);
    }

    @Override
    public String findEmail(String username) {
        return (String)ScriptingUtils.executeGroovyScript((Resource)this.groovyResource, (String)"findEmail", (Object[])new Object[]{username, LOGGER}, String.class, (boolean)true);
    }

    @Override
    public String findUsername(String email) {
        return (String)ScriptingUtils.executeGroovyScript((Resource)this.groovyResource, (String)"findUsername", (Object[])new Object[]{email, LOGGER}, String.class, (boolean)true);
    }

    @Override
    public Map<String, String> getSecurityQuestions(String username) {
        return (Map)ScriptingUtils.executeGroovyScript((Resource)this.groovyResource, (String)"getSecurityQuestions", (Object[])new Object[]{username, LOGGER}, Map.class, (boolean)true);
    }

    @Generated
    public Resource getGroovyResource() {
        return this.groovyResource;
    }
}

