/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CipherExecutor;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.configuration.model.support.pm.PasswordManagementProperties;
import org.apereo.cas.pm.BasePasswordManagementService;
import org.apereo.cas.pm.PasswordChangeBean;
import org.hjson.JsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class JsonResourcePasswordManagementService
extends BasePasswordManagementService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonResourcePasswordManagementService.class);
    private static final ObjectMapper MAPPER = new ObjectMapper().findAndRegisterModules();
    private final Resource jsonResource;
    private Map<String, JsonBackedAccount> jsonBackedAccounts;

    public JsonResourcePasswordManagementService(CipherExecutor<Serializable, String> cipherExecutor, String issuer, PasswordManagementProperties passwordManagementProperties, Resource jsonResource) {
        super(passwordManagementProperties, cipherExecutor, issuer);
        this.jsonResource = jsonResource;
        this.readAccountsFromJsonResource();
    }

    private void readAccountsFromJsonResource() {
        try (InputStreamReader reader = new InputStreamReader(this.jsonResource.getInputStream(), StandardCharsets.UTF_8);){
            TypeReference<Map<String, JsonBackedAccount>> personList = new TypeReference<Map<String, JsonBackedAccount>>(){};
            this.jsonBackedAccounts = (Map)MAPPER.readValue(JsonValue.readHjson((Reader)reader).toString(), (TypeReference)personList);
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean changeInternal(@NonNull Credential credential, @NonNull PasswordChangeBean bean) {
        if (credential == null) {
            throw new NullPointerException("credential is marked @NonNull but is null");
        }
        if (bean == null) {
            throw new NullPointerException("bean is marked @NonNull but is null");
        }
        UsernamePasswordCredential c = (UsernamePasswordCredential)credential;
        if (StringUtils.isBlank((CharSequence)bean.getPassword())) {
            LOGGER.error("Password cannot be blank");
            return false;
        }
        if (!StringUtils.equals((CharSequence)bean.getPassword(), (CharSequence)bean.getConfirmedPassword())) {
            LOGGER.error("Password does not match and cannot be confirmed");
            return false;
        }
        JsonBackedAccount account = this.jsonBackedAccounts.getOrDefault(c.getId(), null);
        if (account == null) {
            LOGGER.error("User account [{}] cannot be found", (Object)c.getId());
            return false;
        }
        account.setPassword(bean.getPassword());
        this.jsonBackedAccounts.put(c.getId(), account);
        return this.writeAccountToJsonResource();
    }

    private boolean writeAccountToJsonResource() {
        MAPPER.writerWithDefaultPrettyPrinter().writeValue(this.jsonResource.getFile(), this.jsonBackedAccounts);
        this.readAccountsFromJsonResource();
        return true;
    }

    @Override
    public String findEmail(String username) {
        JsonBackedAccount account = this.jsonBackedAccounts.getOrDefault(username, null);
        return account == null ? null : account.getEmail();
    }

    @Override
    public String findUsername(String email) {
        Optional<Map.Entry> result = this.jsonBackedAccounts.entrySet().stream().filter(entry -> ((JsonBackedAccount)entry.getValue()).getEmail().equalsIgnoreCase(email)).findFirst();
        return result.map(Map.Entry::getKey).orElse(null);
    }

    @Override
    public Map<String, String> getSecurityQuestions(String username) {
        JsonBackedAccount account = this.jsonBackedAccounts.getOrDefault(username, null);
        if (account != null) {
            return account.getSecurityQuestions();
        }
        return new HashMap<String, String>(0);
    }

    private static class JsonBackedAccount {
        private String email;
        private String password;
        private Map<String, String> securityQuestions = new HashMap<String, String>();

        @Generated
        public JsonBackedAccount() {
        }

        @Generated
        public String getEmail() {
            return this.email;
        }

        @Generated
        public String getPassword() {
            return this.password;
        }

        @Generated
        public Map<String, String> getSecurityQuestions() {
            return this.securityQuestions;
        }

        @Generated
        public void setEmail(String email) {
            this.email = email;
        }

        @Generated
        public void setPassword(String password) {
            this.password = password;
        }

        @Generated
        public void setSecurityQuestions(Map<String, String> securityQuestions) {
            this.securityQuestions = securityQuestions;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JsonBackedAccount)) {
                return false;
            }
            JsonBackedAccount other = (JsonBackedAccount)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$email = this.email;
            String other$email = other.email;
            if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                return false;
            }
            String this$password = this.password;
            String other$password = other.password;
            if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                return false;
            }
            Map<String, String> this$securityQuestions = this.securityQuestions;
            Map<String, String> other$securityQuestions = other.securityQuestions;
            return !(this$securityQuestions == null ? other$securityQuestions != null : !((Object)this$securityQuestions).equals(other$securityQuestions));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof JsonBackedAccount;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $email = this.email;
            result = result * 59 + ($email == null ? 43 : $email.hashCode());
            String $password = this.password;
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            Map<String, String> $securityQuestions = this.securityQuestions;
            result = result * 59 + ($securityQuestions == null ? 43 : ((Object)$securityQuestions).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "JsonResourcePasswordManagementService.JsonBackedAccount(email=" + this.email + ", password=" + this.password + ", securityQuestions=" + this.securityQuestions + ")";
        }
    }
}

