/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.services.persondir.support;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.apereo.services.persondir.IPersonAttributeDao;
import org.apereo.services.persondir.IPersonAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.support.DataAccessUtils;

public abstract class BasePersonAttributeDao
implements IPersonAttributeDao {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private int order;
    private String id = this.getClass().getSimpleName();
    private boolean enabled = true;

    public final Map<String, List<Object>> getMultivaluedUserAttributes(Map<String, List<Object>> seed) {
        if (!this.enabled) {
            return null;
        }
        Set people = this.getPeopleWithMultivaluedAttributes(seed);
        IPersonAttributes person = (IPersonAttributes)DataAccessUtils.singleResult((Collection)people);
        if (person == null) {
            return null;
        }
        return new LinkedHashMap<String, List<Object>>(person.getAttributes());
    }

    public final Map<String, List<Object>> getMultivaluedUserAttributes(String uid) {
        if (!this.enabled) {
            return null;
        }
        IPersonAttributes person = this.getPerson(uid);
        if (person == null) {
            return null;
        }
        return new LinkedHashMap<String, List<Object>>(person.getAttributes());
    }

    public final Map<String, Object> getUserAttributes(Map<String, Object> seed) {
        if (!this.enabled) {
            return null;
        }
        Set people = this.getPeople(seed);
        IPersonAttributes person = (IPersonAttributes)DataAccessUtils.singleResult((Collection)people);
        if (person == null) {
            return null;
        }
        LinkedHashMap<String, List<Object>> multivaluedUserAttributes = new LinkedHashMap<String, List<Object>>(person.getAttributes());
        return this.flattenResults(multivaluedUserAttributes);
    }

    public final Map<String, Object> getUserAttributes(String uid) {
        if (!this.enabled) {
            return null;
        }
        Validate.notNull((Object)uid, (String)"uid may not be null.", (Object[])new Object[0]);
        Map<String, List<Object>> multivaluedUserAttributes = this.getMultivaluedUserAttributes(uid);
        return this.flattenResults(multivaluedUserAttributes);
    }

    @Deprecated
    protected Map<String, Object> flattenResults(Map<String, List<Object>> multivaluedUserAttributes) {
        if (!this.enabled) {
            return null;
        }
        if (multivaluedUserAttributes == null) {
            return null;
        }
        LinkedHashMap<String, Object> userAttributes = new LinkedHashMap<String, Object>(multivaluedUserAttributes.size());
        for (Map.Entry<String, List<Object>> attrEntry : multivaluedUserAttributes.entrySet()) {
            String attrName = attrEntry.getKey();
            List<Object> attrValues = attrEntry.getValue();
            Object value = attrValues == null || attrValues.size() == 0 ? null : attrValues.get(0);
            userAttributes.put(attrName, value);
        }
        this.logger.debug("Flattened Map='{}' into Map='{}'", multivaluedUserAttributes, userAttributes);
        return userAttributes;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int compareTo(IPersonAttributeDao o) {
        return this.order;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

