/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.services.persondir.support;

import java.sql.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apereo.services.persondir.IPersonAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasePersonImpl
implements IPersonAttributes {
    private static final long serialVersionUID = 1L;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, List<Object>> attributes;

    public BasePersonImpl(Map<String, List<Object>> attributes) {
        Validate.notNull(attributes, (String)"attributes can not be null", (Object[])new Object[0]);
        Map<String, List<Object>> immutableValuesBuilder = this.buildImmutableAttributeMap(attributes);
        this.attributes = Collections.unmodifiableMap(immutableValuesBuilder);
    }

    protected Map<String, List<Object>> buildImmutableAttributeMap(Map<String, List<Object>> attributes) {
        Map<String, List<Object>> immutableValuesBuilder = this.createImmutableAttributeMap(attributes.size());
        Pattern arrayPattern = Pattern.compile("\\{(.*)\\}");
        for (Map.Entry<String, List<Object>> attrEntry : attributes.entrySet()) {
            String key = attrEntry.getKey();
            List<Object> value = attrEntry.getValue();
            if (value != null) {
                Object result;
                if (!value.isEmpty() && Array.class.isInstance(result = value.get(0))) {
                    Matcher matcher;
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace("Column {} is classified as a SQL array", (Object)key);
                    }
                    String values = result.toString();
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace("Converting SQL array values {} using pattern {}", (Object)values, (Object)arrayPattern.pattern());
                    }
                    if ((matcher = arrayPattern.matcher(values)).matches()) {
                        String[] groups = matcher.group(1).split(",");
                        value = Arrays.asList(groups);
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace("Converted SQL array values {}", (Object)values);
                        }
                    }
                }
                value = Collections.unmodifiableList(value);
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Collecting attribute {} with value(s) {}", (Object)key, value);
            }
            immutableValuesBuilder.put(key, value);
        }
        return immutableValuesBuilder;
    }

    protected Map<String, List<Object>> createImmutableAttributeMap(int size) {
        return new LinkedHashMap<String, List<Object>>(size > 0 ? size : 1);
    }

    public Object getAttributeValue(String name) {
        List<Object> values = this.attributes.get(name);
        if (values == null || values.size() == 0) {
            return null;
        }
        return values.get(0);
    }

    public List<Object> getAttributeValues(String name) {
        List<Object> values = this.attributes.get(name);
        if (values == null) {
            return null;
        }
        return values;
    }

    public Map<String, List<Object>> getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IPersonAttributes)) {
            return false;
        }
        IPersonAttributes rhs = (IPersonAttributes)object;
        return new EqualsBuilder().append((Object)this.getName(), (Object)rhs.getName()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(1574945487, 827742191).append((Object)this.getName()).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("name", (Object)this.getName()).append("attributes", this.attributes).toString();
    }
}

