/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.services.persondir.support;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.services.persondir.IPersonAttributeDaoFilter;
import org.apereo.services.persondir.IPersonAttributes;
import org.apereo.services.persondir.support.BasePersonAttributeDao;
import org.apereo.services.persondir.support.CaseInsensitiveNamedPersonImpl;
import org.apereo.services.persondir.support.IUsernameAttributeProvider;
import org.apereo.services.persondir.support.NamedPersonImpl;
import org.apereo.services.persondir.support.SimpleUsernameAttributeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptEnginePersonAttributeDao
extends BasePersonAttributeDao {
    private static final Logger logger = LoggerFactory.getLogger(ScriptEnginePersonAttributeDao.class);
    private String scriptFile;
    private SCRIPT_TYPE scriptType;
    private String engineName;
    private boolean caseInsensitiveUsername = false;
    private final IUsernameAttributeProvider usernameAttributeProvider = new SimpleUsernameAttributeProvider();

    public String getScriptFile() {
        return this.scriptFile;
    }

    public void setScriptFile(String scriptFile) {
        this.scriptFile = scriptFile;
        this.scriptType = this.determineScriptType(scriptFile);
        if (this.scriptType != SCRIPT_TYPE.CONTENTS) {
            this.engineName = ScriptEnginePersonAttributeDao.getScriptEngineName(scriptFile);
        }
    }

    public String getEngineName() {
        return this.engineName;
    }

    protected SCRIPT_TYPE getScriptType() {
        return this.scriptType;
    }

    public void setEngineName(String engineName) {
        this.engineName = engineName;
        ScriptEngine engine = new ScriptEngineManager().getEngineByName(engineName);
        if (engine == null) {
            logger.warn("Specified engineName {} is not available in classpath.", (Object)engineName);
        }
    }

    public boolean isCaseInsensitiveUsername() {
        return this.caseInsensitiveUsername;
    }

    public void setCaseInsensitiveUsername(boolean caseInsensitiveUsername) {
        this.caseInsensitiveUsername = caseInsensitiveUsername;
    }

    public ScriptEnginePersonAttributeDao() {
    }

    public ScriptEnginePersonAttributeDao(String scriptFile) {
        this.setScriptFile(scriptFile);
        this.engineName = ScriptEnginePersonAttributeDao.getScriptEngineName(scriptFile);
    }

    public ScriptEnginePersonAttributeDao(String scriptFile, String engineName) {
        this.setScriptFile(scriptFile);
        this.setEngineName(engineName);
    }

    public IPersonAttributes getPerson(String uid, IPersonAttributeDaoFilter filter) {
        try {
            if (!this.isEnabled()) {
                return null;
            }
            Map<String, Object> attributes = this.getScriptedAttributesFromFile(uid);
            if (this.caseInsensitiveUsername) {
                return new CaseInsensitiveNamedPersonImpl(uid, ScriptEnginePersonAttributeDao.stuffAttributesIntoListValues(attributes));
            }
            return new NamedPersonImpl(uid, ScriptEnginePersonAttributeDao.stuffAttributesIntoListValues(attributes));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public Set<IPersonAttributes> getPeople(Map<String, Object> query, IPersonAttributeDaoFilter filter) {
        return this.getPeopleWithMultivaluedAttributes(ScriptEnginePersonAttributeDao.stuffAttributesIntoListValues(query), filter);
    }

    public Set<IPersonAttributes> getPeopleWithMultivaluedAttributes(Map<String, List<Object>> query, IPersonAttributeDaoFilter filter) {
        LinkedHashSet<IPersonAttributes> people = new LinkedHashSet<IPersonAttributes>();
        String username = this.usernameAttributeProvider.getUsernameFromQuery(query);
        IPersonAttributes person = this.getPerson(username, filter);
        if (person != null) {
            people.add(person);
        }
        return people;
    }

    @JsonIgnore
    public Set<String> getPossibleUserAttributeNames(IPersonAttributeDaoFilter filter) {
        return Collections.EMPTY_SET;
    }

    @JsonIgnore
    public Set<String> getAvailableQueryAttributes(IPersonAttributeDaoFilter filter) {
        return Collections.EMPTY_SET;
    }

    /*
     * Unable to fully structure code
     */
    private Map<String, Object> getScriptedAttributesFromFile(String uid) throws Exception {
        if (StringUtils.isBlank((CharSequence)this.scriptFile)) {
            ScriptEnginePersonAttributeDao.logger.warn("Script file or contents not set.");
            return new HashMap<String, Object>();
        }
        if (StringUtils.isBlank((CharSequence)this.engineName)) {
            if (this.scriptType == SCRIPT_TYPE.CONTENTS) {
                ScriptEnginePersonAttributeDao.logger.warn("Engine name not specified, not running script.");
            } else {
                ScriptEnginePersonAttributeDao.logger.warn("Unable to determine engineName for script: {}, not running script", (Object)this.scriptFile);
            }
            return new HashMap<String, Object>();
        }
        engine = new ScriptEngineManager().getEngineByName(this.engineName);
        if (engine == null) {
            ScriptEnginePersonAttributeDao.logger.warn("Script engine is not available in classpath for [{}]", (Object)this.engineName);
            return new HashMap<String, Object>();
        }
        ScriptEnginePersonAttributeDao.logger.debug("Created script engine instance for [{}]", (Object)this.engineName);
        args = new Object[]{uid, ScriptEnginePersonAttributeDao.logger};
        switch (1.$SwitchMap$org$apereo$services$persondir$support$ScriptEnginePersonAttributeDao$SCRIPT_TYPE[this.scriptType.ordinal()]) {
            case 1: {
                in = this.getClass().getClassLoader().getResourceAsStream(this.scriptFile);
                var5_5 = null;
                if (in != null && in.markSupported() && in.available() > 0) {
                    ScriptEnginePersonAttributeDao.logger.debug("Loading script [{}] from classloader as a stream", (Object)this.scriptFile);
                    engine.eval(new InputStreamReader(in));
                }
                if (in == null) break;
                if (var5_5 == null) ** GOTO lbl33
                try {
                    in.close();
                }
                catch (Throwable var6_6) {
                    var5_5.addSuppressed(var6_6);
                }
                break;
lbl33:
                // 1 sources

                in.close();
                break;
                catch (Throwable var6_7) {
                    try {
                        var5_5 = var6_7;
                        throw var6_7;
                    }
                    catch (Throwable var7_8) {
                        if (in != null) {
                            if (var5_5 != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable var8_9) {
                                    var5_5.addSuppressed(var8_9);
                                }
                            } else {
                                in.close();
                            }
                        }
                        throw var7_8;
                    }
                }
            }
            case 2: {
                theScriptFile = new File(this.scriptFile);
                ScriptEnginePersonAttributeDao.logger.debug("Loading script from [{}]", (Object)theScriptFile);
                engine.eval(new FileReader(theScriptFile));
                break;
            }
            case 3: {
                ScriptEnginePersonAttributeDao.logger.debug("Evaluating script contents [\n{}\n]", (Object)this.scriptFile);
                engine.eval(new StringReader(this.scriptFile));
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported script type: " + (Object)this.scriptType);
            }
        }
        ScriptEnginePersonAttributeDao.logger.debug("Executing script's run method, with parameters [{}]", args);
        invocable = (Invocable)engine;
        personAttributesMap = (Map)invocable.invokeFunction("run", args);
        ScriptEnginePersonAttributeDao.logger.debug("Final set of attributes determined by the script are [{}]", (Object)personAttributesMap);
        return personAttributesMap;
    }

    private SCRIPT_TYPE determineScriptType(String fileName) {
        File f = new File(fileName);
        if (f.exists() && f.isFile()) {
            return SCRIPT_TYPE.FILE;
        }
        InputStream in = ScriptEnginePersonAttributeDao.class.getClassLoader().getResourceAsStream(fileName);
        try {
            if (in != null && in.markSupported() && in.available() > 0) {
                return SCRIPT_TYPE.RESOURCE;
            }
        }
        catch (IOException e) {
            logger.warn("Error checking if stream exists: {}", (Object)e.getMessage(), (Object)e);
            return SCRIPT_TYPE.CONTENTS;
        }
        return SCRIPT_TYPE.CONTENTS;
    }

    private static Map<String, List<Object>> stuffAttributesIntoListValues(Map<String, Object> personAttributesMap) {
        HashMap<String, List<Object>> personAttributes = new HashMap<String, List<Object>>();
        for (Map.Entry<String, Object> stringObjectEntry : personAttributesMap.entrySet()) {
            Object value = stringObjectEntry.getValue();
            if (value instanceof List) {
                personAttributes.put(stringObjectEntry.getKey(), (List)value);
                continue;
            }
            personAttributes.put(stringObjectEntry.getKey(), Arrays.asList(value));
        }
        return personAttributes;
    }

    public static String getScriptEngineName(String filename) {
        String extension = FilenameUtils.getExtension((String)filename);
        if (StringUtils.isBlank((CharSequence)extension)) {
            logger.warn("Can't determine engine name based on filename without extension {}", (Object)filename);
            return null;
        }
        ScriptEngineManager manager = new ScriptEngineManager();
        List<ScriptEngineFactory> engines = manager.getEngineFactories();
        for (ScriptEngineFactory engineFactory : engines) {
            List<String> extensions = engineFactory.getExtensions();
            for (String supportedExt : extensions) {
                if (!extension.equals(supportedExt)) continue;
                return engineFactory.getNames().get(0);
            }
        }
        logger.warn("Can't determine engine name based on filename and available script engines {}", (Object)filename);
        return null;
    }

    public static enum SCRIPT_TYPE {
        RESOURCE,
        FILE,
        CONTENTS;

    }
}

