/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedHashSet;
import java.util.Set;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.ShouldBeAnnotation;
import org.assertj.core.error.ShouldBeAssignableFrom;
import org.assertj.core.error.ShouldBeFinal;
import org.assertj.core.error.ShouldBeInterface;
import org.assertj.core.error.ShouldHaveAnnotations;
import org.assertj.core.error.ShouldHaveFields;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.Sets;
import org.assertj.core.util.VisibleForTesting;

public class Classes {
    private static final Classes INSTANCE = new Classes();
    @VisibleForTesting
    Failures failures = Failures.instance();

    public static Classes instance() {
        return INSTANCE;
    }

    public void assertIsAssignableFrom(AssertionInfo info, Class<?> actual, Class<?> ... others) {
        Classes.assertNotNull(info, actual);
        if (others == null || others.length == 0) {
            throw new IllegalArgumentException("Expecting at least one Class to be specified");
        }
        LinkedHashSet<Class<?>> expected = Sets.newLinkedHashSet(others);
        LinkedHashSet missing = new LinkedHashSet();
        for (Class clazz : expected) {
            Classes.classParameterIsNotNull(clazz);
            if (actual.isAssignableFrom(clazz)) continue;
            missing.add(clazz);
        }
        if (!missing.isEmpty()) {
            throw this.failures.failure(info, ShouldBeAssignableFrom.shouldBeAssignableFrom(actual, expected, missing));
        }
    }

    public void assertIsNotInterface(AssertionInfo info, Class<?> actual) {
        Classes.assertNotNull(info, actual);
        if (actual.isInterface()) {
            throw this.failures.failure(info, ShouldBeInterface.shouldNotBeInterface(actual));
        }
    }

    public void assertIsInterface(AssertionInfo info, Class<?> actual) {
        Classes.assertNotNull(info, actual);
        if (!actual.isInterface()) {
            throw this.failures.failure(info, ShouldBeInterface.shouldBeInterface(actual));
        }
    }

    public void assertIsNotAnnotation(AssertionInfo info, Class<?> actual) {
        Classes.assertNotNull(info, actual);
        if (actual.isAnnotation()) {
            throw this.failures.failure(info, ShouldBeAnnotation.shouldNotBeAnnotation(actual));
        }
    }

    public void assertIsAnnotation(AssertionInfo info, Class<?> actual) {
        Classes.assertNotNull(info, actual);
        if (!actual.isAnnotation()) {
            throw this.failures.failure(info, ShouldBeAnnotation.shouldBeAnnotation(actual));
        }
    }

    public void assertIsFinal(AssertionInfo info, Class<?> actual) {
        Classes.assertNotNull(info, actual);
        if (!Modifier.isFinal(actual.getModifiers())) {
            throw this.failures.failure(info, ShouldBeFinal.shouldBeFinal(actual));
        }
    }

    public void assertIsNotFinal(AssertionInfo info, Class<?> actual) {
        Classes.assertNotNull(info, actual);
        if (Modifier.isFinal(actual.getModifiers())) {
            throw this.failures.failure(info, ShouldBeFinal.shouldNotBeFinal(actual));
        }
    }

    public void assertContainsAnnotations(AssertionInfo info, Class<?> actual, Class<? extends Annotation> ... annotations) {
        Classes.assertNotNull(info, actual);
        LinkedHashSet<Class<? extends Annotation>> expected = Sets.newLinkedHashSet(annotations);
        LinkedHashSet<Class<? extends Annotation>> missing = new LinkedHashSet<Class<? extends Annotation>>();
        for (Class clazz : expected) {
            Classes.classParameterIsNotNull(clazz);
            if (actual.getAnnotation(clazz) != null) continue;
            missing.add(clazz);
        }
        if (!missing.isEmpty()) {
            throw this.failures.failure(info, ShouldHaveAnnotations.shouldHaveAnnotations(actual, expected, missing));
        }
    }

    public void assertHasFields(AssertionInfo info, Class<?> actual, String ... fields) {
        Classes.assertNotNull(info, actual);
        LinkedHashSet<String> expectedFieldNames = Sets.newLinkedHashSet(fields);
        LinkedHashSet<String> missingFieldNames = Sets.newLinkedHashSet();
        Set<String> actualFieldNames = Classes.fieldsToName(actual.getFields());
        if (Classes.noMissingFields(actualFieldNames, expectedFieldNames, missingFieldNames)) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveFields.shouldHaveFields(actual, expectedFieldNames, missingFieldNames));
    }

    private static boolean noMissingFields(Set<String> actualFieldNames, Set<String> expectedFieldNames, Set<String> missingFieldNames) {
        for (String field : expectedFieldNames) {
            if (actualFieldNames.contains(field)) continue;
            missingFieldNames.add(field);
        }
        return missingFieldNames.isEmpty();
    }

    public void assertHasDeclaredFields(AssertionInfo info, Class<?> actual, String ... fields) {
        Classes.assertNotNull(info, actual);
        LinkedHashSet<String> expectedFieldNames = Sets.newLinkedHashSet(fields);
        LinkedHashSet<String> missingFieldNames = Sets.newLinkedHashSet();
        Set<String> actualFieldNames = Classes.fieldsToName(actual.getDeclaredFields());
        if (Classes.noMissingFields(actualFieldNames, expectedFieldNames, missingFieldNames)) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveFields.shouldHaveDeclaredFields(actual, expectedFieldNames, missingFieldNames));
    }

    private static Set<String> fieldsToName(Field[] fields) {
        LinkedHashSet<String> fieldsName = new LinkedHashSet<String>();
        for (Field field : fields) {
            fieldsName.add(field.getName());
        }
        return fieldsName;
    }

    private static void assertNotNull(AssertionInfo info, Class<?> actual) {
        Objects.instance().assertNotNull(info, actual);
    }

    private static void classParameterIsNotNull(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("The class to compare actual with should not be null");
        }
    }
}

