/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.time.OffsetDateTime;
import org.assertj.core.api.AbstractTemporalAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.ShouldBeAfter;
import org.assertj.core.error.ShouldBeAfterOrEqualsTo;
import org.assertj.core.error.ShouldBeBefore;
import org.assertj.core.error.ShouldBeBeforeOrEqualsTo;
import org.assertj.core.error.ShouldBeEqualIgnoringHours;
import org.assertj.core.error.ShouldBeEqualIgnoringMinutes;
import org.assertj.core.error.ShouldBeEqualIgnoringNanos;
import org.assertj.core.error.ShouldBeEqualIgnoringSeconds;
import org.assertj.core.error.ShouldBeEqualIgnoringTimezone;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.Preconditions;

public abstract class AbstractOffsetDateTimeAssert<SELF extends AbstractOffsetDateTimeAssert<SELF>>
extends AbstractTemporalAssert<SELF, OffsetDateTime> {
    public static final String NULL_OFFSET_DATE_TIME_PARAMETER_MESSAGE = "The OffsetDateTime to compare actual with should not be null";

    protected AbstractOffsetDateTimeAssert(OffsetDateTime actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public SELF isBefore(OffsetDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractOffsetDateTimeAssert.assertOffsetDateTimeParameterIsNotNull(other);
        if (!((OffsetDateTime)this.actual).isBefore(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeBefore.shouldBeBefore(this.actual, other));
        }
        return (SELF)((AbstractOffsetDateTimeAssert)this.myself);
    }

    public SELF isBefore(String offsetDateTimeAsString) {
        AbstractOffsetDateTimeAssert.assertOffsetDateTimeAsStringParameterIsNotNull(offsetDateTimeAsString);
        return this.isBefore(this.parse(offsetDateTimeAsString));
    }

    public SELF isBeforeOrEqualTo(OffsetDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractOffsetDateTimeAssert.assertOffsetDateTimeParameterIsNotNull(other);
        if (((OffsetDateTime)this.actual).isAfter(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeBeforeOrEqualsTo.shouldBeBeforeOrEqualsTo(this.actual, other));
        }
        return (SELF)((AbstractOffsetDateTimeAssert)this.myself);
    }

    public SELF isBeforeOrEqualTo(String offsetDateTimeAsString) {
        AbstractOffsetDateTimeAssert.assertOffsetDateTimeAsStringParameterIsNotNull(offsetDateTimeAsString);
        return this.isBeforeOrEqualTo(this.parse(offsetDateTimeAsString));
    }

    public SELF isAfterOrEqualTo(OffsetDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractOffsetDateTimeAssert.assertOffsetDateTimeParameterIsNotNull(other);
        if (((OffsetDateTime)this.actual).isBefore(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeAfterOrEqualsTo.shouldBeAfterOrEqualsTo(this.actual, other));
        }
        return (SELF)((AbstractOffsetDateTimeAssert)this.myself);
    }

    public SELF isAfterOrEqualTo(String offsetDateTimeAsString) {
        AbstractOffsetDateTimeAssert.assertOffsetDateTimeAsStringParameterIsNotNull(offsetDateTimeAsString);
        return this.isAfterOrEqualTo(this.parse(offsetDateTimeAsString));
    }

    public SELF isAfter(OffsetDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractOffsetDateTimeAssert.assertOffsetDateTimeParameterIsNotNull(other);
        if (!((OffsetDateTime)this.actual).isAfter(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeAfter.shouldBeAfter(this.actual, other));
        }
        return (SELF)((AbstractOffsetDateTimeAssert)this.myself);
    }

    public SELF isAfter(String offsetDateTimeAsString) {
        AbstractOffsetDateTimeAssert.assertOffsetDateTimeAsStringParameterIsNotNull(offsetDateTimeAsString);
        return this.isAfter(this.parse(offsetDateTimeAsString));
    }

    public SELF isEqualTo(String dateTimeAsString) {
        AbstractOffsetDateTimeAssert.assertOffsetDateTimeAsStringParameterIsNotNull(dateTimeAsString);
        return (SELF)((AbstractOffsetDateTimeAssert)this.isEqualTo(this.parse(dateTimeAsString)));
    }

    public SELF isNotEqualTo(String dateTimeAsString) {
        AbstractOffsetDateTimeAssert.assertOffsetDateTimeAsStringParameterIsNotNull(dateTimeAsString);
        return (SELF)((AbstractOffsetDateTimeAssert)this.isNotEqualTo(this.parse(dateTimeAsString)));
    }

    public SELF isIn(String ... dateTimesAsString) {
        this.checkIsNotNullAndNotEmpty(dateTimesAsString);
        return (SELF)((AbstractOffsetDateTimeAssert)this.isIn(AbstractOffsetDateTimeAssert.convertToOffsetDateTimeArray(dateTimesAsString)));
    }

    public SELF isNotIn(String ... dateTimesAsString) {
        this.checkIsNotNullAndNotEmpty(dateTimesAsString);
        return (SELF)((AbstractOffsetDateTimeAssert)this.isNotIn(AbstractOffsetDateTimeAssert.convertToOffsetDateTimeArray(dateTimesAsString)));
    }

    public SELF isEqualToIgnoringNanos(OffsetDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractOffsetDateTimeAssert.assertOffsetDateTimeParameterIsNotNull(other);
        if (!AbstractOffsetDateTimeAssert.areEqualIgnoringNanos((OffsetDateTime)this.actual, other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringNanos.shouldBeEqualIgnoringNanos(this.actual, other));
        }
        return (SELF)((AbstractOffsetDateTimeAssert)this.myself);
    }

    public SELF isEqualToIgnoringTimezone(OffsetDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractOffsetDateTimeAssert.assertOffsetDateTimeParameterIsNotNull(other);
        if (!AbstractOffsetDateTimeAssert.areEqualIgnoringTimezone((OffsetDateTime)this.actual, other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringTimezone.shouldBeEqualIgnoringTimezone((OffsetDateTime)this.actual, other));
        }
        return (SELF)((AbstractOffsetDateTimeAssert)this.myself);
    }

    public SELF isEqualToIgnoringSeconds(OffsetDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractOffsetDateTimeAssert.assertOffsetDateTimeParameterIsNotNull(other);
        if (!AbstractOffsetDateTimeAssert.areEqualIgnoringSeconds((OffsetDateTime)this.actual, other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringSeconds.shouldBeEqualIgnoringSeconds(this.actual, other));
        }
        return (SELF)((AbstractOffsetDateTimeAssert)this.myself);
    }

    public SELF isEqualToIgnoringMinutes(OffsetDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractOffsetDateTimeAssert.assertOffsetDateTimeParameterIsNotNull(other);
        if (!AbstractOffsetDateTimeAssert.areEqualIgnoringMinutes((OffsetDateTime)this.actual, other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringMinutes.shouldBeEqualIgnoringMinutes(this.actual, other));
        }
        return (SELF)((AbstractOffsetDateTimeAssert)this.myself);
    }

    public SELF isEqualToIgnoringHours(OffsetDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractOffsetDateTimeAssert.assertOffsetDateTimeParameterIsNotNull(other);
        if (!AbstractOffsetDateTimeAssert.haveSameYearMonthAndDayOfMonth((OffsetDateTime)this.actual, other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringHours.shouldBeEqualIgnoringHours(this.actual, other));
        }
        return (SELF)((AbstractOffsetDateTimeAssert)this.myself);
    }

    public SELF isBetween(OffsetDateTime startExclusive, OffsetDateTime endExclusive) {
        this.comparables.assertIsBetween(this.info, (Comparable)this.actual, startExclusive, endExclusive, true, true);
        return (SELF)((AbstractOffsetDateTimeAssert)this.myself);
    }

    public SELF isBetween(String startExclusive, String endExclusive) {
        return this.isBetween(this.parse(startExclusive), this.parse(endExclusive));
    }

    public SELF isStrictlyBetween(OffsetDateTime startExclusive, OffsetDateTime endExclusive) {
        this.comparables.assertIsBetween(this.info, (Comparable)this.actual, startExclusive, endExclusive, false, false);
        return (SELF)((AbstractOffsetDateTimeAssert)this.myself);
    }

    public SELF isStrictlyBetween(String startExclusive, String endExclusive) {
        return this.isStrictlyBetween(this.parse(startExclusive), this.parse(endExclusive));
    }

    @Override
    protected OffsetDateTime parse(String offsetDateTimeAsString) {
        return OffsetDateTime.parse(offsetDateTimeAsString);
    }

    private static boolean areEqualIgnoringNanos(OffsetDateTime actual, OffsetDateTime other) {
        return AbstractOffsetDateTimeAssert.areEqualIgnoringSeconds(actual, other) && actual.getSecond() == other.getSecond();
    }

    private static boolean areEqualIgnoringSeconds(OffsetDateTime actual, OffsetDateTime other) {
        return AbstractOffsetDateTimeAssert.areEqualIgnoringMinutes(actual, other) && actual.getMinute() == other.getMinute();
    }

    private static boolean areEqualIgnoringMinutes(OffsetDateTime actual, OffsetDateTime other) {
        return AbstractOffsetDateTimeAssert.haveSameYearMonthAndDayOfMonth(actual, other) && actual.getHour() == other.getHour();
    }

    private static boolean haveSameYearMonthAndDayOfMonth(OffsetDateTime actual, OffsetDateTime other) {
        return AbstractOffsetDateTimeAssert.haveSameYearAndMonth(actual, other) && actual.getDayOfMonth() == other.getDayOfMonth();
    }

    private static boolean haveSameYearAndMonth(OffsetDateTime actual, OffsetDateTime other) {
        return AbstractOffsetDateTimeAssert.haveSameYear(actual, other) && actual.getMonth() == other.getMonth();
    }

    private static boolean haveSameYear(OffsetDateTime actual, OffsetDateTime other) {
        return actual.getYear() == other.getYear();
    }

    private static boolean areEqualIgnoringTimezone(OffsetDateTime actual, OffsetDateTime other) {
        return AbstractOffsetDateTimeAssert.areEqualIgnoringNanos(actual, other) && AbstractOffsetDateTimeAssert.haveSameNano(actual, other);
    }

    private static boolean haveSameNano(OffsetDateTime actual, OffsetDateTime other) {
        return actual.getNano() == other.getNano();
    }

    private static Object[] convertToOffsetDateTimeArray(String ... dateTimesAsString) {
        Object[] dates = new OffsetDateTime[dateTimesAsString.length];
        for (int i = 0; i < dateTimesAsString.length; ++i) {
            dates[i] = OffsetDateTime.parse(dateTimesAsString[i]);
        }
        return dates;
    }

    private void checkIsNotNullAndNotEmpty(Object[] values) {
        Preconditions.checkArgument(values != null, "The given OffsetDateTime array should not be null", new Object[0]);
        Preconditions.checkArgument(values.length > 0, "The given OffsetDateTime array should not be empty", new Object[0]);
    }

    private static void assertOffsetDateTimeAsStringParameterIsNotNull(String offsetDateTimeAsString) {
        Preconditions.checkArgument(offsetDateTimeAsString != null, "The String representing the OffsetDateTime to compare actual with should not be null", new Object[0]);
    }

    private static void assertOffsetDateTimeParameterIsNotNull(OffsetDateTime other) {
        Preconditions.checkArgument(other != null, NULL_OFFSET_DATE_TIME_PARAMETER_MESSAGE, new Object[0]);
    }
}

