/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.digest._apacheCommonsCodec.Base64;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.mapper.MultipartFormData;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.type.FileValueType;
import org.camunda.bpm.engine.variable.type.PrimitiveValueType;
import org.camunda.bpm.engine.variable.type.SerializableValueType;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.type.ValueTypeResolver;
import org.camunda.bpm.engine.variable.value.FileValue;
import org.camunda.bpm.engine.variable.value.SerializableValue;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class VariableValueDto {
    protected String type;
    protected Object value;
    protected Map<String, Object> valueInfo;

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Map<String, Object> getValueInfo() {
        return this.valueInfo;
    }

    public void setValueInfo(Map<String, Object> valueInfo) {
        this.valueInfo = valueInfo;
    }

    public TypedValue toTypedValue(ProcessEngine processEngine, ObjectMapper objectMapper) {
        ValueTypeResolver valueTypeResolver = processEngine.getProcessEngineConfiguration().getValueTypeResolver();
        if (this.type == null) {
            if (this.valueInfo != null && this.valueInfo.get("transient") instanceof Boolean) {
                return Variables.untypedValue((Object)this.value, (boolean)((Boolean)this.valueInfo.get("transient")));
            }
            return Variables.untypedValue((Object)this.value);
        }
        ValueType valueType = valueTypeResolver.typeForName(VariableValueDto.fromRestApiTypeName(this.type));
        if (valueType == null) {
            throw new RestException(Response.Status.BAD_REQUEST, String.format("Unsupported value type '%s'", this.type));
        }
        if (valueType instanceof PrimitiveValueType) {
            PrimitiveValueType primitiveValueType = (PrimitiveValueType)valueType;
            Class javaType = primitiveValueType.getJavaType();
            Object mappedValue = null;
            try {
                if (this.value != null) {
                    mappedValue = javaType.isAssignableFrom(this.value.getClass()) ? this.value : objectMapper.readValue("\"" + this.value + "\"", javaType);
                }
                return valueType.createValue(mappedValue, this.valueInfo);
            }
            catch (Exception e) {
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, e, String.format("Cannot convert value '%s' of type '%s' to java type %s", this.value, this.type, javaType.getName()));
            }
        }
        if (valueType instanceof SerializableValueType) {
            if (this.value != null && !(this.value instanceof String)) {
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Must provide 'null' or String value for value of SerializableValue type '" + this.type + "'.");
            }
            return ((SerializableValueType)valueType).createValueFromSerialized((String)this.value, this.valueInfo);
        }
        if (valueType instanceof FileValueType) {
            if (this.value instanceof String) {
                this.value = Base64.decodeBase64((String)((String)this.value));
            }
            return valueType.createValue(this.value, this.valueInfo);
        }
        return valueType.createValue(this.value, this.valueInfo);
    }

    protected FileValue fileValueWithDecodedString(FileValue fileValue, String value) {
        return (FileValue)Variables.fileValue((String)fileValue.getFilename()).file(Base64.decodeBase64((String)value)).mimeType(fileValue.getMimeType()).encoding(fileValue.getEncoding()).create();
    }

    public static VariableMap toMap(Map<String, VariableValueDto> variables, ProcessEngine processEngine, ObjectMapper objectMapper) {
        if (variables == null) {
            return null;
        }
        VariableMap result = Variables.createVariables();
        for (Map.Entry<String, VariableValueDto> variableEntry : variables.entrySet()) {
            result.put((Object)variableEntry.getKey(), (Object)variableEntry.getValue().toTypedValue(processEngine, objectMapper));
        }
        return result;
    }

    public static VariableValueDto fromTypedValue(TypedValue typedValue) {
        VariableValueDto dto = new VariableValueDto();
        VariableValueDto.fromTypedValue(dto, typedValue);
        return dto;
    }

    public static VariableValueDto fromTypedValue(TypedValue typedValue, boolean preferSerializedValue) {
        VariableValueDto dto = new VariableValueDto();
        VariableValueDto.fromTypedValue(dto, typedValue, preferSerializedValue);
        return dto;
    }

    public static void fromTypedValue(VariableValueDto dto, TypedValue typedValue) {
        VariableValueDto.fromTypedValue(dto, typedValue, false);
    }

    public static void fromTypedValue(VariableValueDto dto, TypedValue typedValue, boolean preferSerializedValue) {
        ValueType type = typedValue.getType();
        if (type != null) {
            String typeName = type.getName();
            dto.setType(VariableValueDto.toRestApiTypeName(typeName));
            dto.setValueInfo(type.getValueInfo(typedValue));
        }
        if (typedValue instanceof SerializableValue) {
            SerializableValue serializableValue = (SerializableValue)typedValue;
            if (serializableValue.isDeserialized() && !preferSerializedValue) {
                dto.setValue(serializableValue.getValue());
            } else {
                dto.setValue(serializableValue.getValueSerialized());
            }
        } else if (!(typedValue instanceof FileValue)) {
            dto.setValue(typedValue.getValue());
        }
    }

    public static String toRestApiTypeName(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public static String fromRestApiTypeName(String name) {
        return name.substring(0, 1).toLowerCase() + name.substring(1);
    }

    public static Map<String, VariableValueDto> fromVariableMap(VariableMap variables) {
        HashMap<String, VariableValueDto> result = new HashMap<String, VariableValueDto>();
        for (String name : variables.keySet()) {
            result.put(name, VariableValueDto.fromTypedValue(variables.getValueTyped(name)));
        }
        return result;
    }

    public static VariableValueDto fromFormPart(String type, MultipartFormData.FormPart binaryDataFormPart) {
        VariableValueDto dto = new VariableValueDto();
        dto.type = type;
        dto.value = binaryDataFormPart.getBinaryContent();
        if (ValueType.FILE.getName().equals(VariableValueDto.fromRestApiTypeName(type))) {
            String transientString;
            boolean isTransient;
            String contentType = binaryDataFormPart.getContentType();
            if (contentType == null) {
                contentType = "application/octet-stream";
            }
            dto.valueInfo = new HashMap<String, Object>();
            dto.valueInfo.put("filename", binaryDataFormPart.getFileName());
            MimeType mimeType = null;
            try {
                mimeType = new MimeType(contentType);
            }
            catch (MimeTypeParseException e) {
                throw new RestException(Response.Status.BAD_REQUEST, "Invalid mime type given");
            }
            dto.valueInfo.put("mimeType", mimeType.getBaseType());
            String encoding = mimeType.getParameter("encoding");
            if (encoding != null) {
                dto.valueInfo.put("encoding", encoding);
            }
            if (isTransient = Boolean.parseBoolean(transientString = mimeType.getParameter("transient"))) {
                dto.valueInfo.put("transient", isTransient);
            }
        }
        return dto;
    }
}

