/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.CleanableHistoricProcessInstanceReport;
import org.camunda.bpm.engine.history.CleanableHistoricProcessInstanceReportResult;
import org.camunda.bpm.engine.history.HistoricActivityStatistics;
import org.camunda.bpm.engine.history.HistoricActivityStatisticsQuery;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.converter.DateConverter;
import org.camunda.bpm.engine.rest.dto.history.CleanableHistoricProcessInstanceReportDto;
import org.camunda.bpm.engine.rest.dto.history.CleanableHistoricProcessInstanceReportResultDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricActivityStatisticsDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.history.HistoricProcessDefinitionRestService;
import org.camunda.bpm.engine.rest.impl.AbstractRestProcessEngineAware;

public class HistoricProcessDefinitionRestServiceImpl
extends AbstractRestProcessEngineAware
implements HistoricProcessDefinitionRestService {
    public static final String QUERY_PARAM_STARTED_AFTER = "startedAfter";
    public static final String QUERY_PARAM_STARTED_BEFORE = "startedBefore";
    public static final String QUERY_PARAM_FINISHED_AFTER = "finishedAfter";
    public static final String QUERY_PARAM_FINISHED_BEFORE = "finishedBefore";

    public HistoricProcessDefinitionRestServiceImpl(ObjectMapper objectMapper, ProcessEngine processEngine) {
        super(processEngine.getName(), objectMapper);
    }

    @Override
    public List<HistoricActivityStatisticsDto> getHistoricActivityStatistics(UriInfo uriInfo, String processDefinitionId, Boolean includeCanceled, Boolean includeFinished, Boolean includeCompleteScope, String sortBy, String sortOrder) {
        HistoryService historyService = this.processEngine.getHistoryService();
        HistoricActivityStatisticsQuery query = historyService.createHistoricActivityStatisticsQuery(processDefinitionId);
        if (includeCanceled != null && includeCanceled.booleanValue()) {
            query.includeCanceled();
        }
        if (includeFinished != null && includeFinished.booleanValue()) {
            query.includeFinished();
        }
        if (includeCompleteScope != null && includeCompleteScope.booleanValue()) {
            query.includeCompleteScope();
        }
        MultivaluedMap queryParameters = uriInfo.getQueryParameters();
        DateConverter dateConverter = new DateConverter();
        dateConverter.setObjectMapper(this.objectMapper);
        if (queryParameters.getFirst((Object)QUERY_PARAM_STARTED_AFTER) != null) {
            Date startedAfter = dateConverter.convertQueryParameterToType((String)queryParameters.getFirst((Object)QUERY_PARAM_STARTED_AFTER));
            query.startedAfter(startedAfter);
        }
        if (queryParameters.getFirst((Object)QUERY_PARAM_STARTED_BEFORE) != null) {
            Date startedBefore = dateConverter.convertQueryParameterToType((String)queryParameters.getFirst((Object)QUERY_PARAM_STARTED_BEFORE));
            query.startedBefore(startedBefore);
        }
        if (queryParameters.getFirst((Object)QUERY_PARAM_FINISHED_AFTER) != null) {
            Date finishedAfter = dateConverter.convertQueryParameterToType((String)queryParameters.getFirst((Object)QUERY_PARAM_FINISHED_AFTER));
            query.finishedAfter(finishedAfter);
        }
        if (queryParameters.getFirst((Object)QUERY_PARAM_FINISHED_BEFORE) != null) {
            Date finishedBefore = dateConverter.convertQueryParameterToType((String)queryParameters.getFirst((Object)QUERY_PARAM_FINISHED_BEFORE));
            query.finishedBefore(finishedBefore);
        }
        this.setSortOptions(query, sortOrder, sortBy);
        ArrayList<HistoricActivityStatisticsDto> result = new ArrayList<HistoricActivityStatisticsDto>();
        List statistics = query.list();
        for (HistoricActivityStatistics currentStatistics : statistics) {
            result.add(HistoricActivityStatisticsDto.fromHistoricActivityStatistics(currentStatistics));
        }
        return result;
    }

    private void setSortOptions(HistoricActivityStatisticsQuery query, String sortOrder, String sortBy) {
        boolean sortOptionsValid;
        boolean bl = sortOptionsValid = sortBy != null && sortOrder != null || sortBy == null && sortOrder == null;
        if (!sortOptionsValid) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Only a single sorting parameter specified. sortBy and sortOrder required");
        }
        if (sortBy != null) {
            if (sortBy.equals("activityId")) {
                query.orderByActivityId();
            } else {
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "sortBy parameter has invalid value: " + sortBy);
            }
        }
        if (sortOrder != null) {
            if (sortOrder.equals("asc")) {
                query.asc();
            } else if (sortOrder.equals("desc")) {
                query.desc();
            } else {
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "sortOrder parameter has invalid value: " + sortOrder);
            }
        }
    }

    @Override
    public List<CleanableHistoricProcessInstanceReportResultDto> getCleanableHistoricProcessInstanceReport(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        CleanableHistoricProcessInstanceReportDto queryDto = new CleanableHistoricProcessInstanceReportDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        CleanableHistoricProcessInstanceReport query = (CleanableHistoricProcessInstanceReport)queryDto.toQuery(this.processEngine);
        List<CleanableHistoricProcessInstanceReportResult> reportResult = firstResult != null || maxResults != null ? this.executePaginatedQuery(query, firstResult, maxResults) : query.list();
        return CleanableHistoricProcessInstanceReportResultDto.convert(reportResult);
    }

    private List<CleanableHistoricProcessInstanceReportResult> executePaginatedQuery(CleanableHistoricProcessInstanceReport query, Integer firstResult, Integer maxResults) {
        if (firstResult == null) {
            firstResult = 0;
        }
        if (maxResults == null) {
            maxResults = Integer.MAX_VALUE;
        }
        return query.listPage(firstResult.intValue(), maxResults.intValue());
    }

    @Override
    public CountResultDto getCleanableHistoricProcessInstanceReportCount(UriInfo uriInfo) {
        CleanableHistoricProcessInstanceReportDto queryDto = new CleanableHistoricProcessInstanceReportDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        queryDto.setObjectMapper(this.objectMapper);
        CleanableHistoricProcessInstanceReport query = (CleanableHistoricProcessInstanceReport)queryDto.toQuery(this.processEngine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }
}

