/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.impl.AbstractVariableQueryImpl;
import org.camunda.bpm.engine.impl.HistoricProcessInstanceQueryProperty;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.util.CompareUtil;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class HistoricProcessInstanceQueryImpl
extends AbstractVariableQueryImpl<HistoricProcessInstanceQuery, HistoricProcessInstance>
implements HistoricProcessInstanceQuery {
    private static final long serialVersionUID = 1L;
    protected String processInstanceId;
    protected String processDefinitionId;
    protected String processDefinitionName;
    protected String processDefinitionNameLike;
    protected String businessKey;
    protected String businessKeyLike;
    protected boolean finished = false;
    protected boolean unfinished = false;
    protected boolean withIncidents = false;
    protected boolean withRootIncidents = false;
    protected String incidentType;
    protected String incidentStatus;
    protected String incidentMessage;
    protected String incidentMessageLike;
    protected String startedBy;
    protected boolean isRootProcessInstances;
    protected String superProcessInstanceId;
    protected String subProcessInstanceId;
    protected String superCaseInstanceId;
    protected String subCaseInstanceId;
    protected List<String> processKeyNotIn;
    protected Date startedBefore;
    protected Date startedAfter;
    protected Date finishedBefore;
    protected Date finishedAfter;
    protected Date executedActivityAfter;
    protected Date executedActivityBefore;
    protected Date executedJobAfter;
    protected Date executedJobBefore;
    protected String processDefinitionKey;
    protected Set<String> processInstanceIds;
    protected String[] tenantIds;
    protected boolean isTenantIdSet;
    protected String[] executedActivityIds;
    protected String[] activeActivityIds;
    protected String state;
    protected String caseInstanceId;
    protected Date startDateBy;
    protected Date startDateOn;
    protected Date finishDateBy;
    protected Date finishDateOn;
    protected Date startDateOnBegin;
    protected Date startDateOnEnd;
    protected Date finishDateOnBegin;
    protected Date finishDateOnEnd;

    public HistoricProcessInstanceQueryImpl() {
    }

    public HistoricProcessInstanceQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public HistoricProcessInstanceQueryImpl processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery processInstanceIds(Set<String> processInstanceIds) {
        EnsureUtil.ensureNotEmpty("Set of process instance ids", processInstanceIds);
        this.processInstanceIds = processInstanceIds;
        return this;
    }

    @Override
    public HistoricProcessInstanceQueryImpl processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery processDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery processDefinitionName(String processDefinitionName) {
        this.processDefinitionName = processDefinitionName;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery processDefinitionNameLike(String nameLike) {
        this.processDefinitionNameLike = nameLike;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery processInstanceBusinessKey(String businessKey) {
        this.businessKey = businessKey;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery processInstanceBusinessKeyLike(String businessKeyLike) {
        this.businessKeyLike = businessKeyLike;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery finished() {
        this.finished = true;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery unfinished() {
        this.unfinished = true;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery withIncidents() {
        this.withIncidents = true;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery withRootIncidents() {
        this.withRootIncidents = true;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery incidentType(String incidentType) {
        EnsureUtil.ensureNotNull("incident type", (Object)incidentType);
        this.incidentType = incidentType;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery incidentStatus(String status) {
        this.incidentStatus = status;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery incidentMessage(String incidentMessage) {
        EnsureUtil.ensureNotNull("incidentMessage", (Object)incidentMessage);
        this.incidentMessage = incidentMessage;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery incidentMessageLike(String incidentMessageLike) {
        EnsureUtil.ensureNotNull("incidentMessageLike", (Object)incidentMessageLike);
        this.incidentMessageLike = incidentMessageLike;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery startedBy(String userId) {
        this.startedBy = userId;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery processDefinitionKeyNotIn(List<String> processDefinitionKeys) {
        EnsureUtil.ensureNotContainsNull("processDefinitionKeys", processDefinitionKeys);
        EnsureUtil.ensureNotContainsEmptyString("processDefinitionKeys", processDefinitionKeys);
        this.processKeyNotIn = processDefinitionKeys;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery startedAfter(Date date) {
        this.startedAfter = date;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery startedBefore(Date date) {
        this.startedBefore = date;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery finishedAfter(Date date) {
        this.finishedAfter = date;
        this.finished = true;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery finishedBefore(Date date) {
        this.finishedBefore = date;
        this.finished = true;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery rootProcessInstances() {
        if (this.superProcessInstanceId != null) {
            throw new BadUserRequestException("Invalid query usage: cannot set both rootProcessInstances and superProcessInstanceId");
        }
        if (this.superCaseInstanceId != null) {
            throw new BadUserRequestException("Invalid query usage: cannot set both rootProcessInstances and superCaseInstanceId");
        }
        this.isRootProcessInstances = true;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery superProcessInstanceId(String superProcessInstanceId) {
        if (this.isRootProcessInstances) {
            throw new BadUserRequestException("Invalid query usage: cannot set both rootProcessInstances and superProcessInstanceId");
        }
        this.superProcessInstanceId = superProcessInstanceId;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery subProcessInstanceId(String subProcessInstanceId) {
        this.subProcessInstanceId = subProcessInstanceId;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery superCaseInstanceId(String superCaseInstanceId) {
        if (this.isRootProcessInstances) {
            throw new BadUserRequestException("Invalid query usage: cannot set both rootProcessInstances and superCaseInstanceId");
        }
        this.superCaseInstanceId = superCaseInstanceId;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery subCaseInstanceId(String subCaseInstanceId) {
        this.subCaseInstanceId = subCaseInstanceId;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery caseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery tenantIdIn(String ... tenantIds) {
        EnsureUtil.ensureNotNull("tenantIds", tenantIds);
        this.tenantIds = tenantIds;
        this.isTenantIdSet = true;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery withoutTenantId() {
        this.tenantIds = null;
        this.isTenantIdSet = true;
        return this;
    }

    @Override
    protected boolean hasExcludingConditions() {
        return super.hasExcludingConditions() || this.finished && this.unfinished || CompareUtil.areNotInAscendingOrder((Comparable[])new Date[]{this.startedAfter, this.startedBefore}) || CompareUtil.areNotInAscendingOrder((Comparable[])new Date[]{this.finishedAfter, this.finishedBefore}) || CompareUtil.elementIsContainedInList(this.processDefinitionKey, this.processKeyNotIn) || CompareUtil.elementIsNotContainedInList(this.processInstanceId, this.processInstanceIds);
    }

    @Override
    public HistoricProcessInstanceQuery orderByProcessInstanceBusinessKey() {
        return (HistoricProcessInstanceQuery)this.orderBy(HistoricProcessInstanceQueryProperty.BUSINESS_KEY);
    }

    @Override
    public HistoricProcessInstanceQuery orderByProcessInstanceDuration() {
        return (HistoricProcessInstanceQuery)this.orderBy(HistoricProcessInstanceQueryProperty.DURATION);
    }

    @Override
    public HistoricProcessInstanceQuery orderByProcessInstanceStartTime() {
        return (HistoricProcessInstanceQuery)this.orderBy(HistoricProcessInstanceQueryProperty.START_TIME);
    }

    @Override
    public HistoricProcessInstanceQuery orderByProcessInstanceEndTime() {
        return (HistoricProcessInstanceQuery)this.orderBy(HistoricProcessInstanceQueryProperty.END_TIME);
    }

    @Override
    public HistoricProcessInstanceQuery orderByProcessDefinitionId() {
        return (HistoricProcessInstanceQuery)this.orderBy(HistoricProcessInstanceQueryProperty.PROCESS_DEFINITION_ID);
    }

    @Override
    public HistoricProcessInstanceQuery orderByProcessDefinitionKey() {
        return (HistoricProcessInstanceQuery)this.orderBy(HistoricProcessInstanceQueryProperty.PROCESS_DEFINITION_KEY);
    }

    @Override
    public HistoricProcessInstanceQuery orderByProcessDefinitionName() {
        return (HistoricProcessInstanceQuery)this.orderBy(HistoricProcessInstanceQueryProperty.PROCESS_DEFINITION_NAME);
    }

    @Override
    public HistoricProcessInstanceQuery orderByProcessDefinitionVersion() {
        return (HistoricProcessInstanceQuery)this.orderBy(HistoricProcessInstanceQueryProperty.PROCESS_DEFINITION_VERSION);
    }

    @Override
    public HistoricProcessInstanceQuery orderByProcessInstanceId() {
        return (HistoricProcessInstanceQuery)this.orderBy(HistoricProcessInstanceQueryProperty.PROCESS_INSTANCE_ID_);
    }

    @Override
    public HistoricProcessInstanceQuery orderByTenantId() {
        return (HistoricProcessInstanceQuery)this.orderBy(HistoricProcessInstanceQueryProperty.TENANT_ID);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        this.ensureVariablesInitialized();
        return commandContext.getHistoricProcessInstanceManager().findHistoricProcessInstanceCountByQueryCriteria(this);
    }

    @Override
    public List<HistoricProcessInstance> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        this.ensureVariablesInitialized();
        return commandContext.getHistoricProcessInstanceManager().findHistoricProcessInstancesByQueryCriteria(this, page);
    }

    @Override
    public List<String> executeIdsList(CommandContext commandContext) {
        this.checkQueryOk();
        this.ensureVariablesInitialized();
        return commandContext.getHistoricProcessInstanceManager().findHistoricProcessInstanceIds(this);
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public String getBusinessKeyLike() {
        return this.businessKeyLike;
    }

    public boolean isOpen() {
        return this.unfinished;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public String getProcessDefinitionIdLike() {
        return this.processDefinitionKey + ":%:%";
    }

    public String getProcessDefinitionName() {
        return this.processDefinitionName;
    }

    public String getProcessDefinitionNameLike() {
        return this.processDefinitionNameLike;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public Set<String> getProcessInstanceIds() {
        return this.processInstanceIds;
    }

    public String getStartedBy() {
        return this.startedBy;
    }

    public String getSuperProcessInstanceId() {
        return this.superProcessInstanceId;
    }

    public void setSuperProcessInstanceId(String superProcessInstanceId) {
        this.superProcessInstanceId = superProcessInstanceId;
    }

    public List<String> getProcessKeyNotIn() {
        return this.processKeyNotIn;
    }

    public Date getStartedAfter() {
        return this.startedAfter;
    }

    public Date getStartedBefore() {
        return this.startedBefore;
    }

    public Date getFinishedAfter() {
        return this.finishedAfter;
    }

    public Date getFinishedBefore() {
        return this.finishedBefore;
    }

    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public String getIncidentType() {
        return this.incidentType;
    }

    public String getIncidentMessage() {
        return this.incidentMessage;
    }

    public String getIncidentMessageLike() {
        return this.incidentMessageLike;
    }

    public boolean isWithRootIncidents() {
        return this.withRootIncidents;
    }

    @Override
    @Deprecated
    public HistoricProcessInstanceQuery startDateBy(Date date) {
        this.startDateBy = this.calculateMidnight(date);
        return this;
    }

    @Override
    @Deprecated
    public HistoricProcessInstanceQuery startDateOn(Date date) {
        this.startDateOn = date;
        this.startDateOnBegin = this.calculateMidnight(date);
        this.startDateOnEnd = this.calculateBeforeMidnight(date);
        return this;
    }

    @Override
    @Deprecated
    public HistoricProcessInstanceQuery finishDateBy(Date date) {
        this.finishDateBy = this.calculateBeforeMidnight(date);
        return this;
    }

    @Override
    @Deprecated
    public HistoricProcessInstanceQuery finishDateOn(Date date) {
        this.finishDateOn = date;
        this.finishDateOnBegin = this.calculateMidnight(date);
        this.finishDateOnEnd = this.calculateBeforeMidnight(date);
        return this;
    }

    @Deprecated
    private Date calculateBeforeMidnight(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, 1);
        cal.add(13, -1);
        return cal.getTime();
    }

    @Deprecated
    private Date calculateMidnight(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(14, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(10, 0);
        return cal.getTime();
    }

    public boolean isRootProcessInstances() {
        return this.isRootProcessInstances;
    }

    public String getSubProcessInstanceId() {
        return this.subProcessInstanceId;
    }

    public String getSuperCaseInstanceId() {
        return this.superCaseInstanceId;
    }

    public String getSubCaseInstanceId() {
        return this.subCaseInstanceId;
    }

    @Override
    public HistoricProcessInstanceQuery executedActivityAfter(Date date) {
        this.executedActivityAfter = date;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery executedActivityBefore(Date date) {
        this.executedActivityBefore = date;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery executedJobAfter(Date date) {
        this.executedJobAfter = date;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery executedJobBefore(Date date) {
        this.executedJobBefore = date;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery executedActivityIdIn(String ... ids) {
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "activity ids", (Object[])ids);
        EnsureUtil.ensureNotContainsNull(BadUserRequestException.class, "activity ids", Arrays.asList(ids));
        this.executedActivityIds = ids;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery activeActivityIdIn(String ... ids) {
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "activity ids", (Object[])ids);
        EnsureUtil.ensureNotContainsNull(BadUserRequestException.class, "activity ids", Arrays.asList(ids));
        this.activeActivityIds = ids;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery active() {
        EnsureUtil.ensureNull(BadUserRequestException.class, "Already querying for historic process instance with another state", this.state, this.state);
        this.state = "ACTIVE";
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery suspended() {
        EnsureUtil.ensureNull(BadUserRequestException.class, "Already querying for historic process instance with another state", this.state, this.state);
        this.state = "SUSPENDED";
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery completed() {
        EnsureUtil.ensureNull(BadUserRequestException.class, "Already querying for historic process instance with another state", this.state, this.state);
        this.state = "COMPLETED";
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery externallyTerminated() {
        EnsureUtil.ensureNull(BadUserRequestException.class, "Already querying for historic process instance with another state", this.state, this.state);
        this.state = "EXTERNALLY_TERMINATED";
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery internallyTerminated() {
        EnsureUtil.ensureNull(BadUserRequestException.class, "Already querying for historic process instance with another state", this.state, this.state);
        this.state = "INTERNALLY_TERMINATED";
        return this;
    }
}

