/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.batch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.RestartProcessInstanceBuilderImpl;
import org.camunda.bpm.engine.impl.RestartProcessInstancesBatchConfiguration;
import org.camunda.bpm.engine.impl.batch.BatchEntity;
import org.camunda.bpm.engine.impl.batch.BatchJobHandler;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmd.AbstractProcessInstanceModificationCommand;
import org.camunda.bpm.engine.impl.cmd.AbstractRestartProcessInstanceCmd;
import org.camunda.bpm.engine.impl.cmd.CommandLogger;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class RestartProcessInstancesBatchCmd
extends AbstractRestartProcessInstanceCmd<Batch> {
    private final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;

    public RestartProcessInstancesBatchCmd(CommandExecutor commandExecutor, RestartProcessInstanceBuilderImpl builder) {
        super(commandExecutor, builder);
    }

    @Override
    public Batch execute(CommandContext commandContext) {
        List<AbstractProcessInstanceModificationCommand> instructions = this.builder.getInstructions();
        Collection<String> processInstanceIds = this.collectProcessInstanceIds();
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "Restart instructions cannot be empty", "instructions", instructions);
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "Process instance ids cannot be empty", "processInstanceIds", processInstanceIds);
        EnsureUtil.ensureNotContainsNull(BadUserRequestException.class, "Process instance ids cannot be null", "processInstanceIds", processInstanceIds);
        commandContext.getAuthorizationManager().checkAuthorization(Permissions.CREATE, Resources.BATCH);
        ProcessDefinitionEntity processDefinition = this.getProcessDefinition(commandContext, this.builder.getProcessDefinitionId());
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "Process definition cannot be null", (Object)processDefinition);
        this.ensureTenantAuthorized(commandContext, processDefinition);
        this.writeUserOperationLog(commandContext, processDefinition, processInstanceIds.size(), true);
        ArrayList<String> ids = new ArrayList<String>();
        ids.addAll(processInstanceIds);
        BatchEntity batch = this.createBatch(commandContext, instructions, ids, processDefinition);
        batch.createSeedJobDefinition();
        batch.createMonitorJobDefinition();
        batch.createBatchJobDefinition();
        batch.fireHistoricStartEvent();
        batch.createSeedJob();
        return batch;
    }

    protected BatchEntity createBatch(CommandContext commandContext, List<AbstractProcessInstanceModificationCommand> instructions, List<String> processInstanceIds, ProcessDefinitionEntity processDefinition) {
        ProcessEngineConfigurationImpl processEngineConfiguration = commandContext.getProcessEngineConfiguration();
        BatchJobHandler<RestartProcessInstancesBatchConfiguration> batchJobHandler = this.getBatchJobHandler(processEngineConfiguration);
        RestartProcessInstancesBatchConfiguration configuration = new RestartProcessInstancesBatchConfiguration(processInstanceIds, instructions, this.builder.getProcessDefinitionId(), this.builder.isInitialVariables(), this.builder.isSkipCustomListeners(), this.builder.isSkipIoMappings(), this.builder.isWithoutBusinessKey());
        BatchEntity batch = new BatchEntity();
        batch.setType(batchJobHandler.getType());
        batch.setTotalJobs(this.calculateSize(processEngineConfiguration, configuration));
        batch.setBatchJobsPerSeed(processEngineConfiguration.getBatchJobsPerSeed());
        batch.setInvocationsPerBatchJob(processEngineConfiguration.getInvocationsPerBatchJob());
        batch.setConfigurationBytes(batchJobHandler.writeConfiguration(configuration));
        batch.setTenantId(processDefinition.getTenantId());
        commandContext.getBatchManager().insertBatch(batch);
        return batch;
    }

    protected int calculateSize(ProcessEngineConfigurationImpl engineConfiguration, RestartProcessInstancesBatchConfiguration batchConfiguration) {
        int invocationsPerBatchJob = engineConfiguration.getInvocationsPerBatchJob();
        int processInstanceCount = batchConfiguration.getIds().size();
        return (int)Math.ceil(processInstanceCount / invocationsPerBatchJob);
    }

    protected BatchJobHandler<RestartProcessInstancesBatchConfiguration> getBatchJobHandler(ProcessEngineConfigurationImpl processEngineConfiguration) {
        Map<String, BatchJobHandler<?>> batchHandlers = processEngineConfiguration.getBatchHandlers();
        return batchHandlers.get("instance-restart");
    }

    protected void ensureTenantAuthorized(CommandContext commandContext, ProcessDefinitionEntity processDefinition) {
        if (!commandContext.getTenantManager().isAuthenticatedTenant(processDefinition.getTenantId())) {
            throw this.LOG.exceptionCommandWithUnauthorizedTenant("restart process instances of process definition '" + processDefinition.getId() + "'");
        }
    }
}

