/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.parser;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.impl.bpmn.helper.BpmnProperties;
import org.camunda.bpm.engine.impl.core.model.CallableElement;
import org.camunda.bpm.engine.impl.el.Expression;
import org.camunda.bpm.engine.impl.el.StartProcessVariableScope;
import org.camunda.bpm.engine.impl.event.EventType;
import org.camunda.bpm.engine.impl.jobexecutor.EventSubscriptionJobDeclaration;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.PvmScope;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.LegacyBehavior;

public class EventSubscriptionDeclaration
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final EventType eventType;
    protected final Expression eventName;
    protected final CallableElement eventPayload;
    protected boolean async;
    protected String activityId = null;
    protected String eventScopeActivityId = null;
    protected boolean isStartEvent;
    protected EventSubscriptionJobDeclaration jobDeclaration = null;

    public EventSubscriptionDeclaration(Expression eventExpression, EventType eventType) {
        this.eventName = eventExpression;
        this.eventType = eventType;
        this.eventPayload = null;
    }

    public EventSubscriptionDeclaration(Expression eventExpression, EventType eventType, CallableElement eventPayload) {
        this.eventType = eventType;
        this.eventName = eventExpression;
        this.eventPayload = eventPayload;
    }

    public static Map<String, EventSubscriptionDeclaration> getDeclarationsForScope(PvmScope scope) {
        if (scope == null) {
            return Collections.emptyMap();
        }
        return scope.getProperties().get(BpmnProperties.EVENT_SUBSCRIPTION_DECLARATIONS);
    }

    public String getUnresolvedEventName() {
        return this.eventName.getExpressionText();
    }

    public boolean hasEventName() {
        return this.eventName != null && !"".equalsIgnoreCase(this.getUnresolvedEventName().trim());
    }

    public boolean isEventNameLiteralText() {
        return this.eventName.isLiteralText();
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public String getEventScopeActivityId() {
        return this.eventScopeActivityId;
    }

    public void setEventScopeActivityId(String eventScopeActivityId) {
        this.eventScopeActivityId = eventScopeActivityId;
    }

    public boolean isStartEvent() {
        return this.isStartEvent;
    }

    public void setStartEvent(boolean isStartEvent) {
        this.isStartEvent = isStartEvent;
    }

    public String getEventType() {
        return this.eventType.name();
    }

    public CallableElement getEventPayload() {
        return this.eventPayload;
    }

    public void setJobDeclaration(EventSubscriptionJobDeclaration jobDeclaration) {
        this.jobDeclaration = jobDeclaration;
    }

    public EventSubscriptionEntity createSubscriptionForStartEvent(ProcessDefinitionEntity processDefinition) {
        EventSubscriptionEntity eventSubscriptionEntity = new EventSubscriptionEntity(this.eventType);
        StartProcessVariableScope scopeForExpression = StartProcessVariableScope.getSharedInstance();
        String eventName = this.resolveExpressionOfEventName(scopeForExpression);
        eventSubscriptionEntity.setEventName(eventName);
        eventSubscriptionEntity.setActivityId(this.activityId);
        eventSubscriptionEntity.setConfiguration(processDefinition.getId());
        eventSubscriptionEntity.setTenantId(processDefinition.getTenantId());
        return eventSubscriptionEntity;
    }

    public EventSubscriptionEntity createSubscriptionForExecution(ExecutionEntity execution) {
        EventSubscriptionEntity eventSubscriptionEntity = new EventSubscriptionEntity(execution, this.eventType);
        String eventName = this.resolveExpressionOfEventName(execution);
        eventSubscriptionEntity.setEventName(eventName);
        if (this.activityId != null) {
            ActivityImpl activity = execution.getProcessDefinition().findActivity(this.activityId);
            eventSubscriptionEntity.setActivity(activity);
        }
        eventSubscriptionEntity.insert();
        LegacyBehavior.removeLegacySubscriptionOnParent(execution, eventSubscriptionEntity);
        return eventSubscriptionEntity;
    }

    public String resolveExpressionOfEventName(VariableScope scope) {
        if (this.isExpressionAvailable()) {
            return (String)this.eventName.getValue(scope);
        }
        return null;
    }

    protected boolean isExpressionAvailable() {
        return this.eventName != null;
    }

    public void updateSubscription(EventSubscriptionEntity eventSubscription) {
        String eventName = this.resolveExpressionOfEventName(eventSubscription.getExecution());
        eventSubscription.setEventName(eventName);
        eventSubscription.setActivityId(this.activityId);
    }
}

