/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd.batch;

import java.util.List;
import org.camunda.bpm.engine.impl.batch.BatchConfiguration;
import org.camunda.bpm.engine.impl.batch.BatchEntity;
import org.camunda.bpm.engine.impl.batch.BatchJobHandler;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmd.batch.AbstractBatchCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;

public abstract class AbstractIDBasedBatchCmd<T>
extends AbstractBatchCmd<T> {
    protected BatchEntity createBatch(CommandContext commandContext, List<String> ids) {
        ProcessEngineConfigurationImpl processEngineConfiguration = commandContext.getProcessEngineConfiguration();
        BatchJobHandler batchJobHandler = this.getBatchJobHandler(processEngineConfiguration);
        BatchConfiguration configuration = this.getAbstractIdsBatchConfiguration(ids);
        BatchEntity batch = new BatchEntity();
        batch.setType(batchJobHandler.getType());
        batch.setTotalJobs(this.calculateSize(processEngineConfiguration, configuration));
        batch.setBatchJobsPerSeed(processEngineConfiguration.getBatchJobsPerSeed());
        batch.setInvocationsPerBatchJob(processEngineConfiguration.getInvocationsPerBatchJob());
        batch.setConfigurationBytes(batchJobHandler.writeConfiguration(configuration));
        commandContext.getBatchManager().insertBatch(batch);
        return batch;
    }

    protected int calculateSize(ProcessEngineConfigurationImpl engineConfiguration, BatchConfiguration batchConfiguration) {
        int invocationsPerBatchJob = engineConfiguration.getInvocationsPerBatchJob();
        int processInstanceCount = batchConfiguration.getIds().size();
        return (int)Math.ceil(processInstanceCount / invocationsPerBatchJob);
    }

    protected abstract BatchConfiguration getAbstractIdsBatchConfiguration(List<String> var1);

    protected abstract BatchJobHandler getBatchJobHandler(ProcessEngineConfigurationImpl var1);
}

