/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.jobexecutor;

import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutorLogger;
import org.camunda.bpm.engine.impl.jobexecutor.TimerEventJobHandler;
import org.camunda.bpm.engine.impl.persistence.deploy.cache.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.repository.ProcessDefinition;

public class TimerStartEventJobHandler
extends TimerEventJobHandler {
    private static final JobExecutorLogger LOG = ProcessEngineLogger.JOB_EXECUTOR_LOGGER;
    public static final String TYPE = "timer-start-event";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void execute(TimerEventJobHandler.TimerJobConfiguration configuration, ExecutionEntity execution, CommandContext commandContext, String tenantId) {
        DeploymentCache deploymentCache = Context.getProcessEngineConfiguration().getDeploymentCache();
        String definitionKey = configuration.getTimerElementKey();
        ProcessDefinitionEntity processDefinition = deploymentCache.findDeployedLatestProcessDefinitionByKeyAndTenantId(definitionKey, tenantId);
        this.startProcessInstance(commandContext, tenantId, processDefinition);
    }

    protected void startProcessInstance(CommandContext commandContext, String tenantId, ProcessDefinition processDefinition) {
        if (!processDefinition.isSuspended()) {
            RuntimeService runtimeService = commandContext.getProcessEngineConfiguration().getRuntimeService();
            runtimeService.createProcessInstanceByKey(processDefinition.getKey()).processDefinitionTenantId(tenantId).execute();
        } else {
            LOG.ignoringSuspendedJob(processDefinition);
        }
    }
}

