/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.deploy.cache;

import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.persistence.AbstractResourceDefinitionManager;
import org.camunda.bpm.engine.impl.persistence.deploy.cache.CacheDeployer;
import org.camunda.bpm.engine.impl.persistence.deploy.cache.CacheFactory;
import org.camunda.bpm.engine.impl.persistence.deploy.cache.ResourceDefinitionCache;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class ProcessDefinitionCache
extends ResourceDefinitionCache<ProcessDefinitionEntity> {
    public ProcessDefinitionCache(CacheFactory factory, int cacheCapacity, CacheDeployer cacheDeployer) {
        super(factory, cacheCapacity, cacheDeployer);
    }

    @Override
    protected AbstractResourceDefinitionManager<ProcessDefinitionEntity> getManager() {
        return Context.getCommandContext().getProcessDefinitionManager();
    }

    @Override
    protected void checkInvalidDefinitionId(String definitionId) {
        EnsureUtil.ensureNotNull("Invalid process definition id", "processDefinitionId", (Object)definitionId);
    }

    @Override
    protected void checkDefinitionFound(String definitionId, ProcessDefinitionEntity definition) {
        EnsureUtil.ensureNotNull("no deployed process definition found with id '" + definitionId + "'", "processDefinition", (Object)definition);
    }

    @Override
    protected void checkInvalidDefinitionByKey(String definitionKey, ProcessDefinitionEntity definition) {
        EnsureUtil.ensureNotNull("no processes deployed with key '" + definitionKey + "'", "processDefinition", (Object)definition);
    }

    @Override
    protected void checkInvalidDefinitionByKeyAndTenantId(String definitionKey, String tenantId, ProcessDefinitionEntity definition) {
        EnsureUtil.ensureNotNull("no processes deployed with key '" + definitionKey + "' and tenant-id '" + tenantId + "'", "processDefinition", (Object)definition);
    }

    @Override
    protected void checkInvalidDefinitionByKeyVersionAndTenantId(String definitionKey, Integer definitionVersion, String tenantId, ProcessDefinitionEntity definition) {
        EnsureUtil.ensureNotNull("no processes deployed with key = '" + definitionKey + "', version = '" + definitionVersion + "' and tenant-id = '" + tenantId + "'", "processDefinition", (Object)definition);
    }

    @Override
    protected void checkInvalidDefinitionByKeyVersionTagAndTenantId(String definitionKey, String definitionVersionTag, String tenantId, ProcessDefinitionEntity definition) {
        EnsureUtil.ensureNotNull("no processes deployed with key = '" + definitionKey + "', versionTag = '" + definitionVersionTag + "' and tenant-id = '" + tenantId + "'", "processDefinition", (Object)definition);
    }

    @Override
    protected void checkInvalidDefinitionByDeploymentAndKey(String deploymentId, String definitionKey, ProcessDefinitionEntity definition) {
        EnsureUtil.ensureNotNull("no processes deployed with key = '" + definitionKey + "' in deployment = '" + deploymentId + "'", "processDefinition", (Object)definition);
    }

    @Override
    protected void checkInvalidDefinitionWasCached(String deploymentId, String definitionId, ProcessDefinitionEntity definition) {
        EnsureUtil.ensureNotNull("deployment '" + deploymentId + "' didn't put process definition '" + definitionId + "' in the cache", "cachedProcessDefinition", (Object)definition);
    }
}

