/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.history.HistoricJobLog;
import org.camunda.bpm.engine.impl.HistoricJobLogQueryImpl;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.ListQueryParameterObject;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbOperation;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.impl.history.event.HistoryEventProcessor;
import org.camunda.bpm.engine.impl.history.event.HistoryEventType;
import org.camunda.bpm.engine.impl.history.event.HistoryEventTypes;
import org.camunda.bpm.engine.impl.history.producer.HistoryEventProducer;
import org.camunda.bpm.engine.impl.persistence.AbstractHistoricManager;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricJobLogEventEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.runtime.Job;

public class HistoricJobLogManager
extends AbstractHistoricManager {
    public HistoricJobLogEventEntity findHistoricJobLogById(String historicJobLogId) {
        return (HistoricJobLogEventEntity)this.getDbEntityManager().selectOne("selectHistoricJobLog", historicJobLogId);
    }

    public List<HistoricJobLog> findHistoricJobLogsByDeploymentId(String deploymentId) {
        return this.getDbEntityManager().selectList("selectHistoricJobLogByDeploymentId", deploymentId);
    }

    public List<HistoricJobLog> findHistoricJobLogsByQueryCriteria(HistoricJobLogQueryImpl query, Page page) {
        this.configureQuery(query);
        return this.getDbEntityManager().selectList("selectHistoricJobLogByQueryCriteria", query, page);
    }

    public long findHistoricJobLogsCountByQueryCriteria(HistoricJobLogQueryImpl query) {
        this.configureQuery(query);
        return (Long)this.getDbEntityManager().selectOne("selectHistoricJobLogCountByQueryCriteria", query);
    }

    public void addRemovalTimeToJobLogByRootProcessInstanceId(String rootProcessInstanceId, Date removalTime) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("rootProcessInstanceId", rootProcessInstanceId);
        parameters.put("removalTime", removalTime);
        this.getDbEntityManager().updatePreserveOrder(HistoricJobLogEventEntity.class, "updateJobLogByRootProcessInstanceId", parameters);
    }

    public void addRemovalTimeToJobLogByBatchId(String batchId, Date removalTime) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("batchId", batchId);
        parameters.put("removalTime", removalTime);
        this.getDbEntityManager().updatePreserveOrder(HistoricJobLogEventEntity.class, "updateJobLogByBatchId", parameters);
    }

    public void deleteHistoricJobLogById(String id) {
        if (this.isHistoryEnabled()) {
            this.deleteExceptionByteArrayByParameterMap("id", id);
            this.getDbEntityManager().delete(HistoricJobLogEventEntity.class, "deleteHistoricJobLogById", id);
        }
    }

    public void deleteHistoricJobLogByJobId(String jobId) {
        if (this.isHistoryEnabled()) {
            this.deleteExceptionByteArrayByParameterMap("jobId", jobId);
            this.getDbEntityManager().delete(HistoricJobLogEventEntity.class, "deleteHistoricJobLogByJobId", jobId);
        }
    }

    public void deleteHistoricJobLogsByProcessInstanceIds(List<String> processInstanceIds) {
        this.deleteExceptionByteArrayByParameterMap("processInstanceIdIn", processInstanceIds.toArray());
        this.getDbEntityManager().deletePreserveOrder(HistoricJobLogEventEntity.class, "deleteHistoricJobLogByProcessInstanceIds", processInstanceIds);
    }

    public void deleteHistoricJobLogsByProcessDefinitionId(String processDefinitionId) {
        if (this.isHistoryEnabled()) {
            this.deleteExceptionByteArrayByParameterMap("processDefinitionId", processDefinitionId);
            this.getDbEntityManager().delete(HistoricJobLogEventEntity.class, "deleteHistoricJobLogByProcessDefinitionId", processDefinitionId);
        }
    }

    public void deleteHistoricJobLogsByDeploymentId(String deploymentId) {
        if (this.isHistoryEnabled()) {
            this.deleteExceptionByteArrayByParameterMap("deploymentId", deploymentId);
            this.getDbEntityManager().delete(HistoricJobLogEventEntity.class, "deleteHistoricJobLogByDeploymentId", deploymentId);
        }
    }

    public void deleteHistoricJobLogsByHandlerType(String handlerType) {
        if (this.isHistoryEnabled()) {
            this.deleteExceptionByteArrayByParameterMap("handlerType", handlerType);
            this.getDbEntityManager().delete(HistoricJobLogEventEntity.class, "deleteHistoricJobLogByHandlerType", handlerType);
        }
    }

    public void deleteHistoricJobLogsByJobDefinitionId(String jobDefinitionId) {
        if (this.isHistoryEnabled()) {
            this.deleteExceptionByteArrayByParameterMap("jobDefinitionId", jobDefinitionId);
            this.getDbEntityManager().delete(HistoricJobLogEventEntity.class, "deleteHistoricJobLogByJobDefinitionId", jobDefinitionId);
        }
    }

    public void deleteHistoricJobLogByBatchIds(List<String> historicBatchIds) {
        if (this.isHistoryEnabled()) {
            this.deleteExceptionByteArrayByParameterMap("historicBatchIdIn", historicBatchIds);
            this.getDbEntityManager().delete(HistoricJobLogEventEntity.class, "deleteHistoricJobLogByBatchIds", historicBatchIds);
        }
    }

    public DbOperation deleteJobLogByRemovalTime(Date removalTime, int minuteFrom, int minuteTo, int batchSize) {
        HashMap<String, Comparable<Date>> parameters = new HashMap<String, Comparable<Date>>();
        parameters.put("removalTime", removalTime);
        if (minuteTo - minuteFrom + 1 < 60) {
            parameters.put("minuteFrom", Integer.valueOf(minuteFrom));
            parameters.put("minuteTo", Integer.valueOf(minuteTo));
        }
        parameters.put("batchSize", Integer.valueOf(batchSize));
        return this.getDbEntityManager().deletePreserveOrder(HistoricJobLogEventEntity.class, "deleteJobLogByRemovalTime", new ListQueryParameterObject(parameters, 0, batchSize));
    }

    protected void deleteExceptionByteArrayByParameterMap(String key, Object value) {
        EnsureUtil.ensureNotNull(key, value);
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        parameterMap.put(key, value);
        this.getDbEntityManager().delete(ByteArrayEntity.class, "deleteExceptionByteArraysByIds", parameterMap);
    }

    public void fireJobCreatedEvent(final Job job) {
        if (this.isHistoryEventProduced(HistoryEventTypes.JOB_CREATE, job)) {
            HistoryEventProcessor.processHistoryEvents(new HistoryEventProcessor.HistoryEventCreator(){

                @Override
                public HistoryEvent createHistoryEvent(HistoryEventProducer producer) {
                    return producer.createHistoricJobLogCreateEvt(job);
                }
            });
        }
    }

    public void fireJobFailedEvent(final Job job, final Throwable exception) {
        if (this.isHistoryEventProduced(HistoryEventTypes.JOB_FAIL, job)) {
            HistoryEventProcessor.processHistoryEvents(new HistoryEventProcessor.HistoryEventCreator(){

                @Override
                public HistoryEvent createHistoryEvent(HistoryEventProducer producer) {
                    return producer.createHistoricJobLogFailedEvt(job, exception);
                }
            });
        }
    }

    public void fireJobSuccessfulEvent(final Job job) {
        if (this.isHistoryEventProduced(HistoryEventTypes.JOB_SUCCESS, job)) {
            HistoryEventProcessor.processHistoryEvents(new HistoryEventProcessor.HistoryEventCreator(){

                @Override
                public HistoryEvent createHistoryEvent(HistoryEventProducer producer) {
                    return producer.createHistoricJobLogSuccessfulEvt(job);
                }
            });
        }
    }

    public void fireJobDeletedEvent(final Job job) {
        if (this.isHistoryEventProduced(HistoryEventTypes.JOB_DELETE, job)) {
            HistoryEventProcessor.processHistoryEvents(new HistoryEventProcessor.HistoryEventCreator(){

                @Override
                public HistoryEvent createHistoryEvent(HistoryEventProducer producer) {
                    return producer.createHistoricJobLogDeleteEvt(job);
                }
            });
        }
    }

    protected boolean isHistoryEventProduced(HistoryEventType eventType, Job job) {
        ProcessEngineConfigurationImpl configuration = Context.getProcessEngineConfiguration();
        HistoryLevel historyLevel = configuration.getHistoryLevel();
        return historyLevel.isHistoryEventProduced(eventType, job);
    }

    protected void configureQuery(HistoricJobLogQueryImpl query) {
        this.getAuthorizationManager().configureHistoricJobLogQuery(query);
        this.getTenantManager().configureQuery(query);
    }
}

