/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.cockpit.impl.plugin.base.sub.resources;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.cockpit.impl.plugin.base.dto.ProcessDefinitionDto;
import org.camunda.bpm.cockpit.impl.plugin.base.dto.query.ProcessDefinitionQueryDto;
import org.camunda.bpm.cockpit.plugin.resource.AbstractPluginResource;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;

public class ProcessDefinitionResource
extends AbstractPluginResource {
    protected String id;

    public ProcessDefinitionResource(String engineName, String id) {
        super(engineName);
        this.id = id;
    }

    @GET
    @Path(value="/called-process-definitions")
    @Produces(value={"application/json"})
    public List<ProcessDefinitionDto> getCalledProcessDefinitions(@Context UriInfo uriInfo) {
        ProcessDefinitionQueryDto queryParameter = new ProcessDefinitionQueryDto((MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryCalledProcessDefinitions(queryParameter);
    }

    @POST
    @Path(value="/called-process-definitions")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public List<ProcessDefinitionDto> queryCalledProcessDefinitions(final ProcessDefinitionQueryDto queryParameter) {
        return this.getCommandExecutor().executeCommand(new Command<List<ProcessDefinitionDto>>(){

            public List<ProcessDefinitionDto> execute(CommandContext commandContext) {
                queryParameter.setParentProcessDefinitionId(ProcessDefinitionResource.this.id);
                ProcessDefinitionResource.this.injectEngineConfig(queryParameter);
                ProcessDefinitionResource.this.configureExecutionQuery(queryParameter);
                return ProcessDefinitionResource.this.getQueryService().executeQuery("selectCalledProcessDefinitions", queryParameter);
            }
        });
    }

    private void injectEngineConfig(ProcessDefinitionQueryDto parameter) {
        ProcessEngineConfigurationImpl processEngineConfiguration = ((ProcessEngineImpl)this.getProcessEngine()).getProcessEngineConfiguration();
        if (processEngineConfiguration.getHistoryLevel().equals(HistoryLevel.HISTORY_LEVEL_NONE)) {
            parameter.setHistoryEnabled(false);
        }
        parameter.initQueryVariableValues(processEngineConfiguration.getVariableSerializers());
    }

    protected void configureExecutionQuery(ProcessDefinitionQueryDto query) {
        this.configureAuthorizationCheck(query);
        this.configureTenantCheck(query);
        this.addPermissionCheck(query, (Resource)Resources.PROCESS_INSTANCE, "EXEC2.PROC_INST_ID_", (Permission)Permissions.READ);
        this.addPermissionCheck(query, (Resource)Resources.PROCESS_DEFINITION, "PROCDEF.KEY_", (Permission)Permissions.READ_INSTANCE);
    }
}

