/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import org.apache.commons.lang.StringUtils;
import org.codehaus.mojo.versions.AbstractVersionsUpdaterMojo;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractVersionsDisplayMojo
extends AbstractVersionsUpdaterMojo {
    private File outputFile;
    private boolean logOutput;
    private String outputEncoding;
    private boolean outputFileError = false;

    protected void logInit() {
        if (this.outputFile != null && !this.outputFileError) {
            if (this.outputFile.isFile()) {
                String outputFileName;
                String key = AbstractVersionsDisplayMojo.class.getName() + ".outputFile";
                try {
                    outputFileName = this.outputFile.getCanonicalPath();
                }
                catch (IOException e) {
                    outputFileName = this.outputFile.getAbsolutePath();
                }
                LinkedHashSet<String> files = (LinkedHashSet<String>)this.getPluginContext().get(key);
                files = files == null ? new LinkedHashSet<String>() : new LinkedHashSet(files);
                if (!files.contains(outputFileName) && !this.outputFile.delete()) {
                    this.getLog().error((CharSequence)("Cannot delete " + this.outputFile + " will append instead"));
                }
                files.add(outputFileName);
                this.getPluginContext().put(key, files);
            } else if (this.outputFile.exists()) {
                this.getLog().error((CharSequence)("Cannot send output to " + this.outputFile + " as it exists but is not a file"));
                this.outputFileError = true;
            } else if (!this.outputFile.getParentFile().isDirectory() && !this.outputFile.getParentFile().mkdirs()) {
                this.outputFileError = true;
            }
            if (!this.outputFileError && StringUtils.isBlank((String)this.outputEncoding)) {
                this.outputEncoding = System.getProperty("file.encoding");
                this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + this.outputEncoding + ", i.e. build is platform dependent!"));
            }
        }
    }

    protected void logLine(boolean error, String line) {
        if (this.logOutput) {
            if (error) {
                this.getLog().error((CharSequence)line);
            } else {
                this.getLog().info((CharSequence)line);
            }
        }
        if (this.outputFile != null && !this.outputFileError) {
            try {
                FileUtils.fileAppend((String)this.outputFile.getAbsolutePath(), (String)this.outputEncoding, (String)(error ? "> " + line + System.getProperty("line.separator") : line + System.getProperty("line.separator")));
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Cannot send output to " + this.outputFile), (Throwable)e);
                this.outputFileError = true;
            }
        }
    }
}

