/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.SharedBlockingCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpInputOverHTTP
extends HttpInput
implements Callback {
    private static final Logger LOG = Log.getLogger(HttpInputOverHTTP.class);
    private final SharedBlockingCallback _readBlocker = new SharedBlockingCallback();
    private final HttpConnection _httpConnection;
    private HttpInput.Content _content;

    public HttpInputOverHTTP(HttpConnection httpConnection) {
        this._httpConnection = httpConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recycle() {
        Object object = this.lock();
        synchronized (object) {
            super.recycle();
            this._content = null;
        }
    }

    @Override
    protected void blockForContent() throws IOException {
        HttpInput.Content content;
        do {
            try (SharedBlockingCallback.Blocker blocker = this._readBlocker.acquire();){
                this._httpConnection.fillInterested((Callback)blocker);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} block readable on {}", new Object[]{this, blocker});
                }
                blocker.block();
            }
        } while ((content = this.getNextContent()) == null && !this.isFinished());
    }

    public String toString() {
        return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
    }

    @Override
    protected HttpInput.Content nextContent() throws IOException {
        if (this._content != null && this._content.hasContent()) {
            return this._content;
        }
        this._content = null;
        this._httpConnection.parseContent();
        if (this._content != null && this._content.hasContent()) {
            return this._content;
        }
        return null;
    }

    @Override
    public void content(HttpInput.Content item) {
        if (this._content != null && this._content.hasContent()) {
            throw new IllegalStateException();
        }
        this._content = item;
    }

    @Override
    protected void unready() {
        this._httpConnection.fillInterested(this);
    }

    public void succeeded() {
        this._httpConnection.getHttpChannel().getState().onReadPossible();
    }

    @Override
    public void failed(Throwable x) {
        super.failed(x);
        this._httpConnection.getHttpChannel().getState().onReadPossible();
    }
}

