/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.jcache;

import java.lang.management.ManagementFactory;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Configuration;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Status;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.CacheWriterConfiguration;
import net.sf.ehcache.config.CopyStrategyConfiguration;
import net.sf.ehcache.store.compound.ReadWriteCopyStrategy;
import org.ehcache.jcache.JCache;
import org.ehcache.jcache.JCacheCachingProvider;
import org.ehcache.jcache.JCacheConfiguration;
import org.ehcache.jcache.JCacheCopyOnWriteStrategy;
import org.ehcache.jcache.JCacheMXBean;
import org.ehcache.jcache.JCacheManagementMXBean;
import org.ehcache.jcache.JCacheStatMXBean;

public class JCacheManager
implements CacheManager {
    private static MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
    private static final int DEFAULT_SIZE = 1000;
    private final JCacheCachingProvider jCacheCachingProvider;
    private final net.sf.ehcache.CacheManager cacheManager;
    private final URI uri;
    private final Properties props;
    private final ConcurrentHashMap<String, JCache> allCaches = new ConcurrentHashMap();
    private volatile boolean closed = false;
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final ConcurrentMap<JCache, JCacheManagementMXBean> cfgMXBeans = new ConcurrentHashMap<JCache, JCacheManagementMXBean>();
    private final ConcurrentMap<JCache, JCacheStatMXBean> statMXBeans = new ConcurrentHashMap<JCache, JCacheStatMXBean>();

    public JCacheManager(JCacheCachingProvider jCacheCachingProvider, net.sf.ehcache.CacheManager cacheManager, URI uri, Properties props) {
        this.jCacheCachingProvider = jCacheCachingProvider;
        this.cacheManager = cacheManager;
        this.uri = uri;
        this.props = props;
        this.refreshAllCaches();
    }

    public JCacheCachingProvider getCachingProvider() {
        return this.jCacheCachingProvider;
    }

    public URI getURI() {
        return this.uri;
    }

    public ClassLoader getClassLoader() {
        return this.cacheManager.getConfiguration().getClassLoader();
    }

    public Properties getProperties() {
        return this.props;
    }

    public <K, V, C extends Configuration<K, V>> javax.cache.Cache<K, V> createCache(String cacheName, C configuration) throws IllegalArgumentException {
        this.checkNotClosed();
        if (configuration == null) {
            throw new NullPointerException();
        }
        JCache jCache = this.allCaches.get(cacheName);
        if (jCache != null) {
            throw new CacheException();
        }
        this.cacheManager.addCacheIfAbsent((Ehcache)new Cache(this.toEhcacheConfig(cacheName, configuration)));
        Ehcache ehcache = this.cacheManager.getEhcache(cacheName);
        JCacheConfiguration cfg = new JCacheConfiguration(configuration);
        jCache = new JCache(this, cfg, ehcache);
        JCache previous = this.allCaches.putIfAbsent(cacheName, jCache);
        if (previous != null) {
            return previous;
        }
        if (cfg.isStatisticsEnabled()) {
            this.enableStatistics(cacheName, true);
        }
        if (cfg.isManagementEnabled()) {
            this.enableManagement(cacheName, true);
        }
        return jCache;
    }

    public <K, V> javax.cache.Cache<K, V> getCache(String cacheName, Class<K> keyType, Class<V> valueType) {
        this.checkNotClosed();
        if (valueType == null) {
            throw new NullPointerException();
        }
        JCache<K, V> jCache = this.allCaches.get(cacheName);
        if (jCache != null) {
            if (!keyType.isAssignableFrom(jCache.getConfiguration(CompleteConfiguration.class).getKeyType())) {
                throw new ClassCastException();
            }
            if (!valueType.isAssignableFrom(jCache.getConfiguration(CompleteConfiguration.class).getValueType())) {
                throw new ClassCastException();
            }
            return jCache;
        }
        Cache cache = this.cacheManager.getCache(cacheName);
        if (cache == null) {
            return null;
        }
        jCache = new JCache<K, V>(this, new JCacheConfiguration<K, V>(null, null, keyType, valueType), (Ehcache)cache);
        JCache<K, V> previous = this.allCaches.putIfAbsent(cacheName, jCache);
        if (previous != null) {
            jCache = previous;
        }
        if (!keyType.isAssignableFrom(jCache.getConfiguration(CompleteConfiguration.class).getKeyType())) {
            throw new ClassCastException();
        }
        if (!valueType.isAssignableFrom(jCache.getConfiguration(CompleteConfiguration.class).getValueType())) {
            throw new ClassCastException();
        }
        return jCache;
    }

    public <K, V> javax.cache.Cache<K, V> getCache(String cacheName) {
        JCache jCache = this.allCaches.get(cacheName);
        if (jCache == null) {
            this.refreshAllCaches();
            return this.allCaches.get(cacheName);
        }
        if (jCache.getConfiguration(CompleteConfiguration.class).getKeyType() != Object.class || jCache.getConfiguration(CompleteConfiguration.class).getValueType() != Object.class) {
            throw new IllegalArgumentException();
        }
        return jCache;
    }

    public Iterable<String> getCacheNames() {
        return Collections.unmodifiableSet(new HashSet(this.allCaches.keySet()));
    }

    public void destroyCache(String cacheName) {
        this.checkNotClosed();
        JCache jCache = this.allCaches.get(cacheName);
        if (jCache != null) {
            jCache.close();
        }
    }

    public void enableManagement(String cacheName, boolean enabled) {
        this.checkNotClosed();
        if (cacheName == null) {
            throw new NullPointerException();
        }
        JCache jCache = this.allCaches.get(cacheName);
        if (jCache == null) {
            throw new NullPointerException();
        }
        this.enableManagement(enabled, jCache);
    }

    private void enableManagement(boolean enabled, JCache jCache) {
        try {
            if (enabled) {
                this.registerObject(this.getOrCreateCfgObject(jCache));
            } else {
                this.unregisterObject((JCacheMXBean)this.cfgMXBeans.remove(jCache));
            }
            jCache.getConfiguration(JCacheConfiguration.class).setManagementEnabled(enabled);
        }
        catch (NotCompliantMBeanException e) {
            throw new CacheException((Throwable)e);
        }
        catch (InstanceAlreadyExistsException e) {
        }
        catch (MBeanRegistrationException e) {
            throw new CacheException((Throwable)e);
        }
        catch (InstanceNotFoundException e) {
        }
        catch (MalformedObjectNameException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void enableStatistics(String cacheName, boolean enabled) {
        this.checkNotClosed();
        if (cacheName == null) {
            throw new NullPointerException();
        }
        JCache jCache = this.allCaches.get(cacheName);
        if (jCache == null) {
            throw new NullPointerException();
        }
        this.enableStatistics(enabled, jCache);
    }

    private void enableStatistics(boolean enabled, JCache jCache) {
        try {
            if (enabled) {
                this.registerObject(this.getOrCreateStatObject(jCache));
            } else {
                this.unregisterObject((JCacheMXBean)this.statMXBeans.remove(jCache));
            }
            jCache.getConfiguration(JCacheConfiguration.class).setStatisticsEnabled(enabled);
        }
        catch (NotCompliantMBeanException e) {
            throw new CacheException((Throwable)e);
        }
        catch (InstanceAlreadyExistsException e) {
        }
        catch (MBeanRegistrationException e) {
            throw new CacheException((Throwable)e);
        }
        catch (InstanceNotFoundException e) {
        }
        catch (MalformedObjectNameException e) {
            throw new CacheException("Illegal ObjectName for Management Bean. CacheManager=[" + this.getURI().toString() + "], Cache=[" + jCache.getName() + "]", (Throwable)e);
        }
    }

    private void registerObject(JCacheMXBean cacheMXBean) throws NotCompliantMBeanException, InstanceAlreadyExistsException, MBeanRegistrationException, MalformedObjectNameException {
        ObjectName objectName = new ObjectName(cacheMXBean.getObjectName());
        if (mBeanServer.queryNames(objectName, null).isEmpty()) {
            mBeanServer.registerMBean(cacheMXBean, objectName);
        }
    }

    private void unregisterObject(JCacheMXBean cacheMXBean) throws MBeanRegistrationException, InstanceNotFoundException, MalformedObjectNameException {
        if (cacheMXBean == null) {
            return;
        }
        String name = cacheMXBean.getObjectName();
        ObjectName objectName = new ObjectName(name);
        for (ObjectName n : mBeanServer.queryNames(objectName, null)) {
            mBeanServer.unregisterMBean(n);
        }
    }

    private JCacheManagementMXBean getOrCreateCfgObject(JCache jCache) {
        JCacheManagementMXBean previous;
        JCacheManagementMXBean cacheMXBean = (JCacheManagementMXBean)this.cfgMXBeans.get(jCache);
        if (cacheMXBean == null && (previous = this.cfgMXBeans.putIfAbsent(jCache, cacheMXBean = new JCacheManagementMXBean(jCache))) != null) {
            cacheMXBean = previous;
        }
        return cacheMXBean;
    }

    private JCacheStatMXBean getOrCreateStatObject(JCache jCache) {
        JCacheStatMXBean previous;
        JCacheStatMXBean cacheMXBean = (JCacheStatMXBean)this.statMXBeans.get(jCache);
        if (cacheMXBean == null && (previous = this.statMXBeans.putIfAbsent(jCache, cacheMXBean = new JCacheStatMXBean(jCache))) != null) {
            cacheMXBean = previous;
        }
        return cacheMXBean;
    }

    public void close() {
        this.jCacheCachingProvider.shutdown(this);
    }

    void shutdown() {
        this.closed = true;
        for (JCache jCache : this.allCaches.values()) {
            jCache.close();
        }
        this.cacheManager.shutdown();
        this.allCaches.clear();
    }

    public boolean isClosed() {
        return this.cacheManager.getStatus() == Status.STATUS_SHUTDOWN;
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        if (clazz.isAssignableFrom(this.cacheManager.getClass())) {
            return clazz.cast(this.cacheManager);
        }
        throw new IllegalArgumentException();
    }

    private void refreshAllCaches() {
        for (String s : this.cacheManager.getCacheNames()) {
            Cache cache = this.cacheManager.getCache(s);
            if (cache == null) continue;
            this.allCaches.put(s, new JCache(this, new JCacheConfiguration(cache.getCacheConfiguration()), (Ehcache)cache));
        }
    }

    private CacheConfiguration toEhcacheConfig(String name, Configuration configuration) {
        int maxSize = this.cacheManager.getConfiguration().isMaxBytesLocalHeapSet() ? 0 : 1000;
        CacheConfiguration cfg = new CacheConfiguration(name, maxSize);
        cfg.setClassLoader(this.cacheManager.getConfiguration().getClassLoader());
        if (configuration.isStoreByValue()) {
            CopyStrategyConfiguration copyStrategyConfiguration = new CopyStrategyConfiguration();
            copyStrategyConfiguration.setCopyStrategyInstance((ReadWriteCopyStrategy)new JCacheCopyOnWriteStrategy());
            cfg.copyOnRead(true).copyOnWrite(true).addCopyStrategy(copyStrategyConfiguration);
        }
        if (configuration instanceof CompleteConfiguration && ((CompleteConfiguration)configuration).isWriteThrough()) {
            cfg.addCacheWriter(new CacheWriterConfiguration().writeMode(CacheWriterConfiguration.WriteMode.WRITE_THROUGH));
        }
        return cfg;
    }

    private void checkNotClosed() {
        if (this.closed) {
            throw new IllegalStateException();
        }
    }

    void shutdown(JCache jCache) {
        JCache r = this.allCaches.remove(jCache.getName());
        if (r == jCache) {
            this.enableStatistics(false, jCache);
            this.enableManagement(false, jCache);
            this.cacheManager.removeCache(jCache.getName());
            jCache.shutdown();
        }
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }
}

