/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.table.handler;

import org.apache.commons.lang.StringUtils;
import org.extremecomponents.table.bean.Column;
import org.extremecomponents.table.cell.Cell;
import org.extremecomponents.table.core.TableModel;
import org.extremecomponents.table.core.TableModelUtils;
import org.extremecomponents.table.handler.ExportHandler;
import org.extremecomponents.table.view.View;

public class ViewHandler {
    private TableModel model;
    private View view;

    public ViewHandler(TableModel model) {
        this.model = model;
    }

    public View getView() {
        return this.view;
    }

    public void setView(ExportHandler exportHandler) throws Exception {
        String preference;
        boolean isExported = this.model.getLimit().isExported();
        String currentView = null;
        if (isExported) {
            currentView = this.model.getExportHandler().getCurrentExport().getView();
            preference = this.model.getPreferences().getPreference("export.view." + currentView);
            if (StringUtils.isNotBlank((String)preference)) {
                currentView = preference;
            }
        } else {
            currentView = this.model.getTableHandler().getTable().getView();
            preference = this.model.getPreferences().getPreference("table.view." + currentView);
            if (StringUtils.isNotBlank((String)preference)) {
                currentView = preference;
            }
        }
        Class<?> classDefinition = Class.forName(currentView);
        this.view = (View)classDefinition.newInstance();
        this.getView().beforeBody(this.model, exportHandler);
    }

    public void addColumnValueToView(Column column) {
        Cell cell = TableModelUtils.getCell(column);
        boolean isExported = this.model.getLimit().isExported();
        if (!isExported) {
            column.setCellDisplay(cell.getHtmlDisplay(this.model, column));
        } else {
            column.setCellDisplay(cell.getExportDisplay(this.model, column));
        }
        this.getView().body(this.model, column);
    }
}

