/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.table.view.html;

import org.apache.commons.lang.StringUtils;
import org.extremecomponents.table.bean.Column;
import org.extremecomponents.table.core.TableModel;
import org.extremecomponents.table.limit.Sort;
import org.extremecomponents.table.view.html.BuilderUtils;

public class TableActions {
    private TableModel model;

    public TableActions(TableModel model) {
        this.model = model;
    }

    protected TableModel getTableModel() {
        return this.model;
    }

    public String getOnInvokeAction() {
        String onInvokeAction = this.model.getTableHandler().getTable().getOnInvokeAction();
        if (StringUtils.isNotBlank((String)onInvokeAction)) {
            return onInvokeAction;
        }
        return this.getSubmitAction();
    }

    public String getSubmitAction() {
        StringBuffer result = new StringBuffer();
        String form = BuilderUtils.getForm(this.model);
        String action = this.model.getTableHandler().getTable().getAction();
        result.append("document.forms.").append(form).append(".setAttribute('action','").append(action).append("');");
        String method = this.model.getTableHandler().getTable().getMethod();
        result.append("document.forms.").append(form).append(".setAttribute('method','").append(method).append("');");
        result.append("document.forms.").append(form).append(".submit()");
        return result.toString();
    }

    public String getFormParameter(String name, String value) {
        StringBuffer result = new StringBuffer();
        String form = BuilderUtils.getForm(this.model);
        result.append("document.forms.").append(form).append(".");
        result.append(this.model.getTableHandler().prefixWithTableId()).append(name);
        result.append(".value='").append(value).append("';");
        return result.toString();
    }

    public String getExportTableIdParameter(String value) {
        StringBuffer result = new StringBuffer();
        String form = BuilderUtils.getForm(this.model);
        result.append("document.forms.").append(form).append(".");
        result.append("ec_eti");
        result.append(".value='").append(value).append("';");
        return result.toString();
    }

    public String getExportAction(String exportView, String exportFileName) {
        StringBuffer action = new StringBuffer("javascript:");
        action.append(this.getExportTableIdParameter(this.model.getTableHandler().getTable().getTableId()));
        action.append(this.getFormParameter("ev", exportView));
        action.append(this.getFormParameter("efn", exportFileName));
        action.append(this.getSubmitAction());
        return action.toString();
    }

    public String getPageAction(int page) {
        StringBuffer action = new StringBuffer("javascript:");
        action.append(this.getClearedExportTableIdParameters());
        action.append(this.getFormParameter("p", "" + page));
        action.append(this.getOnInvokeAction());
        return action.toString();
    }

    public String getPageJumpAction() {
        StringBuffer action = new StringBuffer("javascript:");
        action.append(this.getClearedExportTableIdParameters());
        action.append(this.getPageJumpFormParameter("p"));
        action.append(this.getOnInvokeAction());
        return action.toString();
    }

    protected String getPageJumpFormParameter(String name) {
        StringBuffer result = new StringBuffer();
        String form = BuilderUtils.getForm(this.model);
        String selectedOption = "this.options[this.selectedIndex].value";
        result.append("document.forms.").append(form).append(".");
        result.append(this.model.getTableHandler().prefixWithTableId()).append(name);
        result.append(".value=").append(selectedOption).append(";");
        return result.toString();
    }

    public String getFilterAction() {
        StringBuffer action = new StringBuffer("javascript:");
        action.append(this.getClearedExportTableIdParameters());
        action.append(this.getFormParameter("f_a", "fa"));
        action.append(this.getFormParameter("p", "1"));
        action.append(this.getOnInvokeAction());
        return action.toString();
    }

    public String getClearAction() {
        StringBuffer action = new StringBuffer("javascript:");
        action.append(this.getClearedExportTableIdParameters());
        action.append(this.getFormParameter("f_a", "ca"));
        action.append(this.getFormParameter("p", "1"));
        action.append(this.getOnInvokeAction());
        return action.toString();
    }

    public String getSortAction(Column column, String sortOrder) {
        StringBuffer action = new StringBuffer("javascript:");
        Sort sort = this.model.getLimit().getSort();
        if (sort.isSorted()) {
            action.append(this.getFormParameter("s_" + sort.getAlias(), ""));
        }
        action.append(this.getClearedExportTableIdParameters());
        action.append(this.getFormParameter("s_" + column.getAlias(), sortOrder));
        action.append(this.getFormParameter("p", "1"));
        action.append(this.getOnInvokeAction());
        return action.toString();
    }

    public String getRowsDisplayedAction() {
        StringBuffer action = new StringBuffer("javascript:");
        action.append(this.getClearedExportTableIdParameters());
        action.append(this.getRowsDisplayedFormParameter("crd"));
        action.append(this.getFormParameter("p", "1"));
        action.append(this.getOnInvokeAction());
        return action.toString();
    }

    public String getClearedExportTableIdParameters() {
        if (BuilderUtils.showExports(this.model)) {
            return this.getExportTableIdParameter("");
        }
        return "";
    }

    protected String getRowsDisplayedFormParameter(String name) {
        StringBuffer result = new StringBuffer();
        String form = BuilderUtils.getForm(this.model);
        String selectedOption = "this.options[this.selectedIndex].value";
        result.append("document.forms.").append(form).append(".");
        result.append(this.model.getTableHandler().prefixWithTableId()).append(name);
        result.append(".value=").append(selectedOption).append(";");
        return result.toString();
    }
}

